/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scala.checks;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonarsource.scala.checks.PatternMatchHelper;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.api.MatchTree;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.DuplicateBranchCheck;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.utils.SyntacticEquivalence;

@Rule(key="S1871")
public class DuplicateBranchScalaCheck
extends DuplicateBranchCheck {
    @Override
    protected void checkDuplicatedBranches(CheckContext ctx, Tree matchTree, List<Tree> branches) {
        for (List<Tree> group : SyntacticEquivalence.findDuplicatedGroups(branches)) {
            Optional<TreeAndIndex> originalBlock = DuplicateBranchScalaCheck.findFirstCaseTreeWithoutPattern(matchTree, group);
            if (!originalBlock.isPresent()) continue;
            int shouldSkip = originalBlock.get().index + 1;
            group.stream().skip(shouldSkip).filter(x$0 -> DuplicateBranchCheck.spansMultipleLines(x$0)).filter(block -> !DuplicateBranchScalaCheck.hasPatternMatchCondition(matchTree, block)).forEach(duplicated -> {
                TextRange originalRange = ((TreeAndIndex)originalBlock.get()).tree.metaData().textRange();
                ctx.reportIssue((HasTextRange)duplicated, "This branch's code block is the same as the block for the branch on line " + originalRange.start().line() + ".", new SecondaryLocation(originalRange, "Original"));
            });
        }
    }

    private static Optional<TreeAndIndex> findFirstCaseTreeWithoutPattern(Tree matchTree, List<Tree> duplicatedCaseBlocks) {
        for (int i = 0; i < duplicatedCaseBlocks.size(); ++i) {
            Tree caseBody = duplicatedCaseBlocks.get(i);
            if (DuplicateBranchScalaCheck.hasPatternMatchCondition(matchTree, caseBody)) continue;
            return Optional.of(new TreeAndIndex(caseBody, i));
        }
        return Optional.empty();
    }

    private static boolean hasPatternMatchCondition(Tree matchTree, Tree caseBody) {
        if (matchTree instanceof MatchTree) {
            Optional<MatchCaseTree> matchCaseTree = DuplicateBranchScalaCheck.getMatchCaseTree((MatchTree)matchTree, caseBody);
            return matchCaseTree.isPresent() && PatternMatchHelper.hasPatternMatchedVariable(matchCaseTree.get());
        }
        return false;
    }

    private static Optional<MatchCaseTree> getMatchCaseTree(MatchTree parent, Tree caseBody) {
        return parent.cases().stream().filter(c -> c.body() == caseBody).findFirst();
    }

    private static class TreeAndIndex {
        Tree tree;
        int index;

        TreeAndIndex(@Nullable Tree tree, int index) {
            this.tree = tree;
            this.index = index;
        }
    }
}

