/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scala.checks;

import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.PackageDeclarationTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.UnusedPrivateMethodCheck;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.impl.NativeTreeImpl;

@Rule(key="S1144")
public class UnusedPrivateMethodScalaCheck
extends UnusedPrivateMethodCheck {
    private static final Set<String> IGNORED_METHODS = new HashSet<String>(Arrays.asList("writeObject", "readObject", "writeReplace", "readResolve", "readObjectNoData"));
    private Set<String> usagesInCompanionObjects = new HashSet<String>();

    @Override
    protected void processClassDeclaration(CheckContext context, ClassDeclarationTree classDeclarationTree) {
        IdentifierTree identifier = classDeclarationTree.identifier();
        if (context.ancestors().stream().noneMatch(ClassDeclarationTree.class::isInstance) && identifier != null) {
            this.collectUsagesInCompanionObject(identifier.name(), context.ancestors());
            this.reportUnusedPrivateMethods(context, classDeclarationTree);
        }
    }

    @Override
    protected boolean isUnusedMethod(IdentifierTree identifier, Set<String> usedIdentifierNames) {
        return super.isUnusedMethod(identifier, usedIdentifierNames) && !IGNORED_METHODS.contains(identifier.name()) && !this.usagesInCompanionObjects.contains(identifier.name());
    }

    private void collectUsagesInCompanionObject(String className, Deque<Tree> ancestors) {
        block3: {
            block2: {
                if (ancestors.size() == 1) break block2;
                if (!UnusedPrivateMethodScalaCheck.isInsidePackage(ancestors)) break block3;
            }
            ancestors.getFirst().descendants().filter(NativeTreeImpl.class::isInstance).map(NativeTreeImpl.class::cast).filter(n -> UnusedPrivateMethodScalaCheck.isObjectCompanionForClass(className, n)).forEach(n -> {
                UnusedPrivateMethodCheck.MethodAndIdentifierCollector collector = new UnusedPrivateMethodCheck.MethodAndIdentifierCollector(n.descendants());
                this.usagesInCompanionObjects = collector.getUsedUniqueIdentifiers();
            });
        }
    }

    private static boolean isObjectCompanionForClass(String className, NativeTreeImpl nativeTree) {
        return nativeTree.nativeKind().toString().contains("scala.meta.Defn$Object$DefnObjectImpl") && nativeTree.children().stream().anyMatch(i -> i instanceof IdentifierTree && ((IdentifierTree)i).identifier().equals(className));
    }

    private static boolean isInsidePackage(Deque<Tree> ancestors) {
        return ancestors.size() == 2 && ancestors.getFirst() instanceof PackageDeclarationTree;
    }
}

