/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scala.externalreport.scalastyle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.scala.externalreport.scalastyle.ScalastyleXmlReportReader;
import org.sonarsource.slang.plugin.AbstractPropertyHandlerSensor;
import org.sonarsource.slang.utils.LogArg;

public abstract class ScalastyleFamilySensor
extends AbstractPropertyHandlerSensor {
    private static final Logger LOG = LoggerFactory.getLogger(ScalastyleFamilySensor.class);
    private static final int MAX_LOGGED_FILE_NAMES = 20;
    private final Set<String> unresolvedInputFiles = new HashSet<String>();

    public abstract ExternalRuleLoader ruleLoader();

    protected ScalastyleFamilySensor(AnalysisWarnings analysisWarnings, String propertyKey, String propertyName, String configurationKey) {
        super(analysisWarnings, propertyKey, propertyName, configurationKey, "scala");
    }

    @Override
    public void execute(SensorContext context) {
        this.unresolvedInputFiles.clear();
        super.execute(context);
        this.logUnresolvedInputFiles();
    }

    @Override
    public Consumer<File> reportConsumer(SensorContext context) {
        return report -> this.importReport((File)report, context, this.unresolvedInputFiles);
    }

    private void logUnresolvedInputFiles() {
        if (this.unresolvedInputFiles.isEmpty()) {
            return;
        }
        LOG.warn("Fail to resolve {} file path(s) in {} report. No issues imported related to file(s): {}", new Object[]{this.unresolvedInputFiles.size(), this.propertyName(), LogArg.lazyArg(() -> {
            Object fileList = this.unresolvedInputFiles.stream().sorted().limit(20L).collect(Collectors.joining(";"));
            if (this.unresolvedInputFiles.size() > 20) {
                fileList = (String)fileList + ";...";
            }
            return fileList;
        })});
    }

    private void importReport(File reportPath, SensorContext context, Set<String> unresolvedInputFiles) {
        try (FileInputStream in = new FileInputStream(reportPath);){
            ScalastyleXmlReportReader.read(in, (file, line, source, message) -> this.saveIssue(context, file, line, source, message, unresolvedInputFiles));
        }
        catch (IOException | RuntimeException | XMLStreamException e) {
            LOG.error("No issues information will be saved as the report file '{}' can't be read. " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Object)reportPath, (Object)e);
        }
    }

    private void saveIssue(SensorContext context, String file, String line, String ruleId, String message, Set<String> unresolvedInputFiles) {
        if (ruleId.isEmpty() || message.isEmpty()) {
            LOG.debug("Missing information or unsupported file type for source:'{}', file:'{}', message:'{}'", new Object[]{ruleId, file, message});
            return;
        }
        InputFile inputFile = context.fileSystem().inputFile(context.fileSystem().predicates().hasAbsolutePath(file));
        if (inputFile == null) {
            unresolvedInputFiles.add(file);
            return;
        }
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        newExternalIssue.type(this.ruleLoader().ruleType(ruleId)).severity(this.ruleLoader().ruleSeverity(ruleId)).remediationEffortMinutes(this.ruleLoader().ruleConstantDebtMinutes(ruleId));
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(message).on((InputComponent)inputFile);
        if (!line.isEmpty()) {
            primaryLocation.at(inputFile.selectLine(Integer.parseInt(line)));
        }
        newExternalIssue.at(primaryLocation).engineId(this.propertyKey()).ruleId(ruleId).save();
    }
}

