/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scala.externalreport.scalastyle;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.sonarsource.analyzer.commons.xml.SafeStaxParserFactory;

class ScalastyleXmlReportReader {
    private static final QName CHECKSTYLE_ELEMENT = new QName("checkstyle");
    private static final QName FILE_ELEMENT = new QName("file");
    private static final QName NAME_ATTRIBUTE = new QName("name");
    private static final QName ERROR_ELEMENT = new QName("error");
    private static final QName LINE_ATTRIBUTE = new QName("line");
    private static final QName MESSAGE_ATTRIBUTE = new QName("message");
    private static final QName SOURCE_ATTRIBUTE = new QName("source");
    private final IssueConsumer consumer;
    private int level = 0;
    private String file = "";

    private ScalastyleXmlReportReader(IssueConsumer consumer) {
        this.consumer = consumer;
    }

    static void read(InputStream in, IssueConsumer consumer) throws XMLStreamException, IOException {
        new ScalastyleXmlReportReader(consumer).read(in);
    }

    private void read(InputStream in) throws XMLStreamException, IOException {
        XMLEventReader reader = SafeStaxParserFactory.createXMLInputFactory().createXMLEventReader(in);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                ++this.level;
                this.onElement(event.asStartElement());
                continue;
            }
            if (!event.isEndElement()) continue;
            --this.level;
        }
    }

    private void onElement(StartElement element) throws IOException {
        if (this.level == 1 && !CHECKSTYLE_ELEMENT.equals(element.getName())) {
            throw new IOException("Unexpected document root '" + element.getName().getLocalPart() + "' instead of 'checkstyle'.");
        }
        if (this.level == 2) {
            this.file = FILE_ELEMENT.equals(element.getName()) ? ScalastyleXmlReportReader.getAttributeValue(element, NAME_ATTRIBUTE) : "";
        } else if (this.level == 3 && ERROR_ELEMENT.equals(element.getName()) && !this.file.isEmpty()) {
            this.consumer.onIssue(this.file, ScalastyleXmlReportReader.getAttributeValue(element, LINE_ATTRIBUTE), ScalastyleXmlReportReader.getAttributeValue(element, SOURCE_ATTRIBUTE), ScalastyleXmlReportReader.getAttributeValue(element, MESSAGE_ATTRIBUTE));
        }
    }

    private static String getAttributeValue(StartElement element, QName attributeName) {
        Attribute attribute = element.getAttributeByName(attributeName);
        return attribute != null ? attribute.getValue() : "";
    }

    @FunctionalInterface
    static interface IssueConsumer {
        public void onIssue(String var1, String var2, String var3, String var4);
    }
}

