/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scala.plugin;

import org.sonar.api.Plugin;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.PropertyDefinition;
import org.sonarsource.scala.externalreport.scalastyle.ScalastyleRulesDefinition;
import org.sonarsource.scala.externalreport.scalastyle.ScalastyleSensor;
import org.sonarsource.scala.externalreport.scapegoat.ScapegoatRulesDefinition;
import org.sonarsource.scala.externalreport.scapegoat.ScapegoatSensor;
import org.sonarsource.scala.plugin.ScalaLanguage;
import org.sonarsource.scala.plugin.ScalaProfileDefinition;
import org.sonarsource.scala.plugin.ScalaRulesDefinition;
import org.sonarsource.scala.plugin.ScalaSensor;
import org.sonarsource.scala.plugin.ScoverageSensor;

public class ScalaPlugin
implements Plugin {
    public static final String SCALA_LANGUAGE_KEY = "scala";
    static final String SCALA_LANGUAGE_NAME = "Scala";
    static final String SCALA_FILE_SUFFIXES_DEFAULT_VALUE = ".scala";
    static final String SCALA_FILE_SUFFIXES_KEY = "sonar.scala.file.suffixes";
    static final String COVERAGE_REPORT_PATHS_KEY = "sonar.scala.coverage.reportPaths";
    static final String SCALA_REPOSITORY_KEY = "scala";
    static final String REPOSITORY_NAME = "SonarAnalyzer";
    static final String PROFILE_NAME = "Sonar way";
    private static final String GENERAL = "General";
    private static final String SCALA_CATEGORY = "Scala";
    private static final String TEST_COVERAGE_SUBCATEGORY = "Test and Coverage";
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";

    public void define(Plugin.Context context) {
        context.addExtensions(ScalaLanguage.class, ScalaSensor.class, new Object[]{ScalaRulesDefinition.class});
        if (context.getRuntime().getProduct() != SonarProduct.SONARLINT) {
            context.addExtensions(ScalaProfileDefinition.class, ScoverageSensor.class, new Object[]{ScalastyleSensor.class, ScapegoatSensor.class, ScalastyleRulesDefinition.class, ScapegoatRulesDefinition.class, PropertyDefinition.builder((String)SCALA_FILE_SUFFIXES_KEY).defaultValue(SCALA_FILE_SUFFIXES_DEFAULT_VALUE).name("File Suffixes").description("List of suffixes for files to analyze.").subCategory(GENERAL).category("Scala").multiValues(true).onQualifiers("TRK", new String[0]).build(), PropertyDefinition.builder((String)COVERAGE_REPORT_PATHS_KEY).name("Path to Scoverage report").description("Path to Scoverage report file(s) (scoverage.xml). Usually in target\\scala-X.X\\scoverage-report").category("Scala").subCategory(TEST_COVERAGE_SUBCATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), PropertyDefinition.builder((String)"sonar.scala.scalastyle.reportPaths").name("Scalastyle Report Files").description("Paths (absolute or relative) to scalastyle xml files with Scalastyle issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory("Scala").onQualifiers("TRK", new String[0]).multiValues(true).build(), PropertyDefinition.builder((String)"sonar.scala.scapegoat.reportPaths").name("Scapegoat Report Files").description("Paths (absolute or relative) to scapegoat xml files using scalastyle format. For example: scapegoat-scalastyle.xml").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory("Scala").onQualifiers("TRK", new String[0]).multiValues(true).build()});
        }
    }
}

