/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.api.MatchTree;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.ExpressionUtils;
import org.sonarsource.slang.utils.SyntacticEquivalence;

@Rule(key="S1862")
public class IdenticalConditionsCheck
implements SlangCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(MatchTree.class, (ctx, tree) -> IdenticalConditionsCheck.checkConditions(ctx, IdenticalConditionsCheck.collectConditions(tree)));
        init.register(IfTree.class, (ctx, tree) -> {
            if (!(ctx.parent() instanceof IfTree)) {
                IdenticalConditionsCheck.checkConditions(ctx, IdenticalConditionsCheck.collectConditions(tree, new ArrayList<Tree>()));
            }
        });
    }

    private static List<Tree> collectConditions(MatchTree matchTree) {
        return matchTree.cases().stream().map(MatchCaseTree::expression).filter(Objects::nonNull).map(ExpressionUtils::skipParentheses).toList();
    }

    private static List<Tree> collectConditions(IfTree ifTree, List<Tree> list) {
        list.add(ExpressionUtils.skipParentheses(ifTree.condition()));
        Tree elseBranch = ifTree.elseBranch();
        if (elseBranch instanceof IfTree) {
            return IdenticalConditionsCheck.collectConditions((IfTree)elseBranch, list);
        }
        return list;
    }

    private static void checkConditions(CheckContext ctx, List<Tree> conditions) {
        for (List<Tree> group : SyntacticEquivalence.findDuplicatedGroups(conditions)) {
            Tree original = group.get(0);
            group.stream().skip(1L).forEach(duplicated -> {
                TextRange originalRange = original.metaData().textRange();
                ctx.reportIssue((HasTextRange)duplicated, "This condition duplicates the one on line " + originalRange.start().line() + ".", new SecondaryLocation(originalRange, "Original"));
            });
        }
    }
}

