/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.visitors.TreeContext;

public class InputFileContext
extends TreeContext {
    private static final String PARSING_ERROR_RULE_KEY = "ParsingError";
    private Map<String, Set<TextRange>> filteredRules = new HashMap<String, Set<TextRange>>();
    public final SensorContext sensorContext;
    public final InputFile inputFile;

    public InputFileContext(SensorContext sensorContext, InputFile inputFile) {
        this.sensorContext = sensorContext;
        this.inputFile = inputFile;
    }

    public org.sonar.api.batch.fs.TextRange textRange(TextRange textRange) {
        return this.inputFile.newRange(textRange.start().line(), textRange.start().lineOffset(), textRange.end().line(), textRange.end().lineOffset());
    }

    public void reportIssue(RuleKey ruleKey, @Nullable TextRange textRange, String message, List<SecondaryLocation> secondaryLocations, @Nullable Double gap) {
        if (textRange != null) {
            if (this.filteredRules.getOrDefault(ruleKey.toString(), Collections.emptySet()).stream().anyMatch(textRange::isInside)) {
                return;
            }
        }
        NewIssue issue = this.sensorContext.newIssue();
        NewIssueLocation issueLocation = issue.newLocation().on((InputComponent)this.inputFile).message(message);
        if (textRange != null) {
            issueLocation.at(this.textRange(textRange));
        }
        issue.forRule(ruleKey).at(issueLocation).gap(gap);
        secondaryLocations.forEach(secondary -> issue.addLocation(issue.newLocation().on((InputComponent)this.inputFile).at(this.textRange(secondary.textRange)).message(secondary.message == null ? "" : secondary.message)));
        issue.save();
    }

    public void reportAnalysisParseError(String repositoryKey, InputFile inputFile, @Nullable org.sonarsource.slang.api.TextPointer location) {
        this.reportAnalysisError("Unable to parse file: " + inputFile, location);
        RuleKey parsingErrorRuleKey = RuleKey.of((String)repositoryKey, (String)PARSING_ERROR_RULE_KEY);
        if (this.sensorContext.activeRules().find(parsingErrorRuleKey) == null) {
            return;
        }
        NewIssue parseError = this.sensorContext.newIssue();
        NewIssueLocation parseErrorLocation = parseError.newLocation().on((InputComponent)inputFile).message("A parsing error occurred in this file.");
        Optional.ofNullable(location).map(org.sonarsource.slang.api.TextPointer::line).map(arg_0 -> ((InputFile)inputFile).selectLine(arg_0)).ifPresent(arg_0 -> ((NewIssueLocation)parseErrorLocation).at(arg_0));
        parseError.forRule(parsingErrorRuleKey).at(parseErrorLocation).save();
    }

    public void reportAnalysisError(String message, @Nullable org.sonarsource.slang.api.TextPointer location) {
        NewAnalysisError error = this.sensorContext.newAnalysisError();
        error.message(message).onFile(this.inputFile);
        if (location != null) {
            TextPointer pointerLocation = this.inputFile.newPointer(location.line(), location.lineOffset());
            error.at(pointerLocation);
        }
        error.save();
    }

    public void setFilteredRules(Map<String, Set<TextRange>> filteredRules) {
        this.filteredRules = filteredRules;
    }
}

