/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.issue.NoSonarFilter;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.plugin.CommentAnalysisUtils;
import org.sonarsource.slang.plugin.InputFileContext;
import org.sonarsource.slang.visitors.TreeVisitor;

public class SkipNoSonarLinesVisitor
extends TreeVisitor<InputFileContext> {
    private final NoSonarFilter noSonarFilter;
    private Set<Integer> noSonarLines;

    public SkipNoSonarLinesVisitor(NoSonarFilter noSonarFilter) {
        this.noSonarFilter = noSonarFilter;
        this.register(TopLevelTree.class, (ctx, tree) -> {
            List<Tree> declarations = tree.declarations();
            int firstTokenLine = declarations.isEmpty() ? tree.textRange().end().line() : declarations.get(0).textRange().start().line();
            tree.allComments().forEach(comment -> this.noSonarLines.addAll(SkipNoSonarLinesVisitor.findNoSonarCommentLines(comment, firstTokenLine)));
        });
    }

    @Override
    protected void before(InputFileContext ctx, Tree root2) {
        this.noSonarLines = new HashSet<Integer>();
    }

    @Override
    protected void after(InputFileContext ctx, Tree root2) {
        this.noSonarFilter.noSonarInFile(ctx.inputFile, this.noSonarLines);
    }

    private static Set<Integer> findNoSonarCommentLines(Comment comment, int firstTokenLine) {
        boolean isFileHeader;
        boolean bl = isFileHeader = comment.textRange().end().line() < firstTokenLine;
        if (!isFileHeader && CommentAnalysisUtils.isNosonarComment(comment)) {
            return CommentAnalysisUtils.findNonEmptyCommentLines(comment.contentRange(), comment.contentText());
        }
        return Set.of();
    }
}

