/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin.converter;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonarsource.slang.api.ASTConverter;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.LiteralTreeImpl;
import org.sonarsource.slang.impl.NativeTreeImpl;
import org.sonarsource.slang.impl.PlaceHolderTreeImpl;
import org.sonarsource.slang.impl.TextPointerImpl;
import org.sonarsource.slang.utils.LogArg;

public class ASTConverterValidation
implements ASTConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ASTConverterValidation.class);
    private static final Pattern PUNCTUATOR_PATTERN = Pattern.compile("[^0-9A-Za-z]++");
    private static final Set<String> ALLOWED_MISPLACED_TOKENS_OUTSIDE_PARENT_RANGE = new HashSet<String>(Collections.singleton("implicit"));
    private final ASTConverter wrapped;
    private final Map<String, String> firstErrorOfEachKind = new TreeMap<String, String>();
    private final ValidationMode mode;
    @Nullable
    private String currentFile = null;

    public ASTConverterValidation(ASTConverter wrapped, ValidationMode mode) {
        this.wrapped = wrapped;
        this.mode = mode;
    }

    public static ASTConverter wrap(ASTConverter converter, Configuration configuration) {
        String mode = configuration.get("sonar.slang.converter.validation").orElse(null);
        if (mode == null) {
            return converter;
        }
        if (mode.equals("throw")) {
            return new ASTConverterValidation(converter, ValidationMode.THROW_EXCEPTION);
        }
        if (mode.equals("log")) {
            return new ASTConverterValidation(converter, ValidationMode.LOG_ERROR);
        }
        throw new IllegalStateException("Unsupported mode: " + mode);
    }

    @Override
    public Tree parse(String content) {
        return this.parse(content, null);
    }

    @Override
    public Tree parse(String content, @Nullable String currentFile) {
        this.currentFile = currentFile;
        Tree tree = this.wrapped.parse(content, currentFile);
        this.assertTreeIsValid(tree);
        this.assertTokensMatchSourceCode(tree, content);
        return tree;
    }

    @Override
    public void terminate() {
        List<String> errors = this.errors();
        if (!errors.isEmpty()) {
            String delimiter = "\n  [AST ERROR] ";
            LOG.error("AST Converter Validation detected {} errors:{}{}", new Object[]{errors.size(), delimiter, LogArg.lazyArg(() -> String.join((CharSequence)delimiter, errors))});
        }
        this.wrapped.terminate();
    }

    ValidationMode mode() {
        return this.mode;
    }

    List<String> errors() {
        return this.firstErrorOfEachKind.entrySet().stream().map(entry -> (String)entry.getKey() + (String)entry.getValue()).toList();
    }

    private void raiseError(String messageKey, String messageDetails, TextPointer position) {
        if (this.mode == ValidationMode.THROW_EXCEPTION) {
            throw new IllegalStateException("ASTConverterValidationException: " + messageKey + messageDetails + " at  " + position.line() + ":" + position.lineOffset());
        }
        Object positionDetails = String.format(" (line: %d, column: %d)", position.line(), position.lineOffset() + 1);
        if (this.currentFile != null) {
            positionDetails = (String)positionDetails + " in file: " + this.currentFile;
        }
        this.firstErrorOfEachKind.putIfAbsent(messageKey, messageDetails + (String)positionDetails);
    }

    private static String kind(Tree tree) {
        return tree.getClass().getSimpleName();
    }

    private void assertTreeIsValid(Tree tree) {
        this.assertTextRangeIsValid(tree);
        this.assertTreeHasAtLeastOneToken(tree);
        this.assertTokensAndChildTokens(tree);
        for (Tree child : tree.children()) {
            if (child == null) {
                this.raiseError(ASTConverterValidation.kind(tree) + " has a null child", "", tree.textRange().start());
                continue;
            }
            if (child.metaData() == null) {
                this.raiseError(ASTConverterValidation.kind(child) + " metaData is null", "", tree.textRange().start());
                continue;
            }
            this.assertTreeIsValid(child);
        }
    }

    private void assertTextRangeIsValid(Tree tree) {
        boolean startOffsetAfterEndOffset;
        TextPointer start = tree.metaData().textRange().start();
        TextPointer end = tree.metaData().textRange().end();
        boolean bl = startOffsetAfterEndOffset = !(tree instanceof TopLevelTree) && start.line() == end.line() && start.lineOffset() >= end.lineOffset();
        if (start.line() <= 0 || end.line() <= 0 || start.line() > end.line() || start.lineOffset() < 0 || end.lineOffset() < 0 || startOffsetAfterEndOffset) {
            this.raiseError(ASTConverterValidation.kind(tree) + " invalid range ", tree.metaData().textRange().toString(), start);
        }
    }

    private void assertTreeHasAtLeastOneToken(Tree tree) {
        if (!(tree instanceof TopLevelTree) && tree.metaData().tokens().isEmpty()) {
            this.raiseError(ASTConverterValidation.kind(tree) + " has no token", "", tree.textRange().start());
        }
    }

    private void assertTokensMatchSourceCode(Tree tree, String code) {
        CodeFormToken codeFormToken = new CodeFormToken(tree.metaData());
        codeFormToken.assertEqualTo(code);
    }

    private void assertTokensAndChildTokens(Tree tree) {
        this.assertTokensAreInsideRange(tree);
        HashSet<Token> parentTokens = new HashSet<Token>(tree.metaData().tokens());
        HashMap<Token, Tree> childByToken = new HashMap<Token, Tree>();
        for (Tree child : tree.children()) {
            if (child == null || child.metaData() == null || ASTConverterValidation.isAllowedMisplacedTree(child)) continue;
            this.assertChildRangeIsInsideParentRange(tree, child);
            this.assertChildTokens(parentTokens, childByToken, tree, child);
        }
        parentTokens.removeAll(childByToken.keySet());
        this.assertUnexpectedTokenKind(tree, parentTokens);
    }

    private static boolean isAllowedMisplacedTree(Tree tree) {
        List<Token> tokens = tree.metaData().tokens();
        return tokens.size() == 1 && ALLOWED_MISPLACED_TOKENS_OUTSIDE_PARENT_RANGE.contains(tokens.get(0).text());
    }

    private void assertUnexpectedTokenKind(Tree tree, Set<Token> tokens) {
        if (tree instanceof NativeTreeImpl || tree instanceof LiteralTreeImpl || tree instanceof PlaceHolderTreeImpl) {
            return;
        }
        List<Token> unexpectedTokens = tree instanceof IdentifierTree ? tokens.stream().filter(token -> token.type() == Token.Type.KEYWORD || token.type() == Token.Type.STRING_LITERAL).toList() : tokens.stream().filter(token -> token.type() != Token.Type.KEYWORD).filter(token -> !PUNCTUATOR_PATTERN.matcher(token.text()).matches()).filter(token -> !ALLOWED_MISPLACED_TOKENS_OUTSIDE_PARENT_RANGE.contains(token.text())).toList();
        if (!unexpectedTokens.isEmpty()) {
            String tokenList = unexpectedTokens.stream().sorted(Comparator.comparing(token -> token.textRange().start())).map(Token::text).collect(Collectors.joining("', '"));
            this.raiseError("Unexpected tokens in " + ASTConverterValidation.kind(tree), ": '" + tokenList + "'", tree.textRange().start());
        }
    }

    private void assertTokensAreInsideRange(Tree tree) {
        TextRange parentRange = tree.metaData().textRange();
        tree.metaData().tokens().stream().filter(token -> !ALLOWED_MISPLACED_TOKENS_OUTSIDE_PARENT_RANGE.contains(token.text())).filter(token -> !token.textRange().isInside(parentRange)).findFirst().ifPresent(token -> this.raiseError(ASTConverterValidation.kind(tree) + " contains a token outside its range", " range: " + parentRange + " tokenRange: " + token.textRange() + " token: '" + token.text() + "'", token.textRange().start()));
    }

    private void assertChildRangeIsInsideParentRange(Tree parent, Tree child) {
        TextRange parentRange = parent.metaData().textRange();
        TextRange childRange = child.metaData().textRange();
        if (!childRange.isInside(parentRange)) {
            this.raiseError(ASTConverterValidation.kind(parent) + " contains a child " + ASTConverterValidation.kind(child) + " outside its range", ", parentRange: " + parentRange + " childRange: " + childRange, childRange.start());
        }
    }

    private void assertChildTokens(Set<Token> parentTokens, Map<Token, Tree> childByToken, Tree parent, Tree child) {
        for (Token token : child.metaData().tokens()) {
            Tree intersectingChild;
            if (!parentTokens.contains(token)) {
                this.raiseError(ASTConverterValidation.kind(child) + " contains a token missing in its parent " + ASTConverterValidation.kind(parent), ", token: '" + token.text() + "'", token.textRange().start());
            }
            if ((intersectingChild = childByToken.get(token)) != null) {
                this.raiseError(ASTConverterValidation.kind(parent) + " has a token used by both children " + ASTConverterValidation.kind(intersectingChild) + " and " + ASTConverterValidation.kind(child), ", token: '" + token.text() + "'", token.textRange().start());
                continue;
            }
            childByToken.put(token, child);
        }
    }

    public static enum ValidationMode {
        THROW_EXCEPTION,
        LOG_ERROR;

    }

    private class CodeFormToken {
        private final StringBuilder code = new StringBuilder();
        private final List<Comment> commentsInside;
        private int lastLine = 1;
        private int lastLineOffset = 0;
        private int lastComment = 0;

        private CodeFormToken(TreeMetaData metaData) {
            this.commentsInside = metaData.commentsInside();
            metaData.tokens().forEach(this::add);
            this.addRemainingComments();
        }

        private void add(Token token) {
            while (this.lastComment < this.commentsInside.size() && this.commentsInside.get(this.lastComment).textRange().start().compareTo(token.textRange().start()) < 0) {
                Comment comment = this.commentsInside.get(this.lastComment);
                this.addTextAt(comment.text(), comment.textRange());
                ++this.lastComment;
            }
            this.addTextAt(token.text(), token.textRange());
        }

        private void addRemainingComments() {
            for (int i = this.lastComment; i < this.commentsInside.size(); ++i) {
                this.addTextAt(this.commentsInside.get(i).text(), this.commentsInside.get(i).textRange());
            }
        }

        private void addTextAt(String text, TextRange textRange) {
            while (this.lastLine < textRange.start().line()) {
                this.code.append("\n");
                ++this.lastLine;
                this.lastLineOffset = 0;
            }
            while (this.lastLineOffset < textRange.start().lineOffset()) {
                this.code.append(' ');
                ++this.lastLineOffset;
            }
            this.code.append(text);
            this.lastLine = textRange.end().line();
            this.lastLineOffset = textRange.end().lineOffset();
        }

        private void assertEqualTo(String expectedCode) {
            String[] actualLines = this.lines(this.code.toString());
            String[] expectedLines = this.lines(expectedCode);
            for (int i = 0; i < actualLines.length && i < expectedLines.length; ++i) {
                if (actualLines[i].equals(expectedLines[i])) continue;
                ASTConverterValidation.this.raiseError("Unexpected AST difference", ":\n      Actual   : " + actualLines[i] + "\n      Expected : " + expectedLines[i] + "\n", new TextPointerImpl(i + 1, 0));
            }
            if (actualLines.length != expectedLines.length) {
                ASTConverterValidation.this.raiseError("Unexpected AST number of lines", " actual: " + actualLines.length + ", expected: " + expectedLines.length, new TextPointerImpl(Math.min(actualLines.length, expectedLines.length), 0));
            }
        }

        private String[] lines(String code) {
            return code.replace('\t', ' ').replaceFirst("[\r\n ]+$", "").split(" *(\r\n|\n|\r)", -1);
        }
    }
}

