/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scalapb.TextFormatError;
import scalapb.textformat.Constants$;
import scalapb.textformat.TextFormatUtils;
import scalapb.textformat.TextFormatUtils$Default$;
import scalapb.textformat.TextFormatUtils$EscapeMode$;
import scalapb.textformat.TextFormatUtils$Hex0$;
import scalapb.textformat.TextFormatUtils$JavaConversions$;

public final class TextFormatUtils$ {
    public static final TextFormatUtils$ MODULE$ = new TextFormatUtils$();
    private static final String HEXDIGIT = "0123456789abcdefABCDEF";

    private String HEXDIGIT() {
        return HEXDIGIT;
    }

    public boolean isHexDigit(char c) {
        return StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(this.HEXDIGIT()), c);
    }

    private int digitValue(byte c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 122) {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    public String escapeBytes(ByteString bytes) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        TextFormatUtils$JavaConversions$.MODULE$.foreach$extension(this.JavaConversions((Iterable<Byte>)bytes), (Function1<Byte, scala.collection.mutable.StringBuilder> & Serializable)x0$1 -> {
            Byte by = x0$1;
            Byte by2 = Constants$.MODULE$.CH_SLASH_A();
            Byte by3 = by;
            if (!(by2 != null ? !((Object)by2).equals(by3) : by3 != null)) {
                return sb.append("\\a");
            }
            Byte by4 = Constants$.MODULE$.CH_SLASH_B();
            Byte by5 = by;
            if (!(by4 != null ? !((Object)by4).equals(by5) : by5 != null)) {
                return sb.append("\\b");
            }
            Byte by6 = Constants$.MODULE$.CH_SLASH_F();
            Byte by7 = by;
            if (!(by6 != null ? !((Object)by6).equals(by7) : by7 != null)) {
                return sb.append("\\f");
            }
            Byte by8 = Constants$.MODULE$.CH_SLASH_N();
            Byte by9 = by;
            if (!(by8 != null ? !((Object)by8).equals(by9) : by9 != null)) {
                return sb.append("\\n");
            }
            Byte by10 = Constants$.MODULE$.CH_SLASH_R();
            Byte by11 = by;
            if (!(by10 != null ? !((Object)by10).equals(by11) : by11 != null)) {
                return sb.append("\\r");
            }
            Byte by12 = Constants$.MODULE$.CH_SLASH_T();
            Byte by13 = by;
            if (!(by12 != null ? !((Object)by12).equals(by13) : by13 != null)) {
                return sb.append("\\t");
            }
            Byte by14 = Constants$.MODULE$.CH_SLASH_V();
            Byte by15 = by;
            if (!(by14 != null ? !((Object)by14).equals(by15) : by15 != null)) {
                return sb.append("\\v");
            }
            Byte by16 = Constants$.MODULE$.CH_SLASH();
            Byte by17 = by;
            if (!(by16 != null ? !((Object)by16).equals(by17) : by17 != null)) {
                return sb.append("\\\\");
            }
            Byte by18 = Constants$.MODULE$.CH_SQ();
            Byte by19 = by;
            if (!(by18 != null ? !((Object)by18).equals(by19) : by19 != null)) {
                return sb.append("\\'");
            }
            Byte by20 = Constants$.MODULE$.CH_DQ();
            Byte by21 = by;
            if (!(by20 != null ? !((Object)by20).equals(by21) : by21 != null)) {
                return sb.append("\\\"");
            }
            if (Predef$.MODULE$.Byte2byte(by) >= 32) {
                return sb.append((char)Predef$.MODULE$.Byte2byte(by));
            }
            sb.append('\\');
            sb.append((char)(48 + (Predef$.MODULE$.Byte2byte(by) >>> 6 & 3)));
            sb.append((char)(48 + (Predef$.MODULE$.Byte2byte(by) >>> 3 & 7)));
            return sb.append((char)(48 + (Predef$.MODULE$.Byte2byte(by) & 7)));
        });
        return sb.result();
    }

    public Iterable<Byte> JavaConversions(Iterable<Byte> iter) {
        return iter;
    }

    public Either<TextFormatError, ByteString> unescapeBytes(String charString) {
        TextFormatUtils.ByteParsingState endState;
        ByteString input = ByteString.copyFromUtf8((String)charString);
        ArrayBuilder<Object> result = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Byte());
        result.sizeHint(input.size());
        TextFormatUtils.ByteParsingState byteParsingState = endState = (TextFormatUtils.ByteParsingState)TextFormatUtils$JavaConversions$.MODULE$.foldLeft$extension(this.JavaConversions((Iterable<Byte>)input), TextFormatUtils$Default$.MODULE$, (Function2<TextFormatUtils.ByteParsingState, Byte, TextFormatUtils.ByteParsingState> & Serializable)(state, b) -> {
            TextFormatUtils.ByteParsingState byteParsingState;
            TextFormatUtils.ByteParsingState byteParsingState2;
            TextFormatUtils.ByteParsingState e;
            Tuple2<TextFormatUtils.ByteParsingState, Byte> tuple2 = new Tuple2<TextFormatUtils.ByteParsingState, Byte>((TextFormatUtils.ByteParsingState)state, (Byte)b);
            if (tuple2 != null && (e = tuple2._1()) instanceof TextFormatUtils.Error) {
                String string = e == null ? null : ((TextFormatUtils.Error)e).s();
                return new TextFormatUtils.Error(string);
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState3 = tuple2._1();
                Byte b2 = tuple2._2();
                if (TextFormatUtils$Default$.MODULE$.equals(byteParsingState3)) {
                    return (TextFormatUtils.ByteParsingState)TextFormatUtils$.defaultHandle$1(Predef$.MODULE$.Byte2byte(b2), result);
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState4 = tuple2._1();
                Byte b3 = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState4) && Predef$.MODULE$.Byte2byte(b3) >= 48 && Predef$.MODULE$.Byte2byte(b3) <= 55) {
                    return new TextFormatUtils.Octal1(MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b3)));
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState5 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState5)) {
                    Byte by2 = Constants$.MODULE$.CH_A();
                    Byte by3 = by;
                    if (!(by2 != null ? !((Object)by2).equals(by3) : by3 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)7));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState6 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState6)) {
                    Byte by4 = Constants$.MODULE$.CH_B();
                    Byte by5 = by;
                    if (!(by4 != null ? !((Object)by4).equals(by5) : by5 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)8));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState7 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState7)) {
                    Byte by6 = Constants$.MODULE$.CH_F();
                    Byte by7 = by;
                    if (!(by6 != null ? !((Object)by6).equals(by7) : by7 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)12));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState8 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState8)) {
                    Byte by8 = Constants$.MODULE$.CH_N();
                    Byte by9 = by;
                    if (!(by8 != null ? !((Object)by8).equals(by9) : by9 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)10));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState9 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState9)) {
                    Byte by10 = Constants$.MODULE$.CH_R();
                    Byte by11 = by;
                    if (!(by10 != null ? !((Object)by10).equals(by11) : by11 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)13));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState10 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState10)) {
                    Byte by12 = Constants$.MODULE$.CH_T();
                    Byte by13 = by;
                    if (!(by12 != null ? !((Object)by12).equals(by13) : by13 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)9));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState11 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState11)) {
                    Byte by14 = Constants$.MODULE$.CH_V();
                    Byte by15 = by;
                    if (!(by14 != null ? !((Object)by14).equals(by15) : by15 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)11));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState12 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState12)) {
                    Byte by16 = Constants$.MODULE$.CH_SLASH();
                    Byte by17 = by;
                    if (!(by16 != null ? !((Object)by16).equals(by17) : by17 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)92));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState13 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState13)) {
                    Byte by18 = Constants$.MODULE$.CH_SQ();
                    Byte by19 = by;
                    if (!(by18 != null ? !((Object)by18).equals(by19) : by19 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)39));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState14 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState14)) {
                    Byte by20 = Constants$.MODULE$.CH_DQ();
                    Byte by21 = by;
                    if (!(by20 != null ? !((Object)by20).equals(by21) : by21 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)34));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState15 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState15)) {
                    Byte by22 = Constants$.MODULE$.CH_QM();
                    Byte by23 = by;
                    if (!(by22 != null ? !((Object)by22).equals(by23) : by23 != null)) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)63));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState16 = tuple2._1();
                Byte by = tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState16)) {
                    Byte by24 = Constants$.MODULE$.CH_X();
                    Byte by25 = by;
                    if (!(by24 != null ? !((Object)by24).equals(by25) : by25 != null)) {
                        return TextFormatUtils$Hex0$.MODULE$;
                    }
                }
            }
            if (tuple2 != null && TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState2 = tuple2._1())) {
                return new TextFormatUtils.Error(new StringBuilder(25).append("Invalid escape sequence: ").append((char)Predef$.MODULE$.Byte2byte((Byte)b)).toString());
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState17 = tuple2._1();
                Byte b4 = tuple2._2();
                if (byteParsingState17 instanceof TextFormatUtils.Octal1) {
                    int n;
                    int i = n = ((TextFormatUtils.Octal1)byteParsingState17).b();
                    if (Predef$.MODULE$.Byte2byte(b4) >= 48 && Predef$.MODULE$.Byte2byte(b4) <= 55) {
                        return new TextFormatUtils.Octal2(i * 8 + MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b4)));
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState18 = tuple2._1();
                Byte b5 = tuple2._2();
                if (byteParsingState18 instanceof TextFormatUtils.Octal1) {
                    int n;
                    int i = n = ((TextFormatUtils.Octal1)byteParsingState18).b();
                    result.$plus$eq(BoxesRunTime.boxToByte((byte)i));
                    return (TextFormatUtils.ByteParsingState)TextFormatUtils$.defaultHandle$1(Predef$.MODULE$.Byte2byte(b5), result);
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState19 = tuple2._1();
                Byte b6 = tuple2._2();
                if (byteParsingState19 instanceof TextFormatUtils.Octal2) {
                    int n;
                    int i = n = ((TextFormatUtils.Octal2)byteParsingState19).b();
                    if (Predef$.MODULE$.Byte2byte(b6) >= 48 && Predef$.MODULE$.Byte2byte(b6) <= 55) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)(i * 8 + MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b6)))));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState20 = tuple2._1();
                Byte b7 = tuple2._2();
                if (byteParsingState20 instanceof TextFormatUtils.Octal2) {
                    int n;
                    int i = n = ((TextFormatUtils.Octal2)byteParsingState20).b();
                    result.$plus$eq(BoxesRunTime.boxToByte((byte)i));
                    return (TextFormatUtils.ByteParsingState)TextFormatUtils$.defaultHandle$1(Predef$.MODULE$.Byte2byte(b7), result);
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState21 = tuple2._1();
                Byte b8 = tuple2._2();
                if (TextFormatUtils$Hex0$.MODULE$.equals(byteParsingState21) && MODULE$.isHexDigit((char)Predef$.MODULE$.Byte2byte(b8))) {
                    return new TextFormatUtils.Hex1(MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b8)));
                }
            }
            if (tuple2 != null && TextFormatUtils$Hex0$.MODULE$.equals(byteParsingState = tuple2._1())) {
                return new TextFormatUtils.Error("'\\x' with no digits");
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState22 = tuple2._1();
                Byte b9 = tuple2._2();
                if (byteParsingState22 instanceof TextFormatUtils.Hex1) {
                    int n;
                    int i = n = ((TextFormatUtils.Hex1)byteParsingState22).b();
                    if (MODULE$.isHexDigit((char)Predef$.MODULE$.Byte2byte(b9))) {
                        result.$plus$eq(BoxesRunTime.boxToByte((byte)(16 * i + MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b9)))));
                        return TextFormatUtils$Default$.MODULE$;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState23 = tuple2._1();
                Byte b10 = tuple2._2();
                if (byteParsingState23 instanceof TextFormatUtils.Hex1) {
                    int n;
                    int i = n = ((TextFormatUtils.Hex1)byteParsingState23).b();
                    result.$plus$eq(BoxesRunTime.boxToByte((byte)i));
                    return (TextFormatUtils.ByteParsingState)TextFormatUtils$.defaultHandle$1(Predef$.MODULE$.Byte2byte(b10), result);
                }
            }
            throw new MatchError(tuple2);
        });
        if (byteParsingState instanceof TextFormatUtils.Error) {
            String string;
            String e = string = byteParsingState == null ? null : ((TextFormatUtils.Error)byteParsingState).s();
            return package$.MODULE$.Left().apply(new TextFormatError(e));
        }
        if (TextFormatUtils$Hex0$.MODULE$.equals(byteParsingState)) {
            return package$.MODULE$.Left().apply(new TextFormatError("'\\x' with no digits"));
        }
        if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState)) {
            return package$.MODULE$.Left().apply(new TextFormatError("Invalid escape sequence '\\' at end of string."));
        }
        if (byteParsingState instanceof TextFormatUtils.Hex1) {
            int n;
            int i = n = ((TextFormatUtils.Hex1)byteParsingState).b();
            result.$plus$eq(BoxesRunTime.boxToByte((byte)i));
            return package$.MODULE$.Right().apply(ByteString.copyFrom((byte[])((byte[])result.result())));
        }
        if (byteParsingState instanceof TextFormatUtils.Octal1) {
            int n;
            int i = n = ((TextFormatUtils.Octal1)byteParsingState).b();
            result.$plus$eq(BoxesRunTime.boxToByte((byte)i));
            return package$.MODULE$.Right().apply(ByteString.copyFrom((byte[])((byte[])result.result())));
        }
        if (byteParsingState instanceof TextFormatUtils.Octal2) {
            int n;
            int i = n = ((TextFormatUtils.Octal2)byteParsingState).b();
            result.$plus$eq(BoxesRunTime.boxToByte((byte)i));
            return package$.MODULE$.Right().apply(ByteString.copyFrom((byte[])((byte[])result.result())));
        }
        if (TextFormatUtils$Default$.MODULE$.equals(byteParsingState)) {
            return package$.MODULE$.Right().apply(ByteString.copyFrom((byte[])((byte[])result.result())));
        }
        throw new MatchError(byteParsingState);
    }

    public String escapeText(String input) {
        return this.escapeBytes(ByteString.copyFromUtf8((String)input));
    }

    public Either<TextFormatError, String> unescapeText(String input) {
        return this.unescapeBytes(input).flatMap((Function1<ByteString, Either> & Serializable)bytes -> (bytes.isValidUtf8() ? package$.MODULE$.Right().apply(BoxedUnit.UNIT) : package$.MODULE$.Left().apply(new TextFormatError(new StringBuilder(14).append("Invalid UTF8: ").append(input).toString()))).map((Function1<BoxedUnit, String> & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return bytes.toStringUtf8();
        }));
    }

    public String unsignedToString(int value) {
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)value & 0xFFFFFFFFL);
    }

    public String unsignedToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    public String escapeDoubleQuotesAndBackslashes(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static final Object defaultHandle$1(byte b, ArrayBuilder result$1) {
        if (BoxesRunTime.equals(BoxesRunTime.boxToByte(b), Constants$.MODULE$.CH_SLASH())) {
            return TextFormatUtils$EscapeMode$.MODULE$;
        }
        result$1.$plus$eq(BoxesRunTime.boxToByte(b));
        return TextFormatUtils$Default$.MODULE$;
    }

    private TextFormatUtils$() {
    }
}

