/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.Transaction;
import com.persistit.VolumeSpecification;
import com.persistit.exception.InvalidVolumeSpecificationException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitIOException;
import com.persistit.exception.PropertiesNotFoundException;
import com.persistit.policy.JoinPolicy;
import com.persistit.policy.SplitPolicy;
import com.persistit.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Configuration {
    public static final String SYSTEM_PROPERTY_PREFIX = "com.persistit.";
    public static final String DEFAULT_PROPERTIES_FILE_SUFFIX = ".properties";
    public static final String DEFAULT_CONFIG_FILE = "persistit.properties";
    static final long DEFAULT_TIMEOUT_VALUE = 30000L;
    static final long MAXIMUM_TIMEOUT_VALUE = 86400000L;
    public static final String CONFIG_FILE_PROPERTY_NAME = "properties";
    public static final String BUFFERS_PROPERTY_NAME = "buffer.count.";
    public static final String BUFFER_MEM_PROPERTY_NAME = "buffer.memory.";
    public static final String VOLUME_PROPERTY_PREFIX = "volume.";
    public static final String JOURNAL_PATH_PROPERTY_NAME = "journalpath";
    public static final String JOURNAL_BLOCKSIZE_PROPERTY_NAME = "journalsize";
    public static final String DEFAULT_JOURNAL_PATH = "persistit_journal";
    public static final String DEFAULT_SYSTEM_VOLUME_NAME = "_system";
    public static final String SYSTEM_VOLUME_PROPERTY_NAME = "sysvolume";
    public static final String CHECKPOINT_INTERVAL_PROPERTY_NAME = "checkpointinterval";
    public static final String TEMPORARY_VOLUME_PAGE_SIZE_PROPERTY_NAME = "tmpvolpagesize";
    public static final String TEMPORARY_VOLUME_DIR_PROPERTY_NAME = "tmpvoldir";
    public static final String TEMPORARY_VOLUME_MAX_SIZE_PROPERTY_NAME = "tmpvolmaxsize";
    public static final long MINIMUM_TEMP_VOL_MAX_SIZE = 65536L;
    public static final long MAXIMUM_TEMP_VOL_MAX_SIZE = Long.MAX_VALUE;
    public static final String COMMIT_POLICY_PROPERTY_NAME = "txnpolicy";
    public static final String VERBOSE_PROPERTY = "verbose";
    public static final String READ_RETRY_PROPERTY_NAME = "readretry";
    public static final String TIMEOUT_PROPERTY = "timeout";
    public static final String SERIAL_OVERRIDE_PROPERTY_NAME = "serialOverride";
    public static final String CONSTRUCTOR_OVERRIDE_PROPERTY_NAME = "constructorOverride";
    public static final String SHOW_GUI_PROPERTY_NAME = "showgui";
    public static final String LOGGING_PROPERTIES_NAME = "logging";
    public static final String LOGFILE_PROPERTY_NAME = "logfile";
    public static final String RMI_REGISTRY_HOST_PROPERTY_NAME = "rmihost";
    public static final String RMI_REGISTRY_PORT_PROPERTY_NAME = "rmiport";
    public static final String RMI_SERVER_PORT_PROPERTY_NAME = "rmiserverport";
    public static final String ENABLE_JMX_PROPERTY_NAME = "jmx";
    public static final String TIMESTAMP_PROPERTY = "timestamp";
    public static final String APPEND_ONLY_PROPERTY_NAME = "appendonly";
    public static final String IGNORE_MISSING_VOLUMES_PROPERTY = "ignoremissingvolumes";
    public static final String USE_OLD_VSPEC = "useoldvspec";
    public static final String SPLIT_POLICY_PROPERTY_NAME = "splitpolicy";
    public static final String BUFFER_PRELOAD_PROPERTY_NAME = "bufferpreload";
    public static final String BUFFER_INVENTORY_PROPERTY_NAME = "bufferinventory";
    public static final String JOIN_POLICY_PROPERTY_NAME = "joinpolicy";
    private static final SplitPolicy DEFAULT_SPLIT_POLICY = SplitPolicy.PACK_BIAS;
    private static final JoinPolicy DEFAULT_JOIN_POLICY = JoinPolicy.EVEN_BIAS;
    private static final Transaction.CommitPolicy DEFAULT_TRANSACTION_COMMIT_POLICY = Transaction.CommitPolicy.SOFT;
    public static final long KILO = 1024L;
    public static final long MEGA = 0x100000L;
    public static final long GIGA = 0x40000000L;
    public static final long TERA = 0x10000000000L;
    private static final int[] BUFFER_SIZES = Configuration.validBufferSizes();
    private static final int MAX_RECURSION_COUNT = 20;
    private final Properties _properties = new Properties();
    private final Map<Integer, BufferPoolConfiguration> bufferPoolMap;
    private final List<VolumeSpecification> volumeSpecifications = new ArrayList<VolumeSpecification>();
    private String journalPath = "persistit_journal";
    private long journalSize = 1000000000L;
    private long checkpointInterval = 120L;
    private String sysVolume = "_system";
    private Transaction.CommitPolicy commitPolicy = DEFAULT_TRANSACTION_COMMIT_POLICY;
    private JoinPolicy joinPolicy = DEFAULT_JOIN_POLICY;
    private SplitPolicy splitPolicy = DEFAULT_SPLIT_POLICY;
    private String serialOverride;
    private boolean constructorOverride;
    private boolean showGUI;
    private String logging;
    private String logFile;
    private String rmiHost;
    private int rmiPort;
    private int rmiServerPort;
    private boolean jmx = true;
    private boolean appendOnly;
    private boolean bufferInventoryEnabled;
    private boolean bufferPreloadEnabled;
    private boolean ignoreMissingVolumes;
    private String tmpVolDir;
    private int tmpVolPageSize;
    private long tmpVolMaxSize;
    private boolean useOldVSpec;

    public Configuration() {
        TreeMap<Integer, BufferPoolConfiguration> map = new TreeMap<Integer, BufferPoolConfiguration>();
        for (int bufferSize : BUFFER_SIZES) {
            map.put(bufferSize, new BufferPoolConfiguration(bufferSize));
        }
        this.bufferPoolMap = Collections.unmodifiableMap(map);
    }

    public Configuration(Properties properties) throws InvalidVolumeSpecificationException {
        this();
        this.merge(properties);
        this.loadProperties();
    }

    void readPropertiesFile() throws PersistitException {
        this.readPropertiesFile(this.getProperty(CONFIG_FILE_PROPERTY_NAME, DEFAULT_CONFIG_FILE));
    }

    void readPropertiesFile(String propertiesFileName) throws PersistitException {
        Properties properties = new Properties();
        try {
            if (propertiesFileName.contains(DEFAULT_PROPERTIES_FILE_SUFFIX) || propertiesFileName.contains(File.separator)) {
                properties.load(new FileInputStream(propertiesFileName));
            } else {
                ResourceBundle bundle = ResourceBundle.getBundle(propertiesFileName);
                Enumeration<String> e = bundle.getKeys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    properties.put(key, bundle.getString(key));
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new PropertiesNotFoundException(fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new PersistitIOException(ioe);
        }
        this.merge(properties);
        this.loadProperties();
    }

    static final void checkBufferSize(int bufferSize) {
        for (int size : BUFFER_SIZES) {
            if (size != bufferSize) continue;
            return;
        }
        throw new IllegalArgumentException("Invalid buffer size: " + bufferSize);
    }

    void merge(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            this._properties.put(propertyName, properties.getProperty(propertyName));
        }
    }

    void loadProperties() throws InvalidVolumeSpecificationException {
        this.setAppendOnly(this.getBooleanProperty(APPEND_ONLY_PROPERTY_NAME, false));
        this.setCommitPolicy(this.getProperty(COMMIT_POLICY_PROPERTY_NAME));
        this.setConstructorOverride(this.getBooleanProperty(CONSTRUCTOR_OVERRIDE_PROPERTY_NAME, false));
        this.setIgnoreMissingVolumes(this.getBooleanProperty(IGNORE_MISSING_VOLUMES_PROPERTY, false));
        this.setJmxEnabled(this.getBooleanProperty(ENABLE_JMX_PROPERTY_NAME, true));
        this.setJoinPolicy(this.getProperty(JOIN_POLICY_PROPERTY_NAME));
        this.setJournalPath(this.getProperty(JOURNAL_PATH_PROPERTY_NAME, DEFAULT_JOURNAL_PATH));
        this.setJournalSize(this.getLongProperty(JOURNAL_BLOCKSIZE_PROPERTY_NAME, 1000000000L));
        this.setLogFile(this.getProperty(LOGFILE_PROPERTY_NAME));
        this.setLogging(this.getProperty(LOGGING_PROPERTIES_NAME));
        this.setTmpVolDir(this.getProperty(TEMPORARY_VOLUME_DIR_PROPERTY_NAME));
        this.setTmpVolPageSize(this.getIntegerProperty(TEMPORARY_VOLUME_PAGE_SIZE_PROPERTY_NAME, 0));
        this.setTmpVolMaxSize(this.getLongProperty(TEMPORARY_VOLUME_MAX_SIZE_PROPERTY_NAME, Long.MAX_VALUE));
        this.setRmiHost(this.getProperty(RMI_REGISTRY_HOST_PROPERTY_NAME));
        this.setRmiPort((int)this.getLongProperty(RMI_REGISTRY_PORT_PROPERTY_NAME, 0L));
        this.setRmiServerPort((int)this.getLongProperty(RMI_SERVER_PORT_PROPERTY_NAME, 0L));
        this.setSerialOverride(this.getProperty(SERIAL_OVERRIDE_PROPERTY_NAME));
        this.setShowGUI(this.getBooleanProperty(SHOW_GUI_PROPERTY_NAME, false));
        this.setSplitPolicy(this.getProperty(SPLIT_POLICY_PROPERTY_NAME));
        this.setSysVolume(this.getProperty(SYSTEM_VOLUME_PROPERTY_NAME, DEFAULT_SYSTEM_VOLUME_NAME));
        this.setBufferInventoryEnabled(this.getBooleanProperty(BUFFER_INVENTORY_PROPERTY_NAME, false));
        this.setBufferPreloadEnabled(this.getBooleanProperty(BUFFER_PRELOAD_PROPERTY_NAME, false));
        this.setUseOldVSpec(this.getBooleanProperty(USE_OLD_VSPEC, false));
        this.loadPropertiesBufferSpecifications();
        this.loadPropertiesVolumeSpecifications();
    }

    void loadPropertiesBufferSpecifications() {
        for (int index = 0; index < BUFFER_SIZES.length; ++index) {
            int size = BUFFER_SIZES[index];
            String countPropertyName = BUFFERS_PROPERTY_NAME + size;
            String memPropertyName = BUFFER_MEM_PROPERTY_NAME + size;
            String countSpec = this.getProperty(countPropertyName);
            String memSpec = this.getProperty(memPropertyName);
            int count = 0;
            BufferPoolConfiguration bpc = this.bufferPoolMap.get(size);
            if (countSpec != null) {
                bpc.parseBufferCount(size, countPropertyName, countSpec);
                ++count;
            }
            if (memSpec != null) {
                bpc.parseBufferMemory(size, countPropertyName, memSpec);
                ++count;
            }
            if (count > 1) {
                throw new IllegalArgumentException("Only one of " + countPropertyName + " and " + memPropertyName + " may be specified");
            }
            if (count != 0) continue;
            bpc.reset();
        }
    }

    void loadPropertiesVolumeSpecifications() throws InvalidVolumeSpecificationException {
        Enumeration<?> enumeration = this._properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(VOLUME_PROPERTY_PREFIX)) continue;
            boolean isOne = true;
            try {
                Integer.parseInt(key.substring(VOLUME_PROPERTY_PREFIX.length()));
            }
            catch (NumberFormatException nfe) {
                isOne = false;
            }
            if (!isOne) continue;
            String vstring = this.getProperty(key);
            this.volumeSpecifications.add(this.volumeSpecification(vstring));
        }
    }

    static final int bufferSizeFromPropertyName(String propertyName) {
        if (propertyName.startsWith(BUFFERS_PROPERTY_NAME) || propertyName.startsWith(BUFFER_MEM_PROPERTY_NAME)) {
            String[] s = propertyName.split("\\.");
            try {
                int size = Integer.parseInt(s[2]);
                Configuration.checkBufferSize(size);
                return size;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public String substituteProperties(String text, Properties properties) {
        return this.substituteProperties(text, properties, 0);
    }

    String substituteProperties(String text, Properties properties, int depth) {
        String propertyName;
        int q;
        int p = text.indexOf("${");
        while (p >= 0 && p < text.length() && (q = text.indexOf("}", p += 2)) > 0 && Util.isValidName(propertyName = text.substring(p, q))) {
            if (depth > 20) {
                throw new IllegalArgumentException("property " + propertyName + " substitution cycle is too deep");
            }
            String propertyValue = this.getProperty(propertyName, depth + 1, properties);
            if (propertyValue == null) {
                propertyValue = "";
            }
            text = text.substring(0, p - 2) + propertyValue + text.substring(q + 1);
            p = text.indexOf("${");
        }
        return text;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public String getProperty(String propertyName, String defaultValue) {
        String value = this.getProperty(propertyName, 0, this._properties);
        return value == null ? defaultValue : value;
    }

    private String getProperty(String propertyName, int depth, Properties properties) {
        String value = null;
        value = this.getSystemProperty(SYSTEM_PROPERTY_PREFIX + propertyName);
        if (value == null && properties != null) {
            value = properties.getProperty(propertyName);
        }
        if ("-".equals(value)) {
            value = null;
        }
        if (value == null && TIMESTAMP_PROPERTY.equals(propertyName)) {
            value = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
        }
        if (value != null) {
            value = this.substituteProperties(value, properties, depth);
        }
        return value;
    }

    public void setProperty(String propertyName, String value) {
        if (value == null) {
            this._properties.remove(propertyName);
        } else {
            this._properties.setProperty(propertyName, value);
        }
    }

    private String getSystemProperty(final String propertyName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        });
    }

    int getIntegerProperty(String propName, int dflt) {
        long v = this.getLongProperty(propName, dflt);
        if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
            return (int)v;
        }
        throw new IllegalArgumentException("Value out of range: " + v);
    }

    long getLongProperty(String propName, long dflt) {
        String str = this.getProperty(propName);
        if (str == null) {
            return dflt;
        }
        return Configuration.parseLongProperty(propName, str);
    }

    public static long parseLongProperty(String propName, String str) {
        if (str != null) {
            try {
                long multiplier = 1L;
                if (str.length() > 1) {
                    switch (str.charAt(str.length() - 1)) {
                        case 'T': 
                        case 't': {
                            multiplier = 0x10000000000L;
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            multiplier = 0x40000000L;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            multiplier = 0x100000L;
                            break;
                        }
                        case 'K': 
                        case 'k': {
                            multiplier = 1024L;
                        }
                    }
                }
                String sstr = str;
                if (multiplier > 1L) {
                    sstr = str.substring(0, str.length() - 1);
                }
                return Long.parseLong(sstr) * multiplier;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid number '" + str + "' for property " + propName);
    }

    public static float parseFloatProperty(String propName, String str) {
        if (str != null) {
            try {
                return Float.parseFloat(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid number '" + str + "' for property " + propName);
    }

    public static boolean parseBooleanValue(String propName, String str) {
        if ("true".equalsIgnoreCase(str)) {
            return true;
        }
        if ("false".equalsIgnoreCase(str)) {
            return false;
        }
        throw new IllegalArgumentException("Value '" + str + "' of property " + propName + " must be " + " either \"true\" or \"false\"");
    }

    static String displayableLongValue(long value) {
        int scale;
        if (value <= 0L) {
            return String.format("%d", value);
        }
        long v = value;
        for (scale = 0; v / 1024L * 1024L == v && scale < 3; ++scale, v /= 1024L) {
        }
        if (scale == 0) {
            return String.format("%d", v);
        }
        return String.format("%d%s", v, "KMGT".substring(scale - 1, scale));
    }

    public static int[] validBufferSizes() {
        return new int[]{1024, 2048, 4096, 8192, 16384};
    }

    public boolean getBooleanProperty(String propName, boolean dflt) {
        String str = this.getProperty(propName);
        if (str == null) {
            return dflt;
        }
        if ("true".equals(str = str.toLowerCase())) {
            return true;
        }
        if ("false".equals(str)) {
            return false;
        }
        throw new IllegalArgumentException("Value '" + str + "' of property " + propName + " must be " + " either \"true\" or \"false\"");
    }

    public VolumeSpecification volumeSpecification(String vstring) throws InvalidVolumeSpecificationException {
        VolumeSpecification volumeSpec = new VolumeSpecification(this.substituteProperties(vstring, this._properties, 0));
        return volumeSpec;
    }

    public Map<Integer, BufferPoolConfiguration> getBufferPoolMap() {
        return this.bufferPoolMap;
    }

    public String getBufferPoolConfiguration() {
        StringBuilder sb = new StringBuilder();
        for (BufferPoolConfiguration bpc : this.bufferPoolMap.values()) {
            if (bpc.getMaximumCount() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(bpc);
        }
        return sb.toString();
    }

    public void setBufferPoolConfiguration(String string) {
        for (BufferPoolConfiguration bpc : this.bufferPoolMap.values()) {
            bpc.reset();
        }
        for (String s : string.split(";")) {
            try {
                int bufferSize = Integer.parseInt(s.split(",")[0]);
                this.bufferPoolMap.get(bufferSize).parse(s);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid BufferPool memory specification: " + string);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid BufferPool memory specification: " + string);
            }
        }
    }

    public List<VolumeSpecification> getVolumeList() {
        return this.volumeSpecifications;
    }

    public void setVolumeList(List<VolumeSpecification> list) {
        this.volumeSpecifications.clear();
        this.volumeSpecifications.addAll(list);
    }

    public String getJournalPath() {
        return this.journalPath;
    }

    public void setJournalPath(String journalPath) {
        this.journalPath = journalPath;
    }

    public long getJournalSize() {
        return this.journalSize;
    }

    public void setJournalSize(long journalSize) {
        Util.rangeCheck(journalSize, 10000000L, 100000000000L);
        this.journalSize = journalSize;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = Util.rangeCheck(checkpointInterval, 10L, 3600L);
    }

    public String getSysVolume() {
        return this.sysVolume;
    }

    public void setSysVolume(String sysVolume) {
        this.sysVolume = sysVolume;
    }

    public String getTmpVolDir() {
        return this.tmpVolDir;
    }

    public void setTmpVolDir(String tmpVolDir) {
        this.tmpVolDir = tmpVolDir;
    }

    public int getTmpVolPageSize() {
        return this.tmpVolPageSize;
    }

    public void setTmpVolPageSize(int tmpVolPageSize) {
        this.tmpVolPageSize = tmpVolPageSize;
    }

    public long getTmpVolMaxSize() {
        return this.tmpVolMaxSize;
    }

    public void setTmpVolMaxSize(long tmpVolMaxSize) {
        Util.rangeCheck(tmpVolMaxSize, 65536L, Long.MAX_VALUE);
        this.tmpVolMaxSize = tmpVolMaxSize;
    }

    public Transaction.CommitPolicy getCommitPolicy() {
        return this.commitPolicy;
    }

    public void setCommitPolicy(String policyName) {
        if (policyName != null) {
            this.setCommitPolicy(Transaction.CommitPolicy.forName(policyName));
        }
    }

    public void setCommitPolicy(Transaction.CommitPolicy commitPolicy) {
        this.commitPolicy = commitPolicy;
    }

    public JoinPolicy getJoinPolicy() {
        return this.joinPolicy;
    }

    public void setJoinPolicy(String policyName) {
        if (policyName != null) {
            this.setJoinPolicy(JoinPolicy.forName(policyName));
        }
    }

    public void setJoinPolicy(JoinPolicy joinPolicy) {
        this.joinPolicy = joinPolicy;
    }

    public SplitPolicy getSplitPolicy() {
        return this.splitPolicy;
    }

    public void setSplitPolicy(String policyName) {
        if (policyName != null) {
            this.setSplitPolicy(SplitPolicy.forName(policyName));
        }
    }

    public void setSplitPolicy(SplitPolicy splitPolicy) {
        this.splitPolicy = splitPolicy;
    }

    public String getSerialOverride() {
        return this.serialOverride;
    }

    public void setSerialOverride(String serialOverride) {
        this.serialOverride = serialOverride;
    }

    public boolean isConstructorOverride() {
        return this.constructorOverride;
    }

    public void setConstructorOverride(boolean constructorOverride) {
        this.constructorOverride = constructorOverride;
    }

    public boolean isShowGUI() {
        return this.showGUI;
    }

    public void setShowGUI(boolean showGUI) {
        this.showGUI = showGUI;
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        this.logging = logging;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getRmiHost() {
        return this.rmiHost;
    }

    public void setRmiHost(String rmiHost) {
        this.rmiHost = rmiHost;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setRmiPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public int getRmiServerPort() {
        return this.rmiServerPort;
    }

    public void setRmiServerPort(int rmiServerPort) {
        this.rmiServerPort = rmiServerPort;
    }

    public boolean isJmxEnabled() {
        return this.jmx;
    }

    public void setJmxEnabled(boolean jmx) {
        this.jmx = jmx;
    }

    public boolean isAppendOnly() {
        return this.appendOnly;
    }

    public void setAppendOnly(boolean appendOnly) {
        this.appendOnly = appendOnly;
    }

    public boolean isBufferInventoryEnabled() {
        return this.bufferInventoryEnabled;
    }

    public void setBufferInventoryEnabled(boolean bufferInventoryEnabled) {
        this.bufferInventoryEnabled = bufferInventoryEnabled;
    }

    public boolean isBufferPreloadEnabled() {
        return this.bufferPreloadEnabled;
    }

    public void setBufferPreloadEnabled(boolean bufferPreloadEnabled) {
        this.bufferPreloadEnabled = bufferPreloadEnabled;
    }

    public boolean isIgnoreMissingVolumes() {
        return this.ignoreMissingVolumes;
    }

    public void setIgnoreMissingVolumes(boolean ignoreMissingVolumes) {
        this.ignoreMissingVolumes = ignoreMissingVolumes;
    }

    @Deprecated
    public boolean isUseOldVSpec() {
        return this.useOldVSpec;
    }

    @Deprecated
    public void setUseOldVSpec(boolean useOldVSpec) {
        this.useOldVSpec = useOldVSpec;
    }

    public static class BufferPoolConfiguration {
        private final int bufferSize;
        private int minimumCount;
        private int maximumCount;
        private long minimumMemory;
        private long maximumMemory;
        private long reservedMemory;
        private float fraction;
        private static final String SIMPLE_COUNT_FORMAT = "count=%d";
        private static final String MIN_MAX_COUNT_FORMAT = "minCount=%d,maxCount=%d";
        private static final String MIN_MAX_MEMORY_FORMAT = "minMem=%s,maxMem=%s,reserved=%s,fraction=%s";
        private static final Pattern SIMPLE_COUNT_PATTERN = Pattern.compile("count=([0-9]+[KMGT]?)", 2);
        private static final Pattern MIN_MAX_COUNT_PATTERN = Pattern.compile("minCount=([0-9KMGT]+),maxCount=([0-9KMGT]+)", 2);
        private static final Pattern MIN_MAX_MEMORY_PATTERN = Pattern.compile("minMem=([0-9]+[KMGT]?),maxMem=([0-9]+[KMGT]?),reserved=([0-9]+[KMGT]?),fraction=([0-9\\.]+)", 2);

        private void reset() {
            this.minimumCount = 0;
            this.maximumCount = 0;
            this.minimumMemory = 0L;
            this.maximumMemory = Long.MAX_VALUE;
            this.reservedMemory = 0L;
            this.fraction = 1.0f;
        }

        private BufferPoolConfiguration(int size) {
            this.bufferSize = size;
            this.reset();
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public int getMinimumCount() {
            return this.minimumCount;
        }

        public void setMinimumCount(int minimumCount) {
            Util.rangeCheck(minimumCount, 0, Integer.MAX_VALUE);
            this.minimumCount = minimumCount;
        }

        public int getMaximumCount() {
            return this.maximumCount;
        }

        public void setMaximumCount(int maximumCount) {
            Util.rangeCheck(maximumCount, 7, Integer.MAX_VALUE);
            this.maximumCount = maximumCount;
        }

        public void setCount(int count) {
            this.setMinimumCount(count);
            this.setMaximumCount(count);
        }

        public long getMinimumMemory() {
            return this.minimumMemory;
        }

        public void setMinimumMemory(long minimumMemory) {
            this.minimumMemory = minimumMemory;
        }

        public long getMaximumMemory() {
            return this.maximumMemory;
        }

        public void setMaximumMemory(long maximumMemory) {
            this.maximumMemory = maximumMemory;
        }

        public long getReservedMemory() {
            return this.reservedMemory;
        }

        public void setReservedMemory(long reservedMemory) {
            this.reservedMemory = reservedMemory;
        }

        public float getFraction() {
            return this.fraction;
        }

        public void setFraction(float fraction) {
            Util.rangeCheck(fraction, 0.0f, 1.0f);
            this.fraction = fraction;
        }

        public int computeBufferCount(long availableHeapMemory) {
            int bufferSizeWithOverhead;
            if (this.maximumCount == 0) {
                return 0;
            }
            long maximumAvailable = (long)((float)(availableHeapMemory - this.reservedMemory) * this.fraction);
            long allocation = Math.min(maximumAvailable, this.maximumMemory);
            int buffers = Math.max(this.minimumCount, Math.min(this.maximumCount, (int)(allocation / (long)(bufferSizeWithOverhead = Buffer.bufferSizeWithOverhead(this.bufferSize)))));
            if (buffers < 7 || buffers > Integer.MAX_VALUE || (long)buffers * (long)bufferSizeWithOverhead > maximumAvailable || (long)(buffers + 1) * (long)bufferSizeWithOverhead < this.minimumMemory) {
                throw new IllegalArgumentException(String.format("Invalid buffer pool configuration: %,d buffers in %sb of maximum available memory", buffers, Configuration.displayableLongValue(maximumAvailable)));
            }
            return buffers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.bufferSize).append(",");
            if (this.minimumCount == this.maximumCount) {
                sb.append(String.format(SIMPLE_COUNT_FORMAT, this.minimumCount));
            } else if (this.minimumCount != 0 || this.maximumCount != Integer.MAX_VALUE) {
                sb.append(String.format(MIN_MAX_COUNT_FORMAT, this.minimumCount, this.maximumCount));
            }
            if (this.minimumMemory != 0L || this.maximumMemory != Long.MAX_VALUE || this.reservedMemory != 0L || this.fraction != 1.0f) {
                sb.append(String.format(MIN_MAX_MEMORY_FORMAT, Configuration.displayableLongValue(this.minimumMemory), Configuration.displayableLongValue(this.maximumMemory), Configuration.displayableLongValue(this.reservedMemory), Float.valueOf(this.fraction)));
            }
            return sb.toString();
        }

        public void parse(String string) {
            String[] terms = string.split(",", 2);
            if (terms.length > 1) {
                this.checkBufferSize((int)Configuration.parseLongProperty(string, terms[0]), string);
                Matcher matcher = SIMPLE_COUNT_PATTERN.matcher(terms[1]);
                if (matcher.matches()) {
                    this.setCount((int)Configuration.parseLongProperty(string, matcher.group(1)));
                    return;
                }
                matcher = MIN_MAX_COUNT_PATTERN.matcher(terms[1]);
                if (matcher.matches()) {
                    this.setMinimumCount((int)Configuration.parseLongProperty(string, matcher.group(1)));
                    this.setMaximumCount((int)Configuration.parseLongProperty(string, matcher.group(2)));
                    return;
                }
                matcher = MIN_MAX_MEMORY_PATTERN.matcher(terms[1]);
                if (matcher.matches()) {
                    this.setMemoryConstraints(string, Configuration.parseLongProperty(string, matcher.group(1)), Configuration.parseLongProperty(string, matcher.group(2)), Configuration.parseLongProperty(string, matcher.group(3)), Configuration.parseFloatProperty(string, matcher.group(4)));
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid BufferPool memory specification: " + string);
        }

        public void parseBufferCount(int bufferSize, String propertyName, String propertyValue) {
            this.checkBufferSize(bufferSize, propertyName);
            this.reset();
            this.setCount((int)Configuration.parseLongProperty(propertyName, propertyValue));
        }

        public void parseBufferMemory(int bufferSize, String propertyName, String propertyValue) {
            this.checkBufferSize(bufferSize, propertyName);
            this.reset();
            long minimum = 0L;
            long maximum = Long.MAX_VALUE;
            long reserved = 0L;
            float fraction = 1.0f;
            String[] terms = propertyValue.split(",", 4);
            if (terms.length > 0 && !terms[0].isEmpty()) {
                maximum = minimum = Configuration.parseLongProperty(propertyName, terms[0]);
            }
            if (terms.length > 1 && !terms[1].isEmpty()) {
                maximum = Configuration.parseLongProperty(propertyName, terms[1]);
            }
            if (terms.length > 2 && !terms[2].isEmpty()) {
                reserved = Configuration.parseLongProperty(propertyName, terms[2]);
            }
            if (terms.length > 3 && !terms[3].isEmpty()) {
                fraction = Configuration.parseFloatProperty(propertyName, terms[3]);
            }
            this.setMemoryConstraints(propertyValue, minimum, maximum, reserved, fraction);
        }

        private void setMemoryConstraints(String propertyValue, long minimum, long maximum, long reserved, float fraction) {
            if (minimum < 0L || minimum > maximum || maximum - minimum < reserved || reserved < 0L) {
                throw new IllegalArgumentException("Invalid BufferPool memory specification: " + propertyValue);
            }
            Util.rangeCheck(fraction, 0.0f, 1.0f);
            this.setMinimumMemory(minimum);
            this.setMaximumMemory(maximum);
            this.setReservedMemory(reserved);
            this.setFraction(fraction);
            this.setMinimumCount(0);
            this.setMaximumCount(Integer.MAX_VALUE);
        }

        private void checkBufferSize(int size, String s) {
            if (size != this.bufferSize) {
                throw new IllegalArgumentException("Buffer size " + size + " does not match " + s);
            }
        }
    }
}

