/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.util.Util;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class JournalRecord {
    static final int OVERHEAD = 16;
    static final int SUB_RECORD_OVERHEAD = 12;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final int[] TYPES = new int[]{19013, 19016, 20545, 20557, 21330, 17490, 17492, 21581, 17232, 18774, 18772, 17457, 17456, 21592};

    public static boolean isValidType(int t) {
        for (int type : TYPES) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public static String str(int t) {
        if (JournalRecord.isValidType(t)) {
            return new String(new char[]{(char)(t >>> 8 & 0xFF), (char)(t & 0xFF)});
        }
        return "??";
    }

    private static void putByte(ByteBuffer bb, int offset, int value) {
        Util.putByte(bb.array(), bb.position() + offset, value);
    }

    static int getByte(ByteBuffer bb, int offset) {
        return Util.getByte(bb.array(), bb.position() + offset);
    }

    static void putChar(ByteBuffer bb, int offset, int value) {
        Util.putChar(bb.array(), bb.position() + offset, value);
    }

    static int getChar(ByteBuffer bb, int offset) {
        return Util.getChar(bb.array(), bb.position() + offset);
    }

    static void putInt(ByteBuffer bb, int offset, int value) {
        Util.putInt(bb.array(), bb.position() + offset, value);
    }

    static int getInt(ByteBuffer bb, int offset) {
        return Util.getInt(bb.array(), bb.position() + offset);
    }

    static void putLong(ByteBuffer bb, int offset, long value) {
        Util.putLong(bb.array(), bb.position() + offset, value);
    }

    static long getLong(ByteBuffer bb, int offset) {
        return Util.getLong(bb.array(), bb.position() + offset);
    }

    static int getLength(ByteBuffer bb) {
        return JournalRecord.getInt(bb, 0);
    }

    static void putLength(ByteBuffer bb, int length) {
        JournalRecord.putInt(bb, 0, length);
    }

    public static int getType(ByteBuffer bb) {
        return JournalRecord.getChar(bb, 4);
    }

    static void putType(ByteBuffer bb, int type) {
        JournalRecord.putChar(bb, 4, type);
    }

    public static long getTimestamp(ByteBuffer bb) {
        return JournalRecord.getLong(bb, 8);
    }

    public static void putTimestamp(ByteBuffer bb, long timestamp) {
        JournalRecord.putLong(bb, 8, timestamp);
    }

    static class D0
    extends JournalRecord {
        public static final int TYPE = 17456;
        public static final int OVERHEAD = 16;

        D0() {
        }

        public static void putType(ByteBuffer bb) {
            D0.putType(bb, 17456);
        }

        public static void putTreeHandle(ByteBuffer bb, int handle) {
            D0.putInt(bb, 8, handle);
        }

        public static int getTreeHandle(ByteBuffer bb) {
            return D0.getInt(bb, 8);
        }

        public static void putIndex(ByteBuffer bb, int index) {
            D0.putChar(bb, 12, index);
        }

        public static int getIndex(ByteBuffer bb) {
            return D0.getChar(bb, 12);
        }

        public static void putAccumulatorTypeOrdinal(ByteBuffer bb, int type) {
            D0.putChar(bb, 14, type);
        }

        public static int getAccumulatorTypeOrdinal(ByteBuffer bb) {
            return D0.getChar(bb, 14);
        }
    }

    static class D1
    extends JournalRecord {
        public static final int TYPE = 17457;
        public static final int OVERHEAD = 24;

        D1() {
        }

        public static void putType(ByteBuffer bb) {
            D1.putType(bb, 17457);
        }

        public static void putTreeHandle(ByteBuffer bb, int handle) {
            D1.putInt(bb, 8, handle);
        }

        public static int getTreeHandle(ByteBuffer bb) {
            return D1.getInt(bb, 8);
        }

        public static void putIndex(ByteBuffer bb, int index) {
            D1.putChar(bb, 12, index);
        }

        public static int getIndex(ByteBuffer bb) {
            return D1.getChar(bb, 12);
        }

        public static void putAccumulatorTypeOrdinal(ByteBuffer bb, int type) {
            D1.putChar(bb, 14, type);
        }

        public static int getAccumulatorTypeOrdinal(ByteBuffer bb) {
            return D1.getChar(bb, 14);
        }

        public static long getValue(ByteBuffer bb) {
            return D1.getLong(bb, 16);
        }

        public static void putValue(ByteBuffer bb, long value) {
            D1.putLong(bb, 16, value);
        }
    }

    static class DT
    extends JournalRecord {
        public static final int TYPE = 17492;
        public static final int OVERHEAD = 12;

        DT() {
        }

        public static void putType(ByteBuffer bb) {
            DT.putType(bb, 17492);
        }

        public static void putTreeHandle(ByteBuffer bb, int handle) {
            DT.putInt(bb, 8, handle);
        }

        public static int getTreeHandle(ByteBuffer bb) {
            return DT.getInt(bb, 8);
        }
    }

    static class DR
    extends JournalRecord {
        public static final int TYPE = 17490;
        public static final int OVERHEAD = 16;

        DR() {
        }

        public static void putType(ByteBuffer bb) {
            DR.putType(bb, 17490);
        }

        public static void putTreeHandle(ByteBuffer bb, int handle) {
            DR.putInt(bb, 8, handle);
        }

        public static int getTreeHandle(ByteBuffer bb) {
            return DR.getInt(bb, 8);
        }

        public static void putKey1Size(ByteBuffer bb, int size) {
            DR.putChar(bb, 12, size);
        }

        public static int getKey1Size(ByteBuffer bb) {
            return DR.getChar(bb, 12);
        }

        public static void putKey2Elision(ByteBuffer bb, int elisionCount) {
            DR.putChar(bb, 14, elisionCount);
        }

        public static int getKey2Elision(ByteBuffer bb) {
            return DR.getChar(bb, 14);
        }
    }

    static class SR
    extends JournalRecord {
        public static final int TYPE = 21330;
        public static final int OVERHEAD = 14;

        SR() {
        }

        public static void putType(ByteBuffer bb) {
            SR.putType(bb, 21330);
        }

        public static void putTreeHandle(ByteBuffer bb, int handle) {
            SR.putInt(bb, 8, handle);
        }

        public static int getTreeHandle(ByteBuffer bb) {
            return SR.getInt(bb, 8);
        }

        public static void putKeySize(ByteBuffer bb, int size) {
            SR.putChar(bb, 12, size);
        }

        public static int getKeySize(ByteBuffer bb) {
            return SR.getChar(bb, 12);
        }
    }

    static class TX
    extends JournalRecord {
        public static final int TYPE = 21592;
        public static final int OVERHEAD = 32;

        TX() {
        }

        public static void putType(ByteBuffer bb) {
            TX.putType(bb, 21592);
        }

        public static long getCommitTimestamp(ByteBuffer bb) {
            return TX.getLong(bb, 16);
        }

        public static void putCommitTimestamp(ByteBuffer bb, long address) {
            TX.putLong(bb, 16, address);
        }

        public static long getBackchainAddress(ByteBuffer bb) {
            return TX.getLong(bb, 24);
        }

        public static void putBackchainAddress(ByteBuffer bb, long address) {
            TX.putLong(bb, 24, address);
        }
    }

    static class CP
    extends JournalRecord {
        public static final int TYPE = 17232;
        public static final int OVERHEAD = 32;

        CP() {
        }

        public static void putType(ByteBuffer bb) {
            CP.putType(bb, 17232);
        }

        public static long getSystemTimeMillis(ByteBuffer bb) {
            return CP.getLong(bb, 16);
        }

        public static void putSystemTimeMillis(ByteBuffer bb, long systemTimeMillis) {
            CP.putLong(bb, 16, systemTimeMillis);
        }

        public static long getBaseAddress(ByteBuffer bb) {
            return CP.getLong(bb, 24);
        }

        public static void putBaseAddress(ByteBuffer bb, long base) {
            CP.putLong(bb, 24, base);
        }
    }

    static class PA
    extends JournalRecord {
        public static final int TYPE = 20545;
        public static final int OVERHEAD = 36;

        PA() {
        }

        public static void putType(ByteBuffer bb) {
            PA.putType(bb, 20545);
        }

        public static int getVolumeHandle(ByteBuffer bb) {
            return PA.getInt(bb, 16);
        }

        public static void putVolumeHandle(ByteBuffer bb, int volumeHandle) {
            PA.putInt(bb, 16, volumeHandle);
        }

        public static long getPageAddress(ByteBuffer bb) {
            return PA.getLong(bb, 20);
        }

        public static void putPageAddress(ByteBuffer bb, long pageAddress) {
            PA.putLong(bb, 20, pageAddress);
        }

        public static int getLeftSize(ByteBuffer bb) {
            return PA.getInt(bb, 28);
        }

        public static void putLeftSize(ByteBuffer bb, int leftSize) {
            PA.putInt(bb, 28, leftSize);
        }

        public static int getBufferSize(ByteBuffer bb) {
            return PA.getInt(bb, 32);
        }

        public static void putBufferSize(ByteBuffer bb, int bufferSize) {
            PA.putInt(bb, 32, (char)bufferSize);
        }
    }

    static class IT
    extends JournalRecord {
        public static final int TYPE = 18772;
        public static final int OVERHEAD = 24;
        public static final int MAX_LENGTH = 1048;

        IT() {
        }

        public static void putType(ByteBuffer bb) {
            IT.putType(bb, 18772);
        }

        public static int getHandle(ByteBuffer bb) {
            return IT.getInt(bb, 16);
        }

        public static void putHandle(ByteBuffer bb, int handle) {
            IT.putInt(bb, 16, handle);
        }

        public static int getVolumeHandle(ByteBuffer bb) {
            return IT.getInt(bb, 20);
        }

        public static void putVolumeHandle(ByteBuffer bb, int volumeHandle) {
            IT.putInt(bb, 20, volumeHandle);
        }

        public static String getTreeName(ByteBuffer bb) {
            int length = IT.getLength(bb) - 24;
            return new String(bb.array(), bb.position() + 24, length, UTF8);
        }

        public static void putTreeName(ByteBuffer bb, String treeName) {
            byte[] stringBytes = treeName.getBytes(UTF8);
            System.arraycopy(stringBytes, 0, bb.array(), bb.position() + 24, stringBytes.length);
            IT.putLength(bb, 24 + stringBytes.length);
        }
    }

    static class IV
    extends JournalRecord {
        public static final int TYPE = 18774;
        public static final int OVERHEAD = 28;
        public static final int MAX_LENGTH = 2076;

        IV() {
        }

        public static void putType(ByteBuffer bb) {
            IV.putType(bb, 18774);
        }

        public static int getHandle(ByteBuffer bb) {
            return IV.getInt(bb, 16);
        }

        public static void putHandle(ByteBuffer bb, int handle) {
            IV.putInt(bb, 16, handle);
        }

        public static long getVolumeId(ByteBuffer bb) {
            return IV.getLong(bb, 20);
        }

        public static void putVolumeId(ByteBuffer bb, long volumeId) {
            IV.putLong(bb, 20, volumeId);
        }

        public static String getVolumeSpecification(ByteBuffer bb) {
            int length = IV.getLength(bb) - 28;
            return new String(bb.array(), bb.position() + 28, length, UTF8);
        }

        public static void putVolumeSpecification(ByteBuffer bb, String volumeSpec) {
            byte[] stringBytes = volumeSpec.getBytes(UTF8);
            System.arraycopy(stringBytes, 0, bb.array(), bb.position() + 28, stringBytes.length);
            IV.putLength(bb, 28 + stringBytes.length);
        }
    }

    static class TM
    extends JournalRecord {
        public static final int TYPE = 21581;
        public static final int OVERHEAD = 16;
        public static final int ENTRY_SIZE = 32;

        TM() {
        }

        public static void putType(ByteBuffer bb) {
            TM.putType(bb, 21581);
        }

        public static int getEntryCount(ByteBuffer bb) {
            int length = TM.getLength(bb) - 16;
            return length / 32;
        }

        public static long getEntryStartTimestamp(ByteBuffer bb, int index) {
            return TM.getLong(bb, index * 32);
        }

        public static long getEntryCommitTimestamp(ByteBuffer bb, int index) {
            return TM.getLong(bb, 8 + index * 32);
        }

        public static long getEntryJournalAddress(ByteBuffer bb, int index) {
            return TM.getLong(bb, 16 + index * 32);
        }

        public static long getLastRecordAddress(ByteBuffer bb, int index) {
            return TM.getLong(bb, 24 + index * 32);
        }

        public static void putEntry(ByteBuffer bb, int index, long startTimestamp, long commitTimestamp, long journalAddress, long lastRecordAddress) {
            TM.putLong(bb, 0 + index * 32, startTimestamp);
            TM.putLong(bb, 8 + index * 32, commitTimestamp);
            TM.putLong(bb, 16 + index * 32, journalAddress);
            TM.putLong(bb, 24 + index * 32, lastRecordAddress);
        }
    }

    static class PM
    extends JournalRecord {
        public static final int TYPE = 20557;
        public static final int OVERHEAD = 16;
        public static final int ENTRY_SIZE = 28;

        PM() {
        }

        public static void putType(ByteBuffer bb) {
            PM.putType(bb, 20557);
        }

        public static int getEntryCount(ByteBuffer bb) {
            int length = PM.getLength(bb) - 16;
            return length / 28;
        }

        public static long getEntryTimestamp(ByteBuffer bb, int index) {
            return PM.getLong(bb, index * 28);
        }

        public static long getEntryJournalAddress(ByteBuffer bb, int index) {
            return PM.getLong(bb, 8 + index * 28);
        }

        public static int getEntryVolumeHandle(ByteBuffer bb, int index) {
            return PM.getInt(bb, 16 + index * 28);
        }

        public static long getEntryPageAddress(ByteBuffer bb, int index) {
            return PM.getLong(bb, 20 + index * 28);
        }

        public static void putEntry(ByteBuffer bb, int index, long timestamp, long journalAddress, int volumeHandle, long pageAddress) {
            PM.putLong(bb, 0 + index * 28, timestamp);
            PM.putLong(bb, 8 + index * 28, journalAddress);
            PM.putInt(bb, 16 + index * 28, volumeHandle);
            PM.putLong(bb, 20 + index * 28, pageAddress);
        }
    }

    static class JH
    extends JournalRecord {
        public static final int TYPE = 19016;
        public static final int OVERHEAD = 64;
        public static final int MAX_LENGTH = 2112;

        JH() {
        }

        public static void putType(ByteBuffer bb) {
            JH.putType(bb, 19016);
        }

        public static long getVersion(ByteBuffer bb) {
            return JH.getLong(bb, 16);
        }

        public static void putVersion(ByteBuffer bb, long version) {
            JH.putLong(bb, 16, version);
        }

        public static long getBaseJournalAddress(ByteBuffer bb) {
            return JH.getLong(bb, 24);
        }

        public static void putBaseJournalAddress(ByteBuffer bb, long address) {
            JH.putLong(bb, 24, address);
        }

        public static long getCurrentJournalAddress(ByteBuffer bb) {
            return JH.getLong(bb, 32);
        }

        public static void putCurrentJournalAddress(ByteBuffer bb, long address) {
            JH.putLong(bb, 32, address);
        }

        public static long getJournalCreatedTime(ByteBuffer bb) {
            return JH.getLong(bb, 40);
        }

        public static void putJournalCreatedTime(ByteBuffer bb, long time) {
            JH.putLong(bb, 40, time);
        }

        public static long getFileCreatedTime(ByteBuffer bb) {
            return JH.getLong(bb, 48);
        }

        public static void putFileCreatedTime(ByteBuffer bb, long time) {
            JH.putLong(bb, 48, time);
        }

        public static long getBlockSize(ByteBuffer bb) {
            return JH.getLong(bb, 56);
        }

        public static void putBlockSize(ByteBuffer bb, long size) {
            JH.putLong(bb, 56, size);
        }

        public static String getPath(ByteBuffer bb) {
            int length = JH.getLength(bb) - 64;
            return new String(bb.array(), bb.position() + 64, length, UTF8);
        }

        public static void putPath(ByteBuffer bb, String path) {
            byte[] stringBytes = path.getBytes(UTF8);
            System.arraycopy(stringBytes, 0, bb.array(), bb.position() + 64, stringBytes.length);
            JH.putLength(bb, 64 + stringBytes.length);
        }
    }

    static class JE
    extends JournalRecord {
        public static final int TYPE = 19013;
        public static final int OVERHEAD = 40;

        JE() {
        }

        public static void putType(ByteBuffer bb) {
            JE.putType(bb, 19013);
        }

        public static long getCurrentJournalAddress(ByteBuffer bb) {
            return JE.getLong(bb, 16);
        }

        public static void putCurrentJournalAddress(ByteBuffer bb, long address) {
            JE.putLong(bb, 16, address);
        }

        public static long getBaseAddress(ByteBuffer bb) {
            return JE.getLong(bb, 24);
        }

        public static void putBaseAddress(ByteBuffer bb, long address) {
            JE.putLong(bb, 24, address);
        }

        public static long getJournalCreatedTime(ByteBuffer bb) {
            return JE.getLong(bb, 32);
        }

        public static void putJournalCreatedTime(ByteBuffer bb, long time) {
            JE.putLong(bb, 32, time);
        }
    }
}

