/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.TransactionIndex;
import com.persistit.TransactionStatus;
import com.persistit.exception.CorruptValueException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.TimeoutException;
import com.persistit.exception.VersionsOutOfOrderException;
import com.persistit.util.Debug;
import com.persistit.util.Util;
import java.util.List;

class MVV {
    static final int TYPE_MVV = 254;
    static final int TYPE_ANTIVALUE = 49;
    static final int VERSION_NOT_FOUND = -1;
    static final int STORE_EXISTED_MASK = Integer.MIN_VALUE;
    static final int STORE_LENGTH_MASK = Integer.MAX_VALUE;
    static final byte TYPE_MVV_BYTE = -2;
    static final int PRIMORDIAL_VALUE_VERSION = 0;
    static final int UNDEFINED_VALUE_LENGTH = 0;
    static final int MAX_LENGTH_MASK = Short.MAX_VALUE;
    static final int MARKED_LENGTH_MASK = 32768;
    private static final int LENGTH_TYPE_MVV = 1;
    private static final int LENGTH_VERSION = 8;
    private static final int LENGTH_VALUE_LENGTH = 2;
    static final int LENGTH_PER_VERSION = 10;

    MVV() {
    }

    static long getVersion(byte[] bytes, int offset) {
        return Util.getLong(bytes, offset);
    }

    static void putVersion(byte[] bytes, int offset, long version) {
        Util.putLong(bytes, offset, version);
    }

    static int getLength(byte[] bytes, int offset) {
        return Util.getChar(bytes, offset + 8) & Short.MAX_VALUE;
    }

    static void putLength(byte[] bytes, int offset, int length) {
        Util.putChar(bytes, offset + 8, length);
    }

    static boolean isMarked(byte[] bytes, int offset) {
        return (Util.getChar(bytes, offset + 8) & 0x8000) != 0;
    }

    static void mark(byte[] bytes, int offset) {
        Util.putChar(bytes, offset + 8, Util.getChar(bytes, offset + 8) | 0x8000);
    }

    static void unmark(byte[] bytes, int offset) {
        Util.putChar(bytes, offset + 8, Util.getChar(bytes, offset + 8) & Short.MAX_VALUE);
    }

    static int overheadLength(int numVersions) {
        return 1 + 10 * numVersions;
    }

    static int estimateRequiredLength(byte[] source, int sourceLength, int newVersionLength) {
        if (sourceLength < 0) {
            return MVV.overheadLength(1) + newVersionLength;
        }
        if (sourceLength == 0 || source[0] != -2) {
            return MVV.overheadLength(2) + sourceLength + newVersionLength;
        }
        return sourceLength + 10 + newVersionLength;
    }

    static int exactRequiredLength(byte[] target, int targetOffset, int targetLength, long newVersion, int newVersionLength) {
        int valueLength;
        if (targetLength < 0) {
            return MVV.overheadLength(1) + newVersionLength;
        }
        if (targetLength == 0 || target[targetOffset] != -2) {
            return MVV.overheadLength(2) + targetLength + newVersionLength;
        }
        for (int offset = targetOffset + 1; offset < targetLength; offset += 10 + valueLength) {
            long version = MVV.getVersion(target, offset);
            valueLength = MVV.getLength(target, offset);
            if (version != newVersion) continue;
            return targetLength - valueLength + newVersionLength;
        }
        return targetLength + 10 + newVersionLength;
    }

    static boolean isArrayMVV(byte[] source, int offset, int length) {
        return length > 0 && source[offset] == -2;
    }

    public static int storeVersion(byte[] target, int targetOffset, int targetLength, int targetLimit, long versionHandle, byte[] source, int sourceOffset, int sourceLength) {
        int existedMask = 0;
        int to = targetOffset;
        int remainder = 0;
        int end = targetOffset + targetLength;
        if (targetLimit > target.length) {
            throw new IllegalArgumentException("Target limit exceed target array length: " + targetLimit + " > " + target.length);
        }
        if (source == target) {
            throw new IllegalArgumentException("Source and target arrays must be different");
        }
        if (sourceLength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Source length greater than max: " + sourceLength + " > " + Short.MAX_VALUE);
        }
        if (targetLength < 0) {
            MVV.assertCapacity(targetLimit, targetOffset + sourceLength + MVV.overheadLength(1));
            target[to++] = -2;
        } else if (targetLength == 0) {
            MVV.assertCapacity(targetLimit, targetOffset + sourceLength + MVV.overheadLength(2));
            target[to++] = -2;
            MVV.putVersion(target, to, 0L);
            MVV.putLength(target, to, 0);
            to += 10;
        } else if (target[0] != -2) {
            MVV.assertCapacity(targetLimit, targetOffset + sourceLength + targetLength + MVV.overheadLength(2));
            System.arraycopy(target, to, target, to + 1 + 10, targetLength);
            target[to++] = -2;
            MVV.putVersion(target, to, 0L);
            MVV.putLength(target, to, targetLength);
            to += 10 + targetLength;
        } else {
            assert (MVV.verify(target, targetOffset, targetLength));
            int next = ++to;
            while (next < end) {
                long curVersion = MVV.getVersion(target, to);
                int vlength = MVV.getLength(target, to);
                next += 10 + vlength;
                if (curVersion == versionHandle) {
                    existedMask = Integer.MIN_VALUE;
                    if (vlength == sourceLength) {
                        System.arraycopy(source, sourceOffset, target, next - vlength, vlength);
                        return targetLength | existedMask;
                    }
                    MVV.assertCapacity(targetLimit, targetOffset + targetLength + MVV.overheadLength(1) + to - next + sourceLength);
                    System.arraycopy(target, next, target, to, targetOffset + targetLength - next);
                    end -= next - to;
                    next = to;
                } else if (curVersion > versionHandle) {
                    if (TransactionIndex.vh2ts(versionHandle) != TransactionIndex.vh2ts(curVersion)) {
                        throw new VersionsOutOfOrderException("Versions out of order");
                    }
                    remainder = end - to;
                    break;
                }
                to = next;
            }
        }
        MVV.assertCapacity(targetLimit, end + 10 + sourceLength);
        if (remainder > 0) {
            System.arraycopy(target, to, target, to + sourceLength + 10, remainder);
        }
        MVV.putVersion(target, to, versionHandle);
        MVV.putLength(target, to, sourceLength);
        System.arraycopy(source, sourceOffset, target, to += 10, sourceLength);
        Debug.$assert0.t(MVV.verify(target, targetOffset, (to += sourceLength) - targetOffset + remainder));
        return to - targetOffset + remainder | existedMask;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int prune(byte[] bytes, int offset, int length, TransactionIndex ti, boolean convertToPrimordial, List<PrunedVersion> prunedVersionList) throws PersistitException {
        if (!MVV.isArrayMVV(bytes, offset, length)) {
            return length;
        }
        Debug.$assert0.t(MVV.verify(bytes, offset, length));
        primordial = convertToPrimordial;
        marked = 0;
        try {
            to = from = offset + 1;
            lastVersionIndex = -1;
            lastVersionHandle = -9223372036854775808L;
            lastVersionTc = 0x7FFFFFFFFFFFFFFFL;
            uncommittedTransactionTs = 0L;
            while (from < offset + length) {
                vlength = MVV.getLength(bytes, from);
                Debug.$assert0.t(vlength + from + 10 <= offset + length);
                versionHandle = MVV.getVersion(bytes, from);
                tc = ti.commitStatus(versionHandle, 0x7FFFFFFFFFFFFFFFL, 0);
                if (tc >= 0L) {
                    if (tc == 0x7FFFFFFFFFFFFFFFL) {
                        ts = TransactionIndex.vh2ts(versionHandle);
                        if (uncommittedTransactionTs != 0L && uncommittedTransactionTs != ts) {
                            throw new CorruptValueException("Multiple uncommitted versions");
                        }
                        uncommittedTransactionTs = ts;
                        MVV.mark(bytes, from);
                        ++marked;
                        if (lastVersionIndex != -1) {
                            MVV.mark(bytes, lastVersionIndex);
                            ++marked;
                            lastVersionIndex = -1;
                        }
                        primordial = false;
                    } else {
                        if (lastVersionIndex != -1 && ti.hasConcurrentTransaction(lastVersionTc, tc)) {
                            MVV.mark(bytes, lastVersionIndex);
                            ++marked;
                            primordial = false;
                        }
                        if (!MVV.$assertionsDisabled && versionHandle < lastVersionHandle && TransactionIndex.vh2ts(versionHandle) != TransactionIndex.vh2ts(lastVersionHandle)) {
                            throw new AssertionError();
                        }
                        if (!MVV.$assertionsDisabled && tc < lastVersionTc && lastVersionTc != 0x7FFFFFFFFFFFFFFFL) {
                            throw new AssertionError();
                        }
                        lastVersionIndex = from;
                        lastVersionHandle = versionHandle;
                        lastVersionTc = tc;
                    }
                }
                if ((from += vlength + 10) <= offset + length) continue;
                throw new CorruptValueException("MVV Value is corrupt at index: " + from);
            }
            if (lastVersionIndex != -1) {
                MVV.mark(bytes, lastVersionIndex);
                ++marked;
                if (ti.hasConcurrentTransaction(0L, lastVersionTc)) {
                    primordial = false;
                }
            }
            for (from = offset + 1; from < offset + length; from += vlength + 10) {
                vlength = MVV.getLength(bytes, from);
                Debug.$assert0.t(vlength + from + 10 <= offset + length);
                if (MVV.isMarked(bytes, from)) continue;
                version = MVV.getVersion(bytes, from);
                longRecordPage = 0L;
                if (vlength == 120 && (bytes[from + 10] & 255) == 255) {
                    longRecordPage = Buffer.decodeLongRecordDescriptorPointer(bytes, from + 10);
                }
                if (version == 0L && longRecordPage == 0L) continue;
                pv = new PrunedVersion(version, longRecordPage);
                prunedVersionList.add(pv);
            }
            if (!primordial || marked > 1) ** GOTO lbl-1000
            if (marked > 0) {
            }
            ** GOTO lbl-1000
        }
        catch (InterruptedException ie) {
            try {
                throw new PersistitInterruptedException(ie);
            }
            catch (Throwable var25_28) {
                if (marked <= 0) throw var25_28;
                index = offset + 1;
                do {
                    if (index >= length) throw var25_28;
                    vlength = MVV.getLength(bytes, index);
                    Debug.$assert0.t(vlength + index + 10 <= offset + length);
                    MVV.unmark(bytes, index);
                    index += vlength + 10;
                } while (vlength > 0);
                throw var25_28;
            }
        }
        for (from = offset + 1; from < offset + length; from += vlength + 10) {
            vlength = MVV.getLength(bytes, from);
            Debug.$assert0.t(vlength + from + 10 <= offset + length);
            if (!MVV.isMarked(bytes, from)) continue;
            System.arraycopy(bytes, from + 10, bytes, offset, vlength);
            Debug.$assert0.t(vlength == 0 || bytes[offset] != -2);
            version = vlength;
            if (--marked <= 0) return version;
            index = offset + 1;
            do {
                if (index >= length) return version;
                vlength = MVV.getLength(bytes, index);
                Debug.$assert0.t(vlength + index + 10 <= offset + length);
                MVV.unmark(bytes, index);
                index += vlength + 10;
            } while (vlength > 0);
            return version;
        }
lbl-1000:
        // 2 sources

        {
            bytes[offset] = 49;
            vlength = 1;
            if (marked <= 0) return vlength;
            index = offset + 1;
        }
        do {
            if (index >= length) return vlength;
            vlength = MVV.getLength(bytes, index);
            Debug.$assert0.t(vlength + index + 10 <= offset + length);
            MVV.unmark(bytes, index);
            index += vlength + 10;
        } while (vlength > 0);
        return vlength;
lbl-1000:
        // 1 sources

        {
            to = from = offset + 1;
            newLength = length;
            while (from < offset + newLength) {
                vlength = MVV.getLength(bytes, from);
                Debug.$assert0.t(vlength + from + 10 <= offset + length);
                if (MVV.isMarked(bytes, from)) {
                    MVV.unmark(bytes, from);
                    --marked;
                    if (from > to) {
                        System.arraycopy(bytes, from, bytes, to, offset + length - from);
                    }
                    newLength -= from - to;
                    from = to += vlength + 10;
                    continue;
                }
                from += vlength + 10;
            }
            Debug.$assert0.t(MVV.verify(bytes, offset, to - offset));
            var18_15 = to - offset;
            if (marked <= 0) return var18_15;
            index = offset + 1;
        }
        do {
            if (index >= length) return var18_15;
            vlength = MVV.getLength(bytes, index);
            Debug.$assert0.t(vlength + index + 10 <= offset + length);
            MVV.unmark(bytes, index);
            index += vlength + 10;
        } while (vlength > 0);
        return var18_15;
    }

    static boolean verify(byte[] bytes, int offset, int length) {
        int vlength;
        if (!MVV.isArrayMVV(bytes, offset, length)) {
            return true;
        }
        for (int from = offset + 1; from < offset + length; from += vlength + 10) {
            vlength = MVV.getLength(bytes, from);
            if (vlength >= 0 && from + vlength + 10 <= offset + length) continue;
            return false;
        }
        return true;
    }

    static boolean verify(TransactionIndex ti, byte[] bytes, int offset, int length) {
        int vlength;
        if (!MVV.isArrayMVV(bytes, offset, length)) {
            return true;
        }
        long lastVersion = -1L;
        for (int from = offset + 1; from < offset + length; from += vlength + 10) {
            vlength = MVV.getLength(bytes, from);
            long version = MVV.getVersion(bytes, from);
            if (vlength < 0 || from + vlength + 10 > offset + length) {
                return false;
            }
            if (version < -1L) {
                try {
                    long lastVersionTc = ti.commitStatus(-1L, Long.MAX_VALUE, 0);
                    assert (lastVersionTc == Long.MIN_VALUE);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
            assert (version != -1L);
        }
        return true;
    }

    public static int fetchVersion(byte[] source, int sourceLength, long version, byte[] target) {
        int offset = 0;
        int length = -1;
        if (version == 0L && (sourceLength == 0 || source[0] != -2)) {
            length = sourceLength;
        } else if (sourceLength > 0 && source[0] == -2) {
            int curLength;
            for (offset = 1; offset < sourceLength; offset += curLength) {
                long curVersion = Util.getLong(source, offset);
                curLength = Util.getShort(source, offset + 8);
                offset += 10;
                if (curVersion != version) continue;
                length = curLength;
                break;
            }
        }
        if (length > 0) {
            MVV.assertCapacity(target.length, length);
            System.arraycopy(source, offset, target, 0, length);
        }
        return length;
    }

    public static void visitAllVersions(VersionVisitor visitor, byte[] source, int sourceOffset, int sourceLength) throws PersistitException {
        visitor.init();
        if (sourceLength >= 0) {
            if (sourceLength == 0) {
                visitor.sawVersion(0L, sourceOffset, 0);
            } else if (source[sourceOffset] != -2) {
                visitor.sawVersion(0L, sourceOffset, sourceLength);
            } else {
                int offset;
                int valueLength;
                for (offset = sourceOffset + 1; offset < sourceOffset + sourceLength; offset += valueLength) {
                    long version = Util.getLong(source, offset);
                    valueLength = Util.getShort(source, offset + 8);
                    visitor.sawVersion(version, offset += 10, valueLength);
                }
                if (offset != sourceOffset + sourceLength) {
                    throw new CorruptValueException("invalid length in MVV at offset/length=" + sourceOffset + "/" + sourceLength);
                }
            }
        }
    }

    public static int fetchVersionByOffset(byte[] source, int sourceLength, int offset, byte[] target) {
        int length;
        if (offset < 0 || offset > 0 && offset > sourceLength) {
            throw new IllegalArgumentException("Offset out of range: " + offset);
        }
        int n = length = offset == 0 ? sourceLength : Util.getShort(source, offset - 2);
        if (length > 0) {
            MVV.assertCapacity(target.length, length);
            System.arraycopy(source, offset, target, 0, length);
        }
        return length;
    }

    private static void assertCapacity(int limit, int length) throws IllegalArgumentException {
        if (limit < length) {
            throw new IllegalArgumentException("Destination array not big enough: " + limit + " < " + length);
        }
    }

    public static interface VersionVisitor {
        public void init() throws PersistitException;

        public void sawVersion(long var1, int var3, int var4) throws PersistitException;
    }

    static class PrunedVersion {
        private final long _version;
        private final long _longRecordPage;

        private PrunedVersion(long version, long longRecordPage) {
            this._version = version;
            this._longRecordPage = longRecordPage;
        }

        public long getVersionHandle() {
            return this._version;
        }

        public long getTs() {
            return TransactionIndex.vh2ts(this._version);
        }

        public long getLongRecordPage() {
            return this._longRecordPage;
        }

        public String toString() {
            return "PrunedVersion(" + TransactionStatus.versionString(this._version) + "," + this._longRecordPage + ")";
        }
    }
}

