/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.KeyState;
import com.persistit.Task;
import com.persistit.Tree;
import com.persistit.TreeStatistics;
import com.persistit.ValueState;
import com.persistit.Volume;
import com.persistit.VolumeSpecification;
import com.persistit.VolumeStatistics;
import com.persistit.VolumeStorage;
import com.persistit.VolumeStructure;
import com.persistit.encoding.CoderContext;
import com.persistit.mxbeans.ManagementMXBean;
import com.persistit.util.Util;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Map;
import javax.management.ObjectName;

public interface Management
extends Remote,
ManagementMXBean {
    public void setAppendOnly(boolean var1) throws RemoteException;

    public void setJournalCopyingFast(boolean var1) throws RemoteException;

    public boolean close() throws RemoteException;

    public BufferPoolInfo[] getBufferPoolInfoArray() throws RemoteException;

    public RecordInfo[] getRecordInfoArray(String var1, long var2) throws RemoteException;

    public LogicalRecord[] getLogicalRecordArray(String var1, String var2, String var3, KeyState var4, Key.Direction var5, int var6, int var7, boolean var8) throws RemoteException;

    public JournalInfo getJournalInfo() throws RemoteException;

    public RecoveryInfo getRecoveryInfo() throws RemoteException;

    public TransactionInfo getTransactionInfo() throws RemoteException;

    public LogicalRecordCount getLogicalRecordCount(String var1, String var2, String var3, KeyState var4, Key.Direction var5, int var6) throws RemoteException;

    public BufferInfo[] getBufferInfoArray(int var1, int var2, String var3, String var4) throws RemoteException;

    public BufferInfo getBufferInfo(String var1, long var2) throws RemoteException;

    public BufferInfo getBufferInfo(String var1, String var2, KeyState var3, int var4) throws RemoteException;

    public int populateBufferInfoArray(BufferInfo[] var1, int var2, int var3, String var4, String var5) throws RemoteException;

    public VolumeInfo[] getVolumeInfoArray() throws RemoteException;

    public Class<?> getRemoteClass(String var1) throws RemoteException;

    public VolumeInfo getVolumeInfo(String var1) throws RemoteException;

    public TreeInfo[] getTreeInfoArray(String var1) throws RemoteException;

    public TreeInfo getTreeInfo(String var1, String var2) throws RemoteException;

    public int parseKeyFilterString(String var1) throws RemoteException;

    public Object[] decodeValueObjects(ValueState var1, CoderContext var2) throws RemoteException;

    public Object[] decodeKeyObjects(KeyState var1, CoderContext var2) throws RemoteException;

    public long startTask(String var1, String var2, String var3, long var4, int var6) throws RemoteException;

    public String launch(Task var1, String var2) throws RemoteException;

    public TaskStatus[] queryTaskStatus(long var1, boolean var3, boolean var4) throws RemoteException;

    public TaskStatus[] queryTaskStatus(long var1, boolean var3, boolean var4, boolean var5) throws RemoteException;

    public void setTaskSuspended(long var1, boolean var3) throws RemoteException;

    public void stopTask(long var1, boolean var3) throws RemoteException;

    public void removeFinishedTasks(long var1) throws RemoteException;

    public DisplayFilter getDisplayFilter() throws RemoteException;

    public void setDisplayFilter(DisplayFilter var1) throws RemoteException;

    public Map<ObjectName, Object> getMXBeans() throws RemoteException;

    public static class WrappedRemoteException
    extends RemoteException {
        public static final long serialVersionUID = 3297945951883397630L;
        Throwable cause;

        public WrappedRemoteException(Throwable cause) {
            this.cause = cause;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }

    public static class TransactionInfo
    extends AcquisitionTimeBase {
        private static final long serialVersionUID = -8355613679126582750L;
        long commitCount;
        long rollbackCount;
        long rollbackSinceCommitCount;

        public TransactionInfo() {
        }

        @ConstructorProperties(value={"commitCount", "rollbackCount", "rollbackSinceCommitCount"})
        public TransactionInfo(long commitCount, long rollbackCount, long rollbackSinceCommitCount) {
            this.commitCount = commitCount;
            this.rollbackCount = rollbackCount;
            this.rollbackSinceCommitCount = rollbackSinceCommitCount;
        }

        public long getCommitCount() {
            return this.commitCount;
        }

        public long getRollbackCount() {
            return this.rollbackCount;
        }

        public long getRollbackSinceCommitCount() {
            return this.rollbackSinceCommitCount;
        }
    }

    public static class RecoveryInfo
    extends AcquisitionTimeBase {
        private static final long serialVersionUID = 794617172781091495L;
        String keystoneJournalFile;
        long keystoneJournalAddress;
        long blockSize;
        int pageMapSize;
        long baseAddress;
        long currentAddress;
        long lastValidCheckpointTimestamp;
        long lastValidCheckpointSystemTime;
        String lastValidCheckpointJournalFile;
        long lastValidCheckpointJournalAddress;
        int committedTransactions;
        int uncommittedTransactions;
        int errorCount;
        int appliedTransactions;
        long recoveryStatus;
        long recoveryEndAddress;
        String recoveryException;
        boolean copySuspended;
        boolean copyFast;

        public RecoveryInfo() {
        }

        @ConstructorProperties(value={"keystoneJournalFile", "keystoneJournalAddress", "blockSize", "pageMapSize", "baseAddress", "currentAddress", "lastValidCheckpointTimestamp", "lastValidCheckpointSystemTime", "lastValidCheckpointJournalFile", "lastValidCheckpointJournalAddress", "committedTransactions", "uncommittedTransactions", "errorCount", "appliedTransactions", "recoveryStatus", "recoveryEndAddress", "recoveryException", "copySuspended", "copyFast"})
        public RecoveryInfo(String keystoneJournalFile, long keystoneJournalAddress, long blockSize, int pageMapSize, long baseAddress, long currentAddress, long lastValidCheckpointTimestamp, long lastValidCheckpointSystemTime, String lastValidCheckpointJournalFile, long lastValidCheckpointJournalAddress, int committedTransactions, int uncommittedTransactions, int errorCount, int appliedTransactions, long recoveryStatus, long recoveryEndAddress, String recoveryException, boolean copySuspended, boolean copyFast) {
            this.keystoneJournalFile = keystoneJournalFile;
            this.keystoneJournalAddress = keystoneJournalAddress;
            this.blockSize = blockSize;
            this.pageMapSize = pageMapSize;
            this.baseAddress = baseAddress;
            this.currentAddress = currentAddress;
            this.lastValidCheckpointTimestamp = lastValidCheckpointTimestamp;
            this.lastValidCheckpointSystemTime = lastValidCheckpointSystemTime;
            this.lastValidCheckpointJournalFile = lastValidCheckpointJournalFile;
            this.lastValidCheckpointJournalAddress = lastValidCheckpointJournalAddress;
            this.committedTransactions = committedTransactions;
            this.uncommittedTransactions = uncommittedTransactions;
            this.errorCount = errorCount;
            this.appliedTransactions = appliedTransactions;
            this.recoveryStatus = recoveryStatus;
            this.recoveryEndAddress = recoveryEndAddress;
            this.recoveryException = recoveryException;
            this.copySuspended = copySuspended;
            this.copyFast = copyFast;
        }

        public String getKeystoneJournalFile() {
            return this.keystoneJournalFile;
        }

        public long getKeystoneJournalAddress() {
            return this.keystoneJournalAddress;
        }

        public long getBlockSize() {
            return this.blockSize;
        }

        public int getPageMapSize() {
            return this.pageMapSize;
        }

        public long getBaseAddress() {
            return this.baseAddress;
        }

        public long getLastValidCheckpointTimestamp() {
            return this.lastValidCheckpointTimestamp;
        }

        public long getLastValidCheckpointSystemTime() {
            return this.lastValidCheckpointSystemTime;
        }

        public String getLastValidCheckpointJournalFile() {
            return this.lastValidCheckpointJournalFile;
        }

        public long getLastValidCheckpointJournalAddress() {
            return this.lastValidCheckpointJournalAddress;
        }

        public long getCurrentAddress() {
            return this.currentAddress;
        }

        public long getRecoveryStatus() {
            return this.recoveryStatus;
        }

        public int getCommittedTransactions() {
            return this.committedTransactions;
        }

        public int getUncommittedTransactions() {
            return this.uncommittedTransactions;
        }

        public int getAppliedTransactions() {
            return this.appliedTransactions;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public long getRecoveryEndAddress() {
            return this.recoveryEndAddress;
        }

        public String getRecoveryEndedException() {
            return this.recoveryException;
        }
    }

    public static class JournalInfo
    extends AcquisitionTimeBase {
        private static final long serialVersionUID = -6628208913672254686L;
        String currentJournalFile;
        long currentJournalAddress;
        long blockSize;
        int pageMapSize;
        long currentGeneration;
        long baseAddress;
        long lastValidCheckpointTimestamp;
        long lastValidCheckpointSystemTime;
        String lastValidCheckpointJournalFile;
        long lastValidCheckpointJournalAddress;
        String recoveryJournalFile;
        long recoveryJournalAddress;
        long recoveryStatus;
        long journaledPageCount;
        long readPageCount;
        long copiedPageCount;
        long droppedPageCount;
        int recoveredCommittedTransactions;
        int recoveredAppliedTransactions;
        boolean closed;
        boolean copying;
        boolean flushing;
        boolean appendOnly;
        boolean fastCopying;

        public JournalInfo() {
        }

        @ConstructorProperties(value={"currentJournalFile", "currentJournalAddress", "blockSize", "pageMapSize", "currentGeneration", "baseAddress", "lastValidCheckpointTimestamp", "lastValidCheckpointSystemTime", "lastValidCheckpointJournalFile", "lastValidCheckpointJournalAddress", "recoveryJournalFile", "recoveryJournalAddress", "recoveryStatus", "journaledPageCount", "readPageCount", "copiedPageCount", "droppedPageCount", "recoveredCommittedTransactions", "recoveredAppliedTransactions", "closed", "copying", "flushing", "appendOnly", "fastCopying"})
        public JournalInfo(String currentJournalFile, long currentJournalAddress, long blockSize, int pageMapSize, long currentGeneration, long baseAddress, long lastValidCheckpointTimestamp, long lastValidCheckpointSystemTime, String lastValidCheckpointJournalFile, long lastValidCheckpointJournalAddress, String recoveryJournalFile, long recoveryJournalAddress, long recoveryStatus, long journaledPageCount, long readPageCount, long copiedPageCount, long droppedPageCount, int recoveredCommittedTransactions, int recoveredAppliedTransactions, boolean closed, boolean copying, boolean flushing, boolean appendOnly, boolean fastCopying) {
            this.currentJournalFile = currentJournalFile;
            this.currentJournalAddress = currentJournalAddress;
            this.blockSize = blockSize;
            this.pageMapSize = pageMapSize;
            this.currentGeneration = currentGeneration;
            this.baseAddress = baseAddress;
            this.lastValidCheckpointTimestamp = lastValidCheckpointTimestamp;
            this.lastValidCheckpointSystemTime = lastValidCheckpointSystemTime;
            this.lastValidCheckpointJournalFile = lastValidCheckpointJournalFile;
            this.lastValidCheckpointJournalAddress = lastValidCheckpointJournalAddress;
            this.recoveryJournalFile = recoveryJournalFile;
            this.recoveryJournalAddress = recoveryJournalAddress;
            this.recoveryStatus = recoveryStatus;
            this.journaledPageCount = journaledPageCount;
            this.readPageCount = readPageCount;
            this.copiedPageCount = copiedPageCount;
            this.droppedPageCount = droppedPageCount;
            this.recoveredCommittedTransactions = recoveredCommittedTransactions;
            this.recoveredAppliedTransactions = recoveredAppliedTransactions;
            this.closed = closed;
            this.copying = copying;
            this.flushing = flushing;
            this.appendOnly = appendOnly;
            this.fastCopying = fastCopying;
        }

        public String getCurrentJournalFile() {
            return this.currentJournalFile;
        }

        public long getCurrentJournalAddress() {
            return this.currentJournalAddress;
        }

        public long getBlockSize() {
            return this.blockSize;
        }

        public int getPageMapSize() {
            return this.pageMapSize;
        }

        public long getBaseAddress() {
            return this.baseAddress;
        }

        public long getLastValidCheckpointTimestamp() {
            return this.lastValidCheckpointTimestamp;
        }

        public long getLastValidCheckpointSystemTime() {
            return this.lastValidCheckpointSystemTime;
        }

        public long getLastValidCheckpointAge() {
            return (System.currentTimeMillis() - this.lastValidCheckpointSystemTime + 500L) / 1000L;
        }

        public String getLastValidCheckpointJournalFile() {
            return this.lastValidCheckpointJournalFile;
        }

        public long getLastValidCheckpointJournalAddress() {
            return this.lastValidCheckpointJournalAddress;
        }

        public String getRecoveryJournalFile() {
            return this.recoveryJournalFile;
        }

        public long getRecoveryJournalAddress() {
            return this.recoveryJournalAddress;
        }

        public long getRecoveryStatus() {
            return this.recoveryStatus;
        }

        public long getJournaledPageCount() {
            return this.journaledPageCount;
        }

        public long getCopiedPageCount() {
            return this.copiedPageCount;
        }

        public long getDroppedPageCount() {
            return this.droppedPageCount;
        }

        public long getReadPageCount() {
            return this.readPageCount;
        }

        public int getRecoveredCompletedTransactions() {
            return this.recoveredCommittedTransactions;
        }

        public int getRecoveredCommittedTransactions() {
            return this.recoveredAppliedTransactions;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean isCopying() {
            return this.copying;
        }

        public boolean isFlushing() {
            return this.flushing;
        }

        public boolean isAppendOnly() {
            return this.appendOnly;
        }

        public boolean isFastCopying() {
            return this.fastCopying;
        }
    }

    public static class TaskStatus
    extends AcquisitionTimeBase
    implements Serializable {
        public static final long serialVersionUID = 8913876646811877035L;
        long taskId;
        String description;
        String owner;
        int state;
        String stateName;
        long startTime;
        long finishTime;
        long expirationTime;
        String statusSummary;
        String statusDetail;
        String[] newMessages;
        String lastException;

        public TaskStatus() {
        }

        @ConstructorProperties(value={"taskId", "description", "owner", "state", "stateName", "startTime", "finishTime", "expirationTime", "statusSummary", "statusDetail", "newMessages", "lastException"})
        public TaskStatus(long taskId, String description, String owner, int state, String stateName, long startTime, long finishTime, long expirationTime, String statusSummary, String statusDetail, String[] newMessages, String lastException) {
            this.taskId = taskId;
            this.description = description;
            this.owner = owner;
            this.state = state;
            this.stateName = stateName;
            this.startTime = startTime;
            this.finishTime = finishTime;
            this.expirationTime = expirationTime;
            this.statusSummary = statusSummary;
            this.statusDetail = statusDetail;
            this.newMessages = newMessages;
            this.lastException = lastException;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public String getDescription() {
            return this.description;
        }

        public String getOwner() {
            return this.owner;
        }

        public int getState() {
            return this.state;
        }

        public String getStateString() {
            return this.stateName;
        }

        public String getStatusSummary() {
            return this.statusSummary;
        }

        public String getStatusDetail() {
            return this.statusDetail;
        }

        public String[] getMessages() {
            return this.newMessages;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public String getLastException() {
            return this.lastException;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean details) {
            if (details) {
                StringBuilder sb = new StringBuilder(String.format("%d: %s start=%s finish=%s status=%s exception=%s", this.taskId, this.stateName, Util.date(this.startTime), Util.date(this.finishTime), this.statusDetail, this.lastException));
                for (String message : this.newMessages) {
                    sb.append(Util.NEW_LINE);
                    sb.append("  ");
                    sb.append(message);
                }
                return sb.toString();
            }
            return this.taskId + ": " + this.stateName;
        }

        public boolean equals(Object object) {
            return object instanceof TaskStatus && ((TaskStatus)object).getTaskId() == this.taskId;
        }
    }

    public static class TreeInfo
    extends AcquisitionTimeBase
    implements Serializable {
        public static final long serialVersionUID = -8707513438024673939L;
        String name;
        long rootPageAddress;
        int depth;
        String volumePathName;
        String status;
        String writerThreadName;
        long _fetchCounter;
        long _traverseCounter;
        long _storeCounter;
        long _removeCounter;

        TreeInfo(Tree tree) {
            this.name = tree.getName();
            this.rootPageAddress = tree.getRootPageAddr();
            this.depth = tree.getDepth();
            this.status = tree.getStatusCode();
            this.volumePathName = tree.getVolume().getPath();
            Thread thread = tree.getWriterThread();
            this.writerThreadName = thread == null ? null : thread.getName();
            TreeStatistics stats = tree.getStatistics();
            this._fetchCounter = stats.getFetchCounter();
            this._traverseCounter = stats.getTraverseCounter();
            this._storeCounter = stats.getStoreCounter();
            this._removeCounter = stats.getRemoveCounter();
        }

        @ConstructorProperties(value={"name", "index", "rootPageAddress", "depth", "volumePathName", "status", "writerThreadName", "fetchCounter", "traverseCounter", "storeCounter", "removeCounter"})
        public TreeInfo(String name, long rootPageAddress, int depth, String volumePathName, String status, String writerThreadName, long fetchCounter, long traverseCounter, long storeCounter, long removeCounter) {
            this.name = name;
            this.rootPageAddress = rootPageAddress;
            this.depth = depth;
            this.volumePathName = volumePathName;
            this.status = status;
            this.writerThreadName = writerThreadName;
            this._fetchCounter = fetchCounter;
            this._traverseCounter = traverseCounter;
            this._storeCounter = storeCounter;
            this._removeCounter = removeCounter;
        }

        public String getName() {
            return this.name;
        }

        public long getRootPageAddress() {
            return this.rootPageAddress;
        }

        public int getDepth() {
            return this.depth;
        }

        public String getVolumePathName() {
            return this.volumePathName;
        }

        public long getFetchCounter() {
            return this._fetchCounter;
        }

        public long getTraverseCounter() {
            return this._traverseCounter;
        }

        public long getStoreCounter() {
            return this._storeCounter;
        }

        public long getRemoveCounter() {
            return this._removeCounter;
        }

        public String getStatus() {
            return this.status;
        }

        public String getWriterThreadName() {
            return this.writerThreadName;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            return object instanceof TreeInfo && ((TreeInfo)object).getName().equals(this.name);
        }
    }

    public static class VolumeInfo
    extends AcquisitionTimeBase
    implements Serializable,
    Comparable<VolumeInfo> {
        public static final long serialVersionUID = -1231320633942497896L;
        int pageSize;
        String path;
        String name;
        long id;
        long createTime;
        long openTime;
        long generation;
        long getCounter;
        long readCounter;
        long writeCounter;
        long lastRead;
        long lastWrite;
        long lastExtension;
        long maximumPage;
        long currentPageCount;
        long maximumPageCount;
        long extensionPageCount;
        long garbageRootPage;
        long fetchCounter;
        long traverseCounter;
        long storeCounter;
        long removeCounter;
        boolean isTemporary;

        VolumeInfo(Volume vol) {
            this.path = vol.getPath();
            this.id = vol.getId();
            VolumeStatistics stat = vol.getStatistics();
            VolumeStructure struc = vol.getStructure();
            VolumeStorage store = vol.getStorage();
            VolumeSpecification spec = vol.getSpecification();
            this.createTime = stat.getCreateTime();
            this.generation = store.getGeneration();
            this.getCounter = stat.getGetCounter();
            this.readCounter = stat.getReadCounter();
            this.writeCounter = stat.getWriteCounter();
            this.fetchCounter = stat.getFetchCounter();
            this.storeCounter = stat.getStoreCounter();
            this.removeCounter = stat.getRemoveCounter();
            this.traverseCounter = stat.getTraverseCounter();
            this.pageSize = struc.getPageSize();
            this.openTime = stat.getOpenTime();
            this.lastRead = stat.getLastReadTime();
            this.lastWrite = stat.getLastWriteTime();
            this.lastExtension = stat.getLastExtensionTime();
            this.maximumPage = stat.getNextAvailablePage();
            this.currentPageCount = store.getExtentedPageCount();
            this.maximumPageCount = spec.getMaximumPages();
            this.extensionPageCount = spec.getExtensionPages();
            this.garbageRootPage = struc.getGarbageRoot();
            this.isTemporary = vol.isTemporary();
            this.name = vol.getName();
        }

        @ConstructorProperties(value={"pageSize", "path", "name", "id", "createTime", "openTime", "generation", "getCounter", "readCounter", "writeCounter", "lastRead", "lastWrite", "lastExtension", "maximumPage", "currentPageCount", "maximumPageCount", "extensionPageCount", "garbageRootPage", "fetchCounter", "traverseCounter", "storeCounter", "removeCounter", "isTransient"})
        public VolumeInfo(int pageSize, String path, String name, long id, long createTime, long openTime, long generation, long getCounter, long readCounter, long writeCounter, long lastRead, long lastWrite, long lastExtension, long maximumPage, long currentPageCount, long maximumPageCount, long extensionPageCount, long garbageRootPage, long fetchCounter, long traverseCounter, long storeCounter, long removeCounter, boolean isTransient) {
            this.pageSize = pageSize;
            this.path = path;
            this.name = name;
            this.id = id;
            this.createTime = createTime;
            this.openTime = openTime;
            this.generation = generation;
            this.getCounter = getCounter;
            this.readCounter = readCounter;
            this.writeCounter = writeCounter;
            this.lastRead = lastRead;
            this.lastWrite = lastWrite;
            this.lastExtension = lastExtension;
            this.maximumPage = maximumPage;
            this.currentPageCount = currentPageCount;
            this.maximumPageCount = maximumPageCount;
            this.extensionPageCount = extensionPageCount;
            this.garbageRootPage = garbageRootPage;
            this.fetchCounter = fetchCounter;
            this.traverseCounter = traverseCounter;
            this.storeCounter = storeCounter;
            this.removeCounter = removeCounter;
            this.isTemporary = isTransient;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public Date getCreateTime() {
            return new Date(this.createTime);
        }

        public Date getOpenTime() {
            return new Date(this.openTime);
        }

        public Date getLastReadTime() {
            return new Date(this.lastRead);
        }

        public Date getLastWriteTime() {
            return new Date(this.lastWrite);
        }

        public Date getLastExtensionTime() {
            return new Date(this.lastExtension);
        }

        public long getGeneration() {
            return this.generation;
        }

        public long getGetCounter() {
            return this.getCounter;
        }

        public long getReadCounter() {
            return this.readCounter;
        }

        public long getWriteCounter() {
            return this.writeCounter;
        }

        public long getFetchCounter() {
            return this.fetchCounter;
        }

        public long getTraverseCounter() {
            return this.traverseCounter;
        }

        public long getStoreCounter() {
            return this.storeCounter;
        }

        public long getRemoveCounter() {
            return this.removeCounter;
        }

        public long getCurrentSize() {
            return this.currentPageCount * (long)this.pageSize;
        }

        public long getMaximumPageAddress() {
            return this.maximumPage;
        }

        public long getMaximumSize() {
            return this.maximumPageCount * (long)this.pageSize;
        }

        public long getExtensionSize() {
            return this.extensionPageCount * (long)this.pageSize;
        }

        public boolean isTransient() {
            return this.isTemporary;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            return object instanceof VolumeInfo && ((VolumeInfo)object).getId() == this.id && ((VolumeInfo)object).getName().equals(this.name);
        }

        @Override
        public int compareTo(VolumeInfo volumeInfo) {
            return this.name.compareTo(volumeInfo.name);
        }
    }

    public static class BufferInfo
    extends AcquisitionTimeBase
    implements Serializable {
        public static final long serialVersionUID = -7847730868509629017L;
        int poolIndex;
        int type;
        String typeName;
        int status;
        String statusName;
        String writerThreadName;
        long pageAddress;
        long rightSiblingAddress;
        String volumeName;
        long volumeId;
        long timestamp;
        int bufferSize;
        int availableBytes;
        int alloc;
        int slack;
        int mvvCount;
        int mvvSize;
        int keyBlockStart;
        int keyBlockEnd;

        public BufferInfo() {
        }

        @ConstructorProperties(value={"poolIndex", "type", "typeName", "status", "statusName", "writerThreadName", "pageAddress", "rightSiblingAddress", "volumeName", "volumeId", "timestamp", "bufferSize", "availableBytes", "alloc", "slack", "mvvCount", "mvvSize", "keyBlockStart", "keyBlockEnd"})
        public BufferInfo(int poolIndex, int type, String typeName, int status, String statusName, String writerThreadName, long pageAddress, long rightSiblingAddress, String volumeName, long volumeId, long timestamp, int bufferSize, int availableBytes, int alloc, int slack, int mvvCount, int mvvSize, int keyBlockStart, int keyBlockEnd) {
            this.poolIndex = poolIndex;
            this.type = type;
            this.typeName = typeName;
            this.status = status;
            this.statusName = statusName;
            this.writerThreadName = writerThreadName;
            this.pageAddress = pageAddress;
            this.rightSiblingAddress = rightSiblingAddress;
            this.volumeName = volumeName;
            this.volumeId = volumeId;
            this.timestamp = timestamp;
            this.bufferSize = bufferSize;
            this.availableBytes = availableBytes;
            this.alloc = alloc;
            this.slack = slack;
            this.mvvCount = mvvCount;
            this.mvvSize = mvvSize;
            this.keyBlockStart = keyBlockStart;
            this.keyBlockEnd = keyBlockEnd;
        }

        public boolean isGarbagePage() {
            return this.type == 30;
        }

        public boolean isDataPage() {
            return this.type == 1;
        }

        public boolean isIndexPage() {
            return this.type >= 2 && this.type <= 21;
        }

        public boolean isLongRecordPage() {
            return this.type == 31;
        }

        public boolean isUnallocatedPage() {
            return this.type == 0;
        }

        public int getPoolIndex() {
            return this.poolIndex;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getStatus() {
            return this.status;
        }

        public String getStatusName() {
            return this.statusName;
        }

        public String getWriterThreadName() {
            return this.writerThreadName;
        }

        public long getPageAddress() {
            return this.pageAddress;
        }

        public long getRightSiblingAddress() {
            return this.rightSiblingAddress;
        }

        public String getVolumeName() {
            return this.volumeName;
        }

        public long getVolumeId() {
            return this.volumeId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public int getAvailableBytes() {
            return this.availableBytes;
        }

        public int getAlloc() {
            return this.alloc;
        }

        public int getSlack() {
            return this.slack;
        }

        public int getMvvCount() {
            return this.mvvCount;
        }

        public int getMvvSize() {
            return this.mvvSize;
        }

        public int getKeyBlockStart() {
            return this.keyBlockStart;
        }

        public int getKeyBlockEnd() {
            return this.keyBlockEnd;
        }

        public String displayableSummary() {
            return "page=" + this.pageAddress + " type=" + this.typeName + " rightSibling=" + this.rightSiblingAddress + " status=" + this.statusName + " start=" + this.keyBlockStart + " end=" + this.keyBlockEnd + " size=" + this.bufferSize + " alloc=" + this.alloc + " slack=" + this.slack + " index=" + this.poolIndex + " change count=" + this.timestamp;
        }
    }

    public static class BufferPoolInfo
    extends AcquisitionTimeBase
    implements Serializable {
        public static final long serialVersionUID = 9044282840712593435L;
        int bufferSize;
        int bufferCount;
        long missCount;
        long hitCount;
        long newCount;
        long evictCount;
        long writeCount;
        long forcedWriteCount;
        long forcedCheckpointWriteCount;
        int validPageCount;
        int dirtyPageCount;
        int readerClaimedPageCount;
        int writerClaimedPageCount;
        long earliestDirtyTimestamp;

        public BufferPoolInfo() {
        }

        @ConstructorProperties(value={"bufferSize", "bufferCount", "missCount", "hitCount", "newCount", "evictCount", "writeCount", "forcedWriteCount", "forcedCheckpointWriteCount", "validPageCount", "dirtyPageCount", "readerClaimedPageCount", "writerClaimedPageCount", "earliestDirtyTimestamp"})
        public BufferPoolInfo(int bufferSize, int bufferCount, long missCount, long hitCount, long newCount, long writeCount, long evictCount, long forcedWriteCount, long forcedCheckpointWriteCount, long readCounter, int validPageCount, int dirtyPageCount, int readerClaimedPageCount, int writerClaimedPageCount, long earliestDirtyTimestamp) {
            this.bufferSize = bufferSize;
            this.bufferCount = bufferCount;
            this.missCount = missCount;
            this.hitCount = hitCount;
            this.newCount = newCount;
            this.evictCount = evictCount;
            this.writeCount = writeCount;
            this.forcedWriteCount = forcedWriteCount;
            this.forcedCheckpointWriteCount = forcedCheckpointWriteCount;
            this.validPageCount = validPageCount;
            this.dirtyPageCount = dirtyPageCount;
            this.readerClaimedPageCount = readerClaimedPageCount;
            this.writerClaimedPageCount = writerClaimedPageCount;
            this.earliestDirtyTimestamp = earliestDirtyTimestamp;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public int getBufferCount() {
            return this.bufferCount;
        }

        public long getMissCount() {
            return this.missCount;
        }

        public long getHitCount() {
            return this.hitCount;
        }

        public long getNewCount() {
            return this.newCount;
        }

        public long getEvictCount() {
            return this.evictCount;
        }

        public long getWriteCount() {
            return this.writeCount;
        }

        public long getForcedWriteCount() {
            return this.forcedWriteCount;
        }

        public long getForcedCheckpointWriteCount() {
            return this.forcedCheckpointWriteCount;
        }

        public double getHitRatio() {
            long denominator = this.missCount + this.hitCount + this.newCount;
            if (denominator == 0L) {
                return 0.0;
            }
            return (double)this.hitCount / (double)denominator;
        }

        public int getValidPageCount() {
            return this.validPageCount;
        }

        public int getDirtyPageCount() {
            return this.dirtyPageCount;
        }

        public int getReaderClaimedPageCount() {
            return this.readerClaimedPageCount;
        }

        public int getWriterClaimedPageCount() {
            return this.writerClaimedPageCount;
        }

        public long getEarliestDirtyTimestamp() {
            return this.earliestDirtyTimestamp;
        }
    }

    public static abstract class AcquisitionTimeBase
    implements Serializable {
        private static final long serialVersionUID = 5162380870350766401L;
        long time;

        private AcquisitionTimeBase() {
            this.updateAcquisitonTime();
        }

        public long getAcquisitionTime() {
            return this.time;
        }

        public void setAcquisitionTime(long time) {
            this.time = time;
        }

        void updateAcquisitonTime() {
            this.time = System.currentTimeMillis();
        }
    }

    public static class RecordInfo
    extends AcquisitionTimeBase
    implements Serializable {
        public static final long serialVersionUID = -3236497038293928535L;
        int _kbOffset;
        int _tbOffset;
        int _ebc;
        int _db;
        int _klength;
        int _size;
        boolean _inUse;
        KeyState _key;
        ValueState _value;
        String _error;
        long _pointerValue;
        int _garbageStatus;
        long _garbageLeftPage;
        long _garbageRightPage;

        public int getKbOffset() {
            return this._kbOffset;
        }

        public int getTbOffset() {
            return this._tbOffset;
        }

        public int getEbc() {
            return this._ebc;
        }

        public int getDb() {
            return this._db;
        }

        public int getKLength() {
            return this._klength;
        }

        public int getSize() {
            return this._size;
        }

        public boolean isInUse() {
            return this._inUse;
        }

        public KeyState getKeyState() {
            return this._key;
        }

        public ValueState getValueState() {
            return this._value;
        }

        public long getPointerValue() {
            return this._pointerValue;
        }

        public int getGarbageStatus() {
            return this._garbageStatus;
        }

        public long getGarbageLeftPage() {
            return this._garbageLeftPage;
        }

        public long getGarbageRightPage() {
            return this._garbageRightPage;
        }

        public String getError() {
            return this._error;
        }
    }

    public static class LogicalRecordCount
    extends AcquisitionTimeBase
    implements Serializable {
        public static final long serialVersionUID = 6028974382268205702L;
        KeyState _keyState;
        int _count;

        LogicalRecordCount(KeyState keyState, int count) {
            this._keyState = keyState;
            this._count = count;
        }

        public KeyState getKeyState() {
            return this._keyState;
        }

        public int getCount() {
            return this._count;
        }
    }

    public static class LogicalRecord
    extends AcquisitionTimeBase
    implements Serializable {
        public static final long serialVersionUID = -2767943138077168919L;
        KeyState _key;
        ValueState _value;
        String _keyString;
        String _valueString;

        public KeyState getKeyState() {
            return this._key;
        }

        public ValueState getValueState() {
            return this._value;
        }

        public String getKeyString() {
            return this._keyString;
        }

        public String getValueString() {
            return this._valueString;
        }
    }

    public static interface DisplayFilter {
        public String toKeyDisplayString(Exchange var1);

        public String toValueDisplayString(Exchange var1);
    }
}

