/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.Buffer;
import com.persistit.CheckpointManager;
import com.persistit.Exchange;
import com.persistit.JournalManager;
import com.persistit.JournalRecord;
import com.persistit.Key;
import com.persistit.Management;
import com.persistit.MediatedFileChannel;
import com.persistit.Persistit;
import com.persistit.TransactionPlayer;
import com.persistit.TransactionPlayerSupport;
import com.persistit.TransactionStatus;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.VolumeHandleLookup;
import com.persistit.VolumeSpecification;
import com.persistit.exception.CorruptJournalException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitIOException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.TestException;
import com.persistit.mxbeans.RecoveryManagerMXBean;
import com.persistit.util.ArgParser;
import com.persistit.util.SequencerConstants;
import com.persistit.util.ThreadSequencer;
import com.persistit.util.Util;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class RecoveryManager
implements RecoveryManagerMXBean,
VolumeHandleLookup {
    static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private static final int APPLY_TRANSACTION_LOG_COUNT = 10000;
    private final Persistit _persistit;
    private final Map<Long, JournalManager.TransactionMapItem> _recoveredTransactionMap = new HashMap<Long, JournalManager.TransactionMapItem>();
    private final Map<Long, JournalManager.TransactionMapItem> _abortedTransactionMap = new HashMap<Long, JournalManager.TransactionMapItem>();
    private final Map<JournalManager.PageNode, JournalManager.PageNode> _pageMap = new HashMap<JournalManager.PageNode, JournalManager.PageNode>();
    private final Map<JournalManager.PageNode, JournalManager.PageNode> _branchMap = new HashMap<JournalManager.PageNode, JournalManager.PageNode>();
    private final Map<Volume, Integer> _volumeToHandleMap = new HashMap<Volume, Integer>();
    private final Map<Integer, Volume> _handleToVolumeMap = new HashMap<Integer, Volume>();
    private final Map<JournalManager.TreeDescriptor, Integer> _treeToHandleMap = new HashMap<JournalManager.TreeDescriptor, Integer>();
    private final Map<Integer, JournalManager.TreeDescriptor> _handleToTreeMap = new HashMap<Integer, JournalManager.TreeDescriptor>();
    private CheckpointManager.Checkpoint _lastValidCheckpoint = new CheckpointManager.Checkpoint(0L, 0L);
    private long _lastValidCheckpointJournalAddress;
    private final Map<Long, FileChannel> _journalFileChannels = new HashMap<Long, FileChannel>();
    private volatile int _committedTransactionCount;
    private volatile int _uncommittedTransactionCount;
    private volatile int _appliedTransactionCount;
    private volatile int _abortedTransactionCount;
    private volatile int _errorCount;
    private volatile boolean _recoveryDisabledForTestMode;
    private String _journalFilePath;
    private File _keystoneFile;
    private long _journalCreatedTime;
    private long _blockSize;
    private long _baseAddress = 0L;
    private long _keystoneAddress;
    private ByteBuffer _readBuffer;
    private final int _readBufferSize = 0x100000;
    private long _readBufferAddress;
    private long _currentAddress;
    private final long _recoveryStatus = Long.MIN_VALUE;
    private long _recoveryEndedAddress;
    private String _recoveryEndedException;
    private TransactionPlayer.TransactionPlayerListener _defaultCommitListener = new DefaultRecoveryListener();
    private TransactionPlayer.TransactionPlayerListener _defaultRollbackListener = new DefaultRollbackListener();
    private final TransactionPlayer _player = new TransactionPlayer(new RecoveryTransactionPlayerSupport());

    static File[] files(String pathName) {
        String pathString;
        File path = new File(pathName);
        File directory = !path.isDirectory() ? (path.getParentFile() == null ? new File(".") : path.getParentFile()) : path;
        Object[] files = directory.listFiles(new FileFilter(pathString = path.getPath()){
            final /* synthetic */ String val$pathString;
            {
                this.val$pathString = string;
            }

            @Override
            public boolean accept(File candidate) {
                String candidateString = candidate.getPath();
                return candidateString.startsWith(this.val$pathString) && JournalManager.PATH_PATTERN.matcher(candidateString).matches();
            }
        });
        if (files == null) {
            return new File[0];
        }
        Arrays.sort(files);
        return files;
    }

    static void validate(long value, File file, long address, long expected, String message) throws CorruptJournalException {
        if (value == expected) {
            return;
        }
        throw new CorruptJournalException(String.format(message, file, address, value, expected));
    }

    static void validate(long value, File file, long address, long min, long max, String message) throws CorruptJournalException {
        if (value >= min && value <= max) {
            return;
        }
        throw new CorruptJournalException(String.format(message, file, address, value, min, max));
    }

    RecoveryManager(Persistit persistit) {
        this._persistit = persistit;
    }

    synchronized void populateRecoveryInfo(Management.RecoveryInfo info) {
        info.keystoneJournalAddress = this._keystoneAddress;
        info.currentAddress = this._currentAddress;
        info.recoveryStatus = Long.MIN_VALUE;
        info.recoveryEndAddress = this._recoveryEndedAddress;
        String string = info.recoveryException = this._recoveryEndedException == null ? "" : this._recoveryEndedException;
        if (this._keystoneAddress > 0L) {
            info.keystoneJournalFile = this.addressToFile(this._keystoneAddress).getPath();
            if (this._lastValidCheckpointJournalAddress != 0L) {
                info.lastValidCheckpointSystemTime = this._lastValidCheckpoint.getSystemTimeMillis();
            }
            info.lastValidCheckpointTimestamp = this._lastValidCheckpoint.getTimestamp();
            info.lastValidCheckpointJournalFile = this.addressToFile(this._lastValidCheckpointJournalAddress).getPath();
            info.lastValidCheckpointJournalAddress = this._lastValidCheckpointJournalAddress;
        } else {
            info.lastValidCheckpointSystemTime = 0L;
            info.lastValidCheckpointTimestamp = 0L;
            info.lastValidCheckpointJournalFile = null;
            info.lastValidCheckpointJournalAddress = 0L;
        }
        info.blockSize = this._blockSize;
        info.pageMapSize = this._pageMap.size();
        info.baseAddress = this._baseAddress;
        info.appliedTransactions = this._appliedTransactionCount;
        info.committedTransactions = this.getCommittedCount();
        info.uncommittedTransactions = this.getUncommittedCount();
    }

    public void init(String path) throws PersistitException {
        this._journalFilePath = JournalManager.journalPath(path).getAbsolutePath();
        this._readBuffer = ByteBuffer.allocate(0x100000);
    }

    @Override
    public String getJournalFilePath() {
        return this._journalFilePath;
    }

    @Override
    public int getCommittedCount() {
        int count = 0;
        for (JournalManager.TransactionMapItem trecord : this._recoveredTransactionMap.values()) {
            if (!trecord.isCommitted()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getUncommittedCount() {
        int count = 0;
        for (JournalManager.TransactionMapItem trecord : this._recoveredTransactionMap.values()) {
            if (trecord.isCommitted()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getAppliedTransactionCount() {
        return this._appliedTransactionCount;
    }

    @Override
    public int getErrorCount() {
        return this._errorCount;
    }

    public CheckpointManager.Checkpoint getLastValidCheckpoint() {
        return this._lastValidCheckpoint;
    }

    @Override
    public long getLastValidCheckpointTimestamp() {
        return this._lastValidCheckpoint.getTimestamp();
    }

    @Override
    public long getLastValidCheckpointAddress() {
        return this._lastValidCheckpointJournalAddress;
    }

    @Override
    public String getRecoveryEndedException() {
        return this._recoveryEndedException;
    }

    @Override
    public long getRecoveryEndedAddress() {
        return this._recoveryEndedAddress;
    }

    @Override
    public long getKeystoneAddress() {
        return this._keystoneAddress;
    }

    @Override
    public long getBaseAddress() {
        return this._baseAddress;
    }

    @Override
    public long getBlockSize() {
        return this._blockSize;
    }

    @Override
    public long getJournalCreatedTime() {
        return this._journalCreatedTime;
    }

    @Override
    public int getTransactionMapSize() {
        return this._recoveredTransactionMap.size();
    }

    @Override
    public int getPageMapSize() {
        return this._pageMap.size();
    }

    public TransactionPlayer.TransactionPlayerListener getDefaultCommitListener() {
        return this._defaultCommitListener;
    }

    public void setDefaultCommitListener(TransactionPlayer.TransactionPlayerListener listener) {
        this._defaultCommitListener = listener;
    }

    public TransactionPlayer.TransactionPlayerListener getDefaultRollbackListener() {
        return this._defaultRollbackListener;
    }

    public void setDefaultRollbackListener(TransactionPlayer.TransactionPlayerListener listener) {
        this._defaultRollbackListener = listener;
    }

    @Override
    public synchronized Volume lookupVolumeHandle(int handle) {
        return this._handleToVolumeMap.get(handle);
    }

    File addressToFile(long address) {
        return JournalManager.generationToFile(this._journalFilePath, address / this._blockSize);
    }

    void collectRecoveredPages(Map<JournalManager.PageNode, JournalManager.PageNode> pageMap, Map<JournalManager.PageNode, JournalManager.PageNode> branchMap) {
        if (this._lastValidCheckpoint != null) {
            long lastValidTimestamp = this._lastValidCheckpoint.getTimestamp();
            block0: for (JournalManager.PageNode lastPageNode : this._pageMap.values()) {
                boolean branched = false;
                JournalManager.PageNode previous = null;
                for (JournalManager.PageNode pageNode = lastPageNode; pageNode != null; pageNode = pageNode.getPrevious()) {
                    if (pageNode.getTimestamp() <= lastValidTimestamp && pageNode.getJournalAddress() >= this._baseAddress) {
                        pageNode.setPrevious(null);
                        if (branched) {
                            previous.setPrevious(null);
                        }
                        pageMap.put(pageNode, pageNode);
                        continue block0;
                    }
                    if (!branched) {
                        branchMap.put(pageNode, pageNode);
                        branched = true;
                    }
                    previous = pageNode;
                }
            }
        }
    }

    void collectRecoveredVolumeMaps(Map<Integer, Volume> handleToVolumeMap, Map<Volume, Integer> volumeToHandleMap) {
        for (Map.Entry<Integer, Volume> entry : this._handleToVolumeMap.entrySet()) {
            Volume volume = entry.getValue();
            if (volume.isTemporary()) continue;
            volumeToHandleMap.put(volume, entry.getKey());
            handleToVolumeMap.put(entry.getKey(), volume);
        }
    }

    void collectRecoveredTreeMaps(Map<Integer, JournalManager.TreeDescriptor> handleToTreeMap, Map<JournalManager.TreeDescriptor, Integer> treeToHandleMap) {
        treeToHandleMap.putAll(this._treeToHandleMap);
        handleToTreeMap.putAll(this._handleToTreeMap);
    }

    void collectRecoveredTransactionMap(Map<Long, JournalManager.TransactionMapItem> map) {
        map.putAll(this._recoveredTransactionMap);
    }

    void close() {
        if (this._recoveryDisabledForTestMode) {
            return;
        }
        for (FileChannel channel : this._journalFileChannels.values()) {
            if (channel == null) continue;
            try {
                channel.close();
            }
            catch (IOException iOException) {}
        }
        this._recoveredTransactionMap.clear();
        this._pageMap.clear();
        this._volumeToHandleMap.clear();
        this._handleToVolumeMap.clear();
        this._treeToHandleMap.clear();
        this._handleToTreeMap.clear();
        this._readBuffer = null;
        this._journalFileChannels.clear();
    }

    boolean isRecoveryDisabledForTestMode() {
        return this._recoveryDisabledForTestMode;
    }

    void setRecoveryDisabledForTestMode(boolean recoveryDisabledForTestMode) {
        this._recoveryDisabledForTestMode = recoveryDisabledForTestMode;
    }

    synchronized FileChannel getFileChannel(long address) throws PersistitIOException {
        long generation = address / this._blockSize;
        FileChannel channel = this._journalFileChannels.get(generation);
        if (channel == null) {
            try {
                channel = new MediatedFileChannel(this.addressToFile(address), "r");
                this._journalFileChannels.put(generation, channel);
            }
            catch (IOException ioe) {
                throw new PersistitIOException(ioe);
            }
        }
        return channel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TreeSet<JournalManager.TransactionMapItem> sorted = new TreeSet<JournalManager.TransactionMapItem>(this._recoveredTransactionMap.values());
        for (JournalManager.TransactionMapItem ts : sorted) {
            sb.append(ts);
            sb.append(Util.NEW_LINE);
        }
        return sb.toString();
    }

    String addressToString(long address) {
        return TransactionPlayer.addressToString(address);
    }

    private String addressToString(long address, long timestamp) {
        return TransactionPlayer.addressToString(address, timestamp);
    }

    TransactionPlayer getPlayer() {
        return this._player;
    }

    private void findAndValidateKeystone() throws PersistitIOException {
        this._keystoneAddress = -1L;
        File[] files = RecoveryManager.files(this._journalFilePath);
        if (files.length == 0) {
            return;
        }
        File rejectedPrimordialFile = null;
        CorruptJournalException savedException = null;
        int fileIndex = files.length;
        while (--fileIndex >= 0) {
            File candidate;
            this._keystoneFile = candidate = files[fileIndex];
            long generation = JournalManager.fileToGeneration(candidate);
            try {
                boolean checkpointFound;
                block11: {
                    RandomAccessFile raf = new RandomAccessFile(candidate, "r");
                    FileChannel readChannel = raf.getChannel();
                    long size = Math.min(readChannel.size(), 0x100000L);
                    if (size < 64L) {
                        throw new CorruptJournalException(String.format("Invalid Persistit journal file %s - no journal header", candidate));
                    }
                    this._readBufferAddress = 0L;
                    this._readBuffer.limit(2112);
                    readChannel.read(this._readBuffer, 0L);
                    this._readBuffer.flip();
                    int recordSize = JournalRecord.JH.getLength(this._readBuffer);
                    long version = JournalRecord.JH.getVersion(this._readBuffer);
                    this._blockSize = JournalRecord.JH.getBlockSize(this._readBuffer);
                    this._baseAddress = JournalRecord.JH.getBaseJournalAddress(this._readBuffer);
                    this._journalCreatedTime = JournalRecord.JH.getJournalCreatedTime(this._readBuffer);
                    this._keystoneAddress = JournalRecord.JH.getCurrentJournalAddress(this._readBuffer);
                    this._currentAddress = this._keystoneAddress + (long)recordSize;
                    RecoveryManager.validate(version, candidate, 0L, 2L, "Unsupported Version %3$d at %1$s:%2$d");
                    RecoveryManager.validate(this._blockSize, candidate, 0L, 10000000L, 100000000000L, "Journal file size %3$,d not in valid range [%4$,d:%5$,d] at %1$s:%2$,d");
                    RecoveryManager.validate(this._keystoneAddress, candidate, 0L, generation * this._blockSize, "Invalid current address %3$,d at %1$s:%2$,d");
                    RecoveryManager.validate(this._baseAddress, candidate, 0L, 0L, this._keystoneAddress, "Base address %3$,d after current address %4$,d:  at %1$s:%2$,d");
                    readChannel.close();
                    checkpointFound = false;
                    try {
                        while (true) {
                            int type;
                            if ((type = this.scanOneRecord()) == 17232) {
                                checkpointFound = true;
                                continue;
                            }
                            if (type == 19013) break;
                        }
                    }
                    catch (CorruptJournalException cje) {
                        this._recoveryEndedException = cje.toString();
                        this._recoveryEndedAddress = this._currentAddress;
                        if (checkpointFound) break block11;
                        throw cje;
                    }
                }
                if (!checkpointFound) continue;
                this._persistit.getLogBase().recoveryKeystone.log(this.addressToFile(this._keystoneAddress), this._currentAddress);
                this._recoveryEndedAddress = this._currentAddress;
                break;
            }
            catch (CorruptJournalException je) {
                if (rejectedPrimordialFile == null) {
                    rejectedPrimordialFile = candidate;
                    savedException = je;
                    this._keystoneAddress = -1L;
                    this._keystoneFile = null;
                    this._recoveredTransactionMap.clear();
                    this._pageMap.clear();
                    this._branchMap.clear();
                    this._treeToHandleMap.clear();
                    this._volumeToHandleMap.clear();
                    this._handleToTreeMap.clear();
                    this._handleToVolumeMap.clear();
                    continue;
                }
                throw savedException;
            }
            catch (IOException ioe) {
                throw new PersistitIOException(ioe);
            }
        }
    }

    private long addressUp(long address) {
        return (address / this._blockSize + 1L) * this._blockSize;
    }

    private boolean isZombieTransaction(long address) {
        return address < this._baseAddress;
    }

    private void read(long address, int size) throws PersistitIOException {
        if (this._readBufferAddress >= 0L && address >= this._readBufferAddress && (long)size + address - this._readBufferAddress <= (long)this._readBuffer.limit()) {
            this._readBuffer.position((int)(address - this._readBufferAddress));
        } else {
            try {
                int readSize;
                FileChannel fc = this.getFileChannel(address);
                this._readBuffer.clear();
                int maxSize = this._readBuffer.capacity();
                long remainingInBlock = this.addressUp(address) - address;
                if (remainingInBlock < (long)maxSize) {
                    maxSize = (int)remainingInBlock;
                }
                this._readBuffer.limit(maxSize);
                int offset = 0;
                while (this._readBuffer.remaining() > 0 && (readSize = fc.read(this._readBuffer, (long)offset + address % this._blockSize)) >= 0) {
                    offset += readSize;
                }
                this._readBufferAddress = address;
                this._readBuffer.flip();
                if (this._readBuffer.remaining() < size) {
                    throw new CorruptJournalException("End of file at " + this.addressToString(address));
                }
            }
            catch (IOException e) {
                throw new PersistitIOException("Reading from " + this.addressToString(address), e);
            }
        }
    }

    private int scanOneRecord() throws PersistitIOException {
        long from = this._currentAddress;
        this.read(this._currentAddress, 16);
        int recordSize = JournalRecord.getLength(this._readBuffer);
        int type = JournalRecord.getType(this._readBuffer);
        long timestamp = JournalRecord.getTimestamp(this._readBuffer);
        this._persistit.getTimestampAllocator().updateTimestamp(timestamp);
        if ((long)recordSize >= this._blockSize || recordSize < 16) {
            throw new CorruptJournalException("Bad JournalRecord length " + recordSize + " at position " + this.addressToString(from, timestamp));
        }
        switch (type) {
            case 19013: {
                this.scanJournalEnd(from, timestamp, recordSize);
                break;
            }
            case 19016: {
                break;
            }
            case 17456: 
            case 17457: 
            case 17490: 
            case 17492: 
            case 21330: {
                throw new CorruptJournalException("Unexpected record of type " + type + " at " + this.addressToString(from));
            }
            case 18774: {
                this.scanIdentifyVolume(from, timestamp, recordSize);
                break;
            }
            case 18772: {
                this.scanIdentifyTree(from, timestamp, recordSize);
                break;
            }
            case 20545: {
                this.scanLoadPage(from, timestamp, recordSize);
                break;
            }
            case 20557: {
                this.scanLoadPageMap(from, timestamp, recordSize);
                break;
            }
            case 21581: {
                this.scanLoadTransactionMap(from, timestamp, recordSize);
                break;
            }
            case 21592: {
                this.scanOneTransaction(from, timestamp, recordSize);
                break;
            }
            case 17232: {
                this.scanCheckpoint(from, timestamp, recordSize);
                break;
            }
            default: {
                if (JournalRecord.isValidType(type)) break;
                this._currentAddress -= 16L;
                throw new CorruptJournalException("Invalid record type " + type + " at " + this.addressToString(from));
            }
        }
        this._currentAddress = from + (long)recordSize;
        return type;
    }

    void scanIdentifyVolume(long address, long timestamp, int recordSize) throws PersistitIOException {
        if (recordSize > 2076) {
            throw new CorruptJournalException("IV JournalRecord too long: " + recordSize + " bytes at position " + this.addressToString(address, timestamp));
        }
        this.read(address, recordSize);
        Integer handle = JournalRecord.IV.getHandle(this._readBuffer);
        long id = JournalRecord.IV.getVolumeId(this._readBuffer);
        String specification = JournalRecord.IV.getVolumeSpecification(this._readBuffer);
        VolumeSpecification vs = new VolumeSpecification(specification);
        vs.setCreate(false);
        vs.setCreateOnly(false);
        Volume volume = new Volume(vs);
        volume.setId(id);
        this._handleToVolumeMap.put(handle, volume);
        this._volumeToHandleMap.put(volume, handle);
        this._persistit.getLogBase().recoveryRecord.log("IV", this.addressToString(address, timestamp), vs.getName(), timestamp);
    }

    void scanIdentifyTree(long address, long timestamp, int recordSize) throws PersistitIOException {
        if (recordSize > 1048) {
            throw new CorruptJournalException("IT JournalRecord too long: " + recordSize + " bytes at position " + this.addressToString(address, timestamp));
        }
        if (this._readBuffer.remaining() < recordSize) {
            this.read(address, recordSize);
        }
        Integer handle = JournalRecord.IT.getHandle(this._readBuffer);
        String treeName = JournalRecord.IT.getTreeName(this._readBuffer);
        Integer volumeHandle = JournalRecord.IT.getVolumeHandle(this._readBuffer);
        Volume volume = this._handleToVolumeMap.get(volumeHandle);
        if (volumeHandle == Integer.MAX_VALUE) {
            return;
        }
        if (volume == null) {
            throw new CorruptJournalException("IT JournalRecord refers to unidentified volume handle " + volumeHandle + " at position " + this.addressToString(address, timestamp));
        }
        if (!volume.isTemporary()) {
            JournalManager.TreeDescriptor td = new JournalManager.TreeDescriptor(volumeHandle, treeName);
            this._handleToTreeMap.put(handle, td);
            this._treeToHandleMap.put(td, handle);
            this._persistit.getLogBase().recoveryRecord.log("IT", this.addressToString(address, timestamp), treeName, timestamp);
        }
    }

    void scanLoadPage(long address, long timestamp, int recordSize) throws PersistitIOException {
        if (recordSize > 16420) {
            throw new CorruptJournalException("PA JournalRecord too long: " + recordSize + " bytes at position " + this.addressToString(address, timestamp));
        }
        if (timestamp > 0L) {
            this.read(address, recordSize);
            int volumeHandle = JournalRecord.PA.getVolumeHandle(this._readBuffer);
            long pageAddress = JournalRecord.PA.getPageAddress(this._readBuffer);
            Volume volume = this._handleToVolumeMap.get(volumeHandle);
            if (volume == null) {
                throw new CorruptJournalException("PA reference to volume " + volumeHandle + " is not preceded by an IV record for that handle at " + this.addressToString(address, timestamp));
            }
            JournalManager.PageNode pageNode = new JournalManager.PageNode(volumeHandle, pageAddress, address, timestamp);
            JournalManager.PageNode oldPageNode = this._pageMap.get(pageNode);
            pageNode.setPrevious(oldPageNode);
            this._pageMap.put(pageNode, pageNode);
            this._persistit.getLogBase().recoveryRecord.log("PA", pageNode.toStringJournalAddress(this), pageNode.toStringPageAddress(this), timestamp);
        }
    }

    void scanLoadPageMap(long from, long timestamp, int recordSize) throws PersistitIOException {
        this.read(from, 16);
        int count = JournalRecord.PM.getEntryCount(this._readBuffer);
        if (count * 28 + 16 != recordSize) {
            throw new CorruptJournalException("Invalid record size " + recordSize + " for PM record at " + this.addressToString(from, timestamp));
        }
        long address = from + 16L;
        int index = 0;
        int loaded = 0;
        for (int remaining = count; remaining > 0; --remaining) {
            JournalManager.PageNode lastPageNode;
            int volumeHandle;
            Volume volume;
            if (index == loaded) {
                int loadedSize = Math.min(this._readBuffer.capacity() / 28, remaining) * 28;
                this.read(address, loadedSize);
                address += (long)loadedSize;
                index = 0;
                loaded = loadedSize / 28;
                if (loaded <= 0) {
                    throw new CorruptJournalException("Could not load PageMap segment in entry " + (count - remaining + 1) + " at " + this.addressToString(from, timestamp));
                }
            }
            if ((volume = this._handleToVolumeMap.get(volumeHandle = JournalRecord.PM.getEntryVolumeHandle(this._readBuffer, index))) == null) {
                throw new CorruptJournalException("Page map refers to undefined volume handle " + volumeHandle + " in entry " + (count - remaining + 1) + " at " + this.addressToString(from, timestamp));
            }
            long pageAddress = JournalRecord.PM.getEntryPageAddress(this._readBuffer, index);
            long pageTimestamp = JournalRecord.PM.getEntryTimestamp(this._readBuffer, index);
            long journalAddress = JournalRecord.PM.getEntryJournalAddress(this._readBuffer, index);
            JournalManager.PageNode pageNode = new JournalManager.PageNode(volumeHandle, pageAddress, journalAddress, pageTimestamp);
            boolean linked = false;
            if (timestamp != 0L && timestamp < pageTimestamp) {
                lastPageNode = this._branchMap.get(pageNode);
                if (lastPageNode == null || journalAddress > lastPageNode.getJournalAddress()) {
                    pageNode.setPrevious(lastPageNode);
                    this._branchMap.put(pageNode, pageNode);
                    linked = true;
                }
            } else {
                lastPageNode = this._pageMap.get(pageNode);
                if (lastPageNode == null || journalAddress > lastPageNode.getJournalAddress()) {
                    pageNode.setPrevious(lastPageNode);
                    this._pageMap.put(pageNode, pageNode);
                    linked = true;
                }
            }
            if (!linked) {
                for (JournalManager.PageNode pn = lastPageNode; pn != null && journalAddress != pn.getJournalAddress(); pn = pn.getPrevious()) {
                    if (pn.getPrevious() != null && journalAddress <= pn.getPrevious().getJournalAddress()) continue;
                    pageNode.setPrevious(pn.getPrevious());
                    pn.setPrevious(pageNode);
                    break;
                }
            }
            ++index;
        }
    }

    void scanLoadTransactionMap(long from, long timestamp, int recordSize) throws PersistitIOException {
        this.read(from, 16);
        int count = JournalRecord.TM.getEntryCount(this._readBuffer);
        if (count * 32 + 16 != recordSize) {
            throw new CorruptJournalException("Invalid record size " + recordSize + " for TM record at " + this.addressToString(from, timestamp));
        }
        long address = from + 16L;
        int index = 0;
        int loaded = 0;
        for (int remaining = count; remaining > 0; --remaining) {
            if (index == loaded) {
                int loadedSize = Math.min(this._readBuffer.capacity() / 32, remaining) * 32;
                this.read(address, loadedSize);
                address += (long)loadedSize;
                index = 0;
                loaded = loadedSize / 32;
                if (loaded <= 0) {
                    throw new CorruptJournalException("Could not load TramsactionMap segment in entry " + (count - remaining + 1) + " at " + this.addressToString(from, timestamp));
                }
            }
            long startTimestamp = JournalRecord.TM.getEntryStartTimestamp(this._readBuffer, index);
            long commitTimestamp = JournalRecord.TM.getEntryCommitTimestamp(this._readBuffer, index);
            long journalAddress = JournalRecord.TM.getEntryJournalAddress(this._readBuffer, index);
            long lastRecordAddress = JournalRecord.TM.getLastRecordAddress(this._readBuffer, index);
            if (!this.isZombieTransaction(journalAddress)) {
                JournalManager.TransactionMapItem ts = new JournalManager.TransactionMapItem(startTimestamp, journalAddress);
                Long key = startTimestamp;
                ts.setCommitTimestamp(commitTimestamp);
                ts.setLastRecordAddress(lastRecordAddress);
                if (this._recoveredTransactionMap.put(key, ts) != null) {
                    throw new CorruptJournalException("Redundant record in TransactionMap record " + ts + " entry " + (count - remaining + 1) + " at " + this.addressToString(address, startTimestamp));
                }
                this._persistit.getTimestampAllocator().updateTimestamp(commitTimestamp);
            }
            ++index;
        }
    }

    void scanJournalEnd(long address, long timestamp, int recordSize) throws PersistitIOException {
        if (recordSize != 40) {
            throw new CorruptJournalException("JE JournalRecord has incorrect length: " + recordSize + " bytes at position " + this.addressToString(address, timestamp));
        }
        this.read(address, 40);
        long currentAddress = JournalRecord.JE.getCurrentJournalAddress(this._readBuffer);
        long baseAddress = JournalRecord.JE.getBaseAddress(this._readBuffer);
        long journalCreated = JournalRecord.JE.getJournalCreatedTime(this._readBuffer);
        RecoveryManager.validate(journalCreated, this._keystoneFile, address, this._journalCreatedTime, "JE wrong record journalCreatedTime  %3$,d: expected %4$,d at %1$s:%2$,d");
        RecoveryManager.validate(currentAddress, this._keystoneFile, address, address, "JE record currentAddress %3$,d mismatch at %1$s:%2$,d");
        RecoveryManager.validate(baseAddress, this._keystoneFile, address, this._baseAddress, "JE record wrong base address %3$,d: expected %4$,d at %1$s:%2$,d");
    }

    void scanCheckpoint(long address, long timestamp, int recordSize) throws PersistitIOException {
        if (recordSize != 32) {
            throw new CorruptJournalException("CP JournalRecord has incorrect length: " + recordSize + " bytes at position " + this.addressToString(address, timestamp));
        }
        this.read(address, 32);
        long systemTimeMillis = JournalRecord.CP.getSystemTimeMillis(this._readBuffer);
        CheckpointManager.Checkpoint checkpoint = new CheckpointManager.Checkpoint(timestamp, systemTimeMillis, true);
        long baseAddress = JournalRecord.CP.getBaseAddress(this._readBuffer);
        if (baseAddress < this._baseAddress || baseAddress > this._currentAddress) {
            throw new CorruptJournalException("Invalid base journal address " + baseAddress + " for CP record at " + this.addressToString(address, timestamp));
        }
        this._baseAddress = baseAddress;
        this._lastValidCheckpoint = checkpoint;
        this._lastValidCheckpointJournalAddress = address;
        Iterator<Map.Entry<Long, JournalManager.TransactionMapItem>> iterator = this._recoveredTransactionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, JournalManager.TransactionMapItem> entry = iterator.next();
            JournalManager.TransactionMapItem ts = entry.getValue();
            if (ts.isCommitted() && ts.getCommitTimestamp() < timestamp) {
                iterator.remove();
                continue;
            }
            if (this._abortedTransactionMap.get(ts.getStartTimestamp()) != null) {
                iterator.remove();
                this._abortedTransactionMap.remove(ts.getStartTimestamp());
                continue;
            }
            if (!this.isZombieTransaction(ts.getStartAddress())) continue;
            iterator.remove();
        }
        this._persistit.getLogBase().checkpointRecovered.log(checkpoint, this.addressToString(address, checkpoint.getTimestamp()));
        this._persistit.getLogBase().recoveryRecord.log("CP", this.addressToString(address, timestamp), checkpoint + " pageMap.size()=" + this._pageMap.size(), timestamp);
    }

    private void validateMemberFile(long generation) throws PersistitIOException {
        File file = JournalManager.generationToFile(this._journalFilePath, generation);
        if (!file.exists()) {
            throw new CorruptJournalException("Missing journal file " + file);
        }
        this.read(generation * this._blockSize, 64);
        int recordSize = JournalRecord.getLength(this._readBuffer);
        RecoveryManager.validate(recordSize, file, 0L, 64L, 2112L, "Journal header record size %3$,d is not in valid range [%4$,d:%5$,d] at %1$s:%2$,d");
        int type = JournalRecord.getType(this._readBuffer);
        RecoveryManager.validate(type, file, 0L, 19016L, "Invalid record type %$3,d at  at %1$s:%2$d");
        long version = JournalRecord.JH.getVersion(this._readBuffer);
        long currentAddress = JournalRecord.JH.getCurrentJournalAddress(this._readBuffer);
        long blockSize = JournalRecord.JH.getBlockSize(this._readBuffer);
        long baseAddress = JournalRecord.JH.getBaseJournalAddress(this._readBuffer);
        long journalCreatedTime = JournalRecord.JH.getJournalCreatedTime(this._readBuffer);
        RecoveryManager.validate(version, file, 0L, 2L, "Unsupported Version %3$d at %1$s:%2$d");
        RecoveryManager.validate(blockSize, file, 0L, this._blockSize, "Journal file size %3$,d differs from keystone value %4$,d at %1$s:%2$,d");
        RecoveryManager.validate(journalCreatedTime, file, 0L, this._journalCreatedTime, "Journal creation time %3$,d differs from keystone value %4$,d at %1$s:%2$,d");
        RecoveryManager.validate(baseAddress, file, 0L, 0L, this._baseAddress, "Journal base address %3$,d not in valid range [%4$,d:%5$,d] at %1$s:%2$,d");
        RecoveryManager.validate(currentAddress, file, 0L, 0L, this._keystoneAddress, "Journal base address %3$,d not in valid range [%4$,d:%5$,d] at %1$s:%2$,d");
        this._persistit.getLogBase().recoveryValidFile.log(file.getPath());
        long startingAddress = generation * this._blockSize;
        long endingAddress = startingAddress + blockSize;
        long lastRequiredJournalAddress = startingAddress;
        JournalManager.PageNode lastRequiredPageNode = null;
        Iterator<JournalManager.PageNode> i$ = this._pageMap.values().iterator();
        while (i$.hasNext()) {
            JournalManager.PageNode pageNode;
            for (JournalManager.PageNode pn = pageNode = i$.next(); pn != null && pn.getJournalAddress() >= lastRequiredJournalAddress; pn = pn.getPrevious()) {
                if (pn.getJournalAddress() >= endingAddress) continue;
                lastRequiredJournalAddress = pn.getJournalAddress();
                lastRequiredPageNode = pn;
            }
        }
        if (lastRequiredJournalAddress > startingAddress) {
            this.read(lastRequiredJournalAddress, 36);
            type = JournalRecord.getType(this._readBuffer);
            RecoveryManager.validate(type, file, startingAddress, 20545L, "Invalid record type %3$,d at %1$s:%2$d");
            recordSize = JournalRecord.getLength(this._readBuffer);
            RecoveryManager.validate(recordSize, file, startingAddress, 68L, 16420L, "PA record size %3$,d not in valid range [%4$,d:%5$,d] at %1$s:%2$,d");
            long pageAddress = JournalRecord.PA.getPageAddress(this._readBuffer);
            RecoveryManager.validate(pageAddress, file, startingAddress, lastRequiredPageNode.getPageAddress(), "Mismatched page address %3$d at %1$s:%2$d");
            this.read(lastRequiredJournalAddress, recordSize);
        }
    }

    public void buildRecoveryPlan() throws PersistitIOException, PersistitInterruptedException {
        try {
            this.findAndValidateKeystone();
            if (this._keystoneAddress == -1L) {
                return;
            }
            long fromGeneration = this._baseAddress / this._blockSize;
            long toGeneration = this._keystoneAddress / this._blockSize;
            for (long generation = fromGeneration; generation < toGeneration; ++generation) {
                this.validateMemberFile(generation);
            }
            Iterator<JournalManager.TransactionMapItem> iterator = this._recoveredTransactionMap.values().iterator();
            while (iterator.hasNext()) {
                JournalManager.TransactionMapItem item = iterator.next();
                if (item.isCommitted()) {
                    ++this._committedTransactionCount;
                    continue;
                }
                if (item.getStartTimestamp() < this._lastValidCheckpoint.getTimestamp()) {
                    ++this._uncommittedTransactionCount;
                    try {
                        this._persistit.getTransactionIndex().injectAbortedTransaction(item.getStartTimestamp());
                        continue;
                    }
                    catch (InterruptedException ie) {
                        throw new PersistitInterruptedException(ie);
                    }
                }
                iterator.remove();
            }
            this._persistit.getLogBase().recoveryPlan.log(this._pageMap.size(), this._committedTransactionCount, this._uncommittedTransactionCount);
        }
        catch (PersistitIOException pe) {
            this._persistit.getLogBase().recoveryFailure.log(pe);
            throw pe;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void scanOneTransaction(long address, long startTimestamp, int recordSize) throws PersistitIOException {
        this.read(address, recordSize);
        Long key = startTimestamp;
        long commitTimestamp = JournalRecord.TX.getCommitTimestamp(this._readBuffer);
        long backchainAddress = JournalRecord.TX.getBackchainAddress(this._readBuffer);
        if (this.isZombieTransaction(address)) {
            return;
        }
        if (commitTimestamp == Long.MIN_VALUE) {
            JournalManager.TransactionMapItem item = this._abortedTransactionMap.get(key);
            if (item != null) throw new CorruptJournalException("Duplicate transaction abort records with same timestamp(" + key + "): previous/current=" + item.getStartAddress() + "/" + this.addressToString(address, startTimestamp));
            item = new JournalManager.TransactionMapItem(startTimestamp, address);
            item.setCommitTimestamp(Long.MIN_VALUE);
            this._abortedTransactionMap.put(key, item);
            return;
        } else {
            JournalManager.TransactionMapItem item = this._recoveredTransactionMap.get(key);
            if (item == null) {
                if (backchainAddress != 0L) {
                    throw new CorruptJournalException("Missing transaction record at with timestamp(" + key + "): previous/current=" + backchainAddress + "/" + this.addressToString(address, startTimestamp));
                }
                item = new JournalManager.TransactionMapItem(startTimestamp, address);
                this._recoveredTransactionMap.put(key, item);
            } else {
                if (backchainAddress == 0L) {
                    throw new CorruptJournalException("Duplicate transactions with same timestamp(" + key + "): previous/current=" + item.getStartAddress() + "/" + this.addressToString(address, startTimestamp));
                }
                if (item.isCommitted()) {
                    throw new CorruptJournalException("Redundant Transaction Commit Record for " + item + " at " + this.addressToString(address, startTimestamp));
                }
                if (backchainAddress != item.getLastRecordAddress()) {
                    throw new CorruptJournalException("Broken backchain at " + this.addressToString(address) + " does not match previous record " + item);
                }
                item.setLastRecordAddress(address);
            }
            item.setCommitTimestamp(commitTimestamp);
            this._persistit.getTimestampAllocator().updateTimestamp(commitTimestamp);
        }
    }

    public void applyAllRecoveredTransactions(TransactionPlayer.TransactionPlayerListener commitListener, TransactionPlayer.TransactionPlayerListener rollbackListener) throws TestException {
        TreeSet<JournalManager.TransactionMapItem> sorted;
        if (this._recoveryDisabledForTestMode) {
            return;
        }
        boolean started = false;
        JournalManager.TransactionMapItem checkpointTransactionItem = this._recoveredTransactionMap.get(this._lastValidCheckpoint.getTimestamp());
        if (checkpointTransactionItem != null) {
            checkpointTransactionItem.setCommitTimestamp(this._lastValidCheckpoint.getTimestamp());
        }
        if (!(sorted = new TreeSet<JournalManager.TransactionMapItem>(this._recoveredTransactionMap.values())).isEmpty()) {
            JournalManager.TransactionMapItem last = (JournalManager.TransactionMapItem)sorted.last();
            assert (last.getCommitTimestamp() <= this._persistit.getTimestampAllocator().getCurrentTimestamp());
        }
        for (JournalManager.TransactionMapItem item : sorted) {
            TransactionPlayer.TransactionPlayerListener listener = item.isCommitted() ? commitListener : rollbackListener;
            try {
                if (!started) {
                    commitListener.startRecovery(item.getStartAddress(), item.getCommitTimestamp());
                    started = true;
                }
                this._player.applyTransaction(item, listener);
                if (item.isCommitted()) {
                    ++this._appliedTransactionCount;
                } else {
                    ++this._abortedTransactionCount;
                }
                if ((this._appliedTransactionCount + this._abortedTransactionCount) % 10000 != 0) continue;
                this._persistit.getLogBase().recoveryProgress.log(this._appliedTransactionCount, this._abortedTransactionCount, this._recoveredTransactionMap.size() - this._appliedTransactionCount - this._abortedTransactionCount);
            }
            catch (TestException te) {
                this._persistit.getLogBase().recoveryException.log(te, item);
                throw te;
            }
            catch (Exception pe) {
                this._persistit.getLogBase().recoveryException.log(pe, item);
                ++this._errorCount;
            }
        }
        this._branchMap.clear();
    }

    void convertToLongRecord(Value value, int treeHandle, long from, long timestamp) throws PersistitException {
        JournalManager.TreeDescriptor td = this._handleToTreeMap.get(treeHandle);
        int volumeHandle = td.getVolumeHandle();
        long page = Buffer.decodeLongRecordDescriptorPointer(value.getEncodedBytes(), 0);
        int size = Buffer.decodeLongRecordDescriptorSize(value.getEncodedBytes(), 0);
        if (size < 0 || size > 0x4000000) {
            throw new CorruptJournalException("Transactional long record specification exceeds maximum size of 67108864:" + size);
        }
        byte[] rawBytes = value.getEncodedBytes();
        long startAddress = page;
        value.clear();
        if (size > value.getMaximumSize()) {
            value.setMaximumSize(size);
        }
        value.ensureFit(size);
        int offset = 0;
        int remainingSize = size;
        System.arraycopy(rawBytes, 20, value.getEncodedBytes(), offset, 100);
        offset += 100;
        remainingSize -= 100;
        int count = 0;
        while (page != 0L) {
            if (remainingSize == 0) {
                throw new CorruptJournalException("Long record chain has more than " + size + " bytes starting at page " + startAddress + " for transaction at " + this.addressToString(from, timestamp));
            }
            JournalManager.PageNode key = new JournalManager.PageNode(volumeHandle, page, -1L, -1L);
            JournalManager.PageNode pn = this.lastPageNodeBefore(this._branchMap.get(key), timestamp);
            if (pn == null) {
                pn = this.lastPageNodeBefore(this._pageMap.get(key), timestamp);
            }
            if (pn == null) {
                throw new CorruptJournalException("Long record chain missing page " + page + " at count " + count + " at " + this.addressToString(from, timestamp));
            }
            this._currentAddress = pn.getJournalAddress();
            this.read(this._currentAddress, 36);
            int type = JournalRecord.PA.getType(this._readBuffer);
            int recordSize = JournalRecord.PA.getLength(this._readBuffer);
            int payloadSize = recordSize - 36;
            int leftSize = JournalRecord.PA.getLeftSize(this._readBuffer);
            int bufferSize = JournalRecord.PA.getBufferSize(this._readBuffer);
            long pageAddress = JournalRecord.PA.getPageAddress(this._readBuffer);
            if (type != 20545) {
                throw new CorruptJournalException("Record at " + pn.toStringJournalAddress(this) + " is not a PAGE record");
            }
            if (leftSize < 0 || payloadSize < leftSize || payloadSize > bufferSize) {
                throw new CorruptJournalException("Record at " + pn.toStringJournalAddress(this) + " invalid sizes: recordSize= " + payloadSize + " leftSize=" + leftSize + " bufferSize=" + bufferSize);
            }
            if (pageAddress != pn.getPageAddress()) {
                throw new CorruptJournalException("Record at " + pn.toStringJournalAddress(this) + " mismatched page address: expected/actual=" + pn.getPageAddress() + "/" + pageAddress);
            }
            this.read(this._currentAddress, recordSize);
            int pageType = JournalRecord.getByte(this._readBuffer, 36);
            if (pageType != 31) {
                throw new CorruptJournalException("Long record chain contains invalid page type " + pageType + " for page " + page + " at " + pn.toStringJournalAddress(this) + " in transaction at " + this.addressToString(from, timestamp));
            }
            int segmentSize = Math.min(remainingSize, payloadSize - 32);
            System.arraycopy(this._readBuffer.array(), this._readBuffer.position() + 36 + 32, value.getEncodedBytes(), offset, segmentSize);
            offset += segmentSize;
            remainingSize -= segmentSize;
            page = JournalRecord.getLong(this._readBuffer, 52);
            if (count > 5000) {
                throw new CorruptJournalException("Long record chain has more than 5000 pages in starting at page " + startAddress + " for transaction at " + this.addressToString(from, timestamp));
            }
            ++count;
        }
        if (remainingSize != 0) {
            throw new CorruptJournalException("Long record chain has fewer than " + size + " bytes (" + remainingSize + " not recovered) starting at page " + startAddress + " for transaction at " + this.addressToString(from, timestamp));
        }
        value.setEncodedSize(size);
    }

    private JournalManager.PageNode lastPageNodeBefore(JournalManager.PageNode pageNode, long timestamp) {
        JournalManager.PageNode pn;
        for (pn = pageNode; pn != null && pn.getTimestamp() > timestamp; pn = pn.getPrevious()) {
        }
        return pn;
    }

    boolean analyze() throws Exception {
        this.findAndValidateKeystone();
        if (this.getKeystoneAddress() == -1L) {
            Util.println("No valid journal at %s", this.getJournalFilePath());
            return false;
        }
        Util.println("Journal at %s:", this.getJournalFilePath());
        Util.println("Keystone Address:  %,d", this.getKeystoneAddress());
        Util.println("Base Address: %,d", this.getBaseAddress());
        Util.println("Block Size: %,d", this.getBlockSize());
        Util.println("Journal created: %s", new SimpleDateFormat("yyyyMMddHHmm").format(new Date(this.getJournalCreatedTime())));
        Util.println("Last valid checkpoint: %s", this.getLastValidCheckpoint());
        Util.println("Last valid checkpoint address: %,d", this.getLastValidCheckpointAddress());
        Util.println("Recovered transaction count committed=%,d uncommitted=%,d", this.getCommittedCount(), this.getUncommittedCount());
        Util.println("Recovered page count: %,d", this.getPageMapSize());
        Util.println("Volume handle map--", new Object[0]);
        for (Map.Entry<Integer, Volume> entry : this._handleToVolumeMap.entrySet()) {
            Util.println(" %5d->%s", entry.getKey(), entry.getValue());
        }
        Util.println("Tree handle map--", new Object[0]);
        for (Map.Entry<Integer, Object> entry : this._handleToTreeMap.entrySet()) {
            Util.println(" %5d->%s", entry.getKey(), entry.getValue());
        }
        long fromGeneration = this.getBaseAddress() / this.getBlockSize();
        long toGeneration = this.getKeystoneAddress() / this.getBlockSize();
        boolean okay = true;
        for (long generation = fromGeneration; generation < toGeneration; ++generation) {
            File file = this.addressToFile(generation * this.getBlockSize());
            Util.println("Validating file %s", file);
            try {
                this.validateMemberFile(generation);
                continue;
            }
            catch (PersistitIOException ioe) {
                Util.println("   Unrecoverable: %s", ioe);
                okay = false;
            }
        }
        return okay;
    }

    public static void main(String[] args) throws Exception {
        String[] template = new String[]{"path||pathname of journal, e.g., /xxx/yyy/zzz_journal for files such as /xxx/yyy/zzz_journal.0000000000000047", "_flags|t|emit transaction details"};
        ArgParser argParser = new ArgParser("RecoveryManager", args, template).strict();
        Persistit persistit = new Persistit();
        persistit.initializeJournal();
        RecoveryManager rman = new RecoveryManager(persistit);
        rman.init(argParser.getStringValue("path"));
        rman.analyze();
    }

    private class RecoveryTransactionPlayerSupport
    implements TransactionPlayerSupport {
        private RecoveryTransactionPlayerSupport() {
        }

        @Override
        public void read(long address, int size) throws PersistitIOException {
            RecoveryManager.this.read(address, size);
        }

        @Override
        public ByteBuffer getReadBuffer() {
            return RecoveryManager.this._readBuffer;
        }

        @Override
        public void convertToLongRecord(Value value, int treeHandle, long address, long commitTimestamp) throws PersistitException {
            RecoveryManager.this.convertToLongRecord(value, treeHandle, address, commitTimestamp);
        }

        @Override
        public Persistit getPersistit() {
            return RecoveryManager.this._persistit;
        }
    }

    class DefaultRollbackListener
    implements TransactionPlayer.TransactionPlayerListener {
        DefaultRollbackListener() {
        }

        @Override
        public void store(long address, long timestamp, Exchange exchange) throws PersistitException {
            exchange.prune();
        }

        @Override
        public void removeKeyRange(long address, long timestamp, Exchange exchange, Key from, Key to) throws PersistitException {
            exchange.prune(from, to);
        }

        @Override
        public void removeTree(long address, long timestamp, Exchange exchange) throws PersistitException {
        }

        @Override
        public void delta(long address, long timestamp, Tree tree, int index, int accumulatorType, long value) throws PersistitException {
        }

        @Override
        public void startRecovery(long address, long timestamp) throws PersistitException {
        }

        @Override
        public void startTransaction(long address, long startTimestamp, long commitTimestamp) throws PersistitException {
        }

        @Override
        public void endTransaction(long address, long timestamp) throws PersistitException {
            TransactionStatus ts = RecoveryManager.this._persistit.getTransactionIndex().getStatus(timestamp);
            assert (ts != null) : "Missing TransactionStatus for timestamp " + timestamp;
            ts.setMvvCount(0);
            ThreadSequencer.sequence(SequencerConstants.RECOVERY_PRUNING_A);
            RecoveryManager.this._persistit.getJournalManager().writeTransactionToJournal(ByteBuffer.allocate(0), timestamp, Long.MIN_VALUE, 0L);
        }

        @Override
        public void endRecovery(long address, long timestamp) throws PersistitException {
        }

        @Override
        public boolean requiresLongRecordConversion() {
            return false;
        }

        @Override
        public boolean createTree(long timestamp) throws PersistitException {
            return false;
        }
    }

    static class DefaultRecoveryListener
    implements TransactionPlayer.TransactionPlayerListener {
        DefaultRecoveryListener() {
        }

        @Override
        public void store(long address, long timestamp, Exchange exchange) throws PersistitException {
            if (exchange.isDirectoryExchange() && exchange.getValue().isDefined() && exchange.getValue().getTypeHandle() == 60) {
                return;
            }
            exchange.store();
        }

        @Override
        public void removeKeyRange(long address, long timestamp, Exchange exchange, Key from, Key to) throws PersistitException {
            if (exchange.isDirectoryExchange()) {
                return;
            }
            exchange.raw_removeKeyRangeInternal(from, to, false, false);
        }

        @Override
        public void removeTree(long address, long timestamp, Exchange exchange) throws PersistitException {
            exchange.removeTree();
        }

        @Override
        public void delta(long address, long timestamp, Tree tree, int index, int accumulatorTypeOrdinal, long value) throws PersistitException {
            Accumulator.Type type = Accumulator.Type.values()[accumulatorTypeOrdinal];
            Accumulator accumulator = tree.getAccumulator(type, index);
            accumulator.updateBaseValue(value, timestamp);
        }

        @Override
        public void startRecovery(long address, long timestamp) throws PersistitException {
        }

        @Override
        public void startTransaction(long address, long startTimestamp, long commitTimestamp) throws PersistitException {
        }

        @Override
        public void endTransaction(long address, long timestamp) throws PersistitException {
        }

        @Override
        public void endRecovery(long address, long timestamp) throws PersistitException {
        }

        @Override
        public boolean requiresLongRecordConversion() {
            return true;
        }

        @Override
        public boolean createTree(long timestamp) throws PersistitException {
            return true;
        }
    }
}

