/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.CLI;
import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.KeyFilter;
import com.persistit.Persistit;
import com.persistit.Task;
import com.persistit.Tree;
import com.persistit.TreeSelector;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.exception.PersistitException;
import com.persistit.util.Util;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class StreamSaver
extends Task {
    public static final int RECORD_TYPE_FILL = 16730;
    public static final int RECORD_TYPE_DATA = 17490;
    public static final int RECORD_TYPE_KEY_FILTER = 19270;
    public static final int RECORD_TYPE_VOLUME_ID = 22089;
    public static final int RECORD_TYPE_TREE_ID = 21577;
    public static final int RECORD_TYPE_HOSTNAME = 18510;
    public static final int RECORD_TYPE_USER = 18517;
    public static final int RECORD_TYPE_COMMENT = 17231;
    public static final int RECORD_TYPE_COUNT = 21059;
    public static final int RECORD_TYPE_START = 22611;
    public static final int RECORD_TYPE_END = 22597;
    public static final int RECORD_TYPE_TIMESTAMP = 21587;
    public static final int RECORD_TYPE_EXCEPTION = 17752;
    public static final int RECORD_TYPE_COMPLETION = 23130;
    public static final int DEFAULT_CYCLE_COUNT = 1024;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    protected String _filePath;
    protected DataOutputStream _dos;
    protected Key _lastKey;
    protected Volume _lastVolume;
    protected Tree _lastTree;
    protected long _dataRecordCount = 0L;
    protected long _otherRecordCount = 0L;
    protected int _cycleCount = 1024;
    protected boolean _stop;
    protected Exception _lastException;
    protected int _recordCount;
    protected TreeSelector _treeSelector;

    StreamSaver() {
        this._lastKey = new Key((Persistit)null);
    }

    public StreamSaver(Persistit persistit, DataOutputStream dos) {
        super(persistit);
        this._lastKey = new Key(persistit);
        this._dos = dos;
    }

    public StreamSaver(Persistit persistit, File file) throws FileNotFoundException {
        this(persistit, new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 65536)));
    }

    @CLI.Cmd(value="save")
    static StreamSaver createTask(@CLI.Arg(value="file|string:|Save to file") String file, @CLI.Arg(value="trees|string:*|Tree selector - specify Volumes/Trees/Keys to save") String treeSelectorString, @CLI.Arg(value="_flag|v|verbose") boolean verbose, @CLI.Arg(value="_flag|r|Use regular expressions in tree selector") boolean regex) throws Exception {
        StreamSaver task = new StreamSaver();
        task._filePath = file;
        task._treeSelector = TreeSelector.parseSelector(treeSelectorString, regex, '\\');
        task.setMessageLogVerbosity(verbose ? 1 : 0);
        return task;
    }

    public StreamSaver(Persistit persistit, String pathName) throws FileNotFoundException {
        this(persistit, new DataOutputStream(new BufferedOutputStream(new FileOutputStream(pathName), 65536)));
    }

    public StreamSaver(Persistit persistit, File file, int bufferSize) throws FileNotFoundException {
        this(persistit, new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), bufferSize)));
    }

    public StreamSaver(Persistit persistit, String pathName, int bufferSize) throws FileNotFoundException {
        this(persistit, new DataOutputStream(new BufferedOutputStream(new FileOutputStream(pathName), bufferSize)));
    }

    public int getCycleCount() {
        return this._cycleCount;
    }

    public void setCycleCount(int count) {
        this._cycleCount = count;
    }

    public void close() throws IOException {
        this.writeTimestamp();
        if (!this._stop && this._lastException == null) {
            this._dos.writeChar(23130);
        }
        this._lastTree = null;
        this._lastVolume = null;
        this._lastKey.clear();
        this._dos.close();
    }

    protected void writeData(Exchange exchange) throws IOException {
        if (this._lastVolume != exchange.getVolume()) {
            this.writeVolumeInfo(exchange);
        }
        if (this._lastTree != exchange.getTree()) {
            this.writeTreeInfo(exchange);
        }
        this.writeData(exchange.getKey(), exchange.getValue());
        ++this._recordCount;
        if (this._recordCount % 100 == 0) {
            this.poll();
        }
    }

    protected void writeData(Key key, Value value) throws IOException {
        int elisionCount = key.firstUniqueByteIndex(this._lastKey);
        this._dos.writeChar(17490);
        this._dos.writeShort(key.getEncodedSize());
        this._dos.writeShort(elisionCount);
        this._dos.writeInt(value.getEncodedSize());
        this._dos.write(key.getEncodedBytes(), elisionCount, key.getEncodedSize() - elisionCount);
        this._dos.write(value.getEncodedBytes(), 0, value.getEncodedSize());
        ++this._dataRecordCount;
        key.copyTo(this._lastKey);
        if (this._cycleCount != 0 & this._dataRecordCount % (long)this._cycleCount == 0L) {
            this.writeRecordCount(this._dataRecordCount, this._otherRecordCount);
            this._lastKey.clear();
        }
    }

    protected void writeRecordCount(long dataRecordCount, long otherRecordCount) throws IOException {
        this._dos.writeChar(16730);
        this._dos.writeChar(16730);
        this._dos.writeChar(16730);
        this._dos.writeChar(21059);
        this._dos.writeLong(dataRecordCount);
        this._dos.writeLong(otherRecordCount);
        ++this._otherRecordCount;
    }

    protected void writeVolumeInfo(Exchange exchange) throws IOException {
        this.writeVolumeInfo(exchange.getVolume());
        this._lastVolume = exchange.getVolume();
    }

    protected void writeTreeInfo(Exchange exchange) throws IOException {
        this.writeTreeInfo(exchange.getTree());
        this._lastTree = exchange.getTree();
    }

    protected void writeVolumeInfo(Volume volume) throws IOException {
        this._dos.writeChar(22089);
        this._dos.writeLong(volume.getId());
        this._dos.writeLong(volume.getSpecification().getInitialPages());
        this._dos.writeLong(volume.getSpecification().getExtensionPages());
        this._dos.writeLong(volume.getSpecification().getMaximumPages());
        this._dos.writeInt(volume.getStructure().getPageSize());
        this._dos.writeUTF(volume.getPath());
        this._dos.writeUTF(volume.getName());
        this._lastVolume = volume;
        this._lastTree = null;
        ++this._otherRecordCount;
    }

    protected void writeTreeInfo(Tree tree) throws IOException {
        this._dos.writeChar(21577);
        this._dos.writeUTF(tree.getName());
        this._lastTree = tree;
        ++this._otherRecordCount;
    }

    protected void writeTimestamp() throws IOException {
        this._dos.writeChar(21587);
        this._dos.writeLong(System.currentTimeMillis());
    }

    protected void writeComment(String comment) throws IOException {
        this._dos.writeChar(17231);
        this._dos.writeUTF(Util.NEW_LINE + "//" + comment + "//");
    }

    protected void writeException(Exception exception) throws IOException {
        this._dos.writeChar(17752);
        this._dos.writeUTF(exception.toString());
    }

    public void save(Exchange exchange, KeyFilter filter) throws PersistitException, IOException {
        this.postMessage("Saving Tree " + exchange.getTree().getName() + " in volume " + exchange.getVolume().getPath() + (filter == null ? "" : " using KeyFilter: " + filter.toString()), 1);
        this.writeTimestamp();
        this._dos.writeChar(22611);
        if (filter != null) {
            this._dos.writeChar(19270);
            this._dos.writeUTF(filter.toString());
        }
        Key key = exchange.getKey();
        key.clear().append(Key.BEFORE);
        while (exchange.traverse(Key.GT, filter, Integer.MAX_VALUE) & !this._stop) {
            this.writeData(exchange);
        }
        this.writeRecordCount(this._dataRecordCount, this._otherRecordCount);
        this._dos.writeChar(22597);
        this.writeTimestamp();
        this.poll();
    }

    public void saveTrees(String volumeName, String[] selectedTreeNames) throws PersistitException, IOException {
        Volume volume = this._persistit.getVolume(volumeName);
        if (volume != null) {
            this.saveTrees(volume, selectedTreeNames);
        }
    }

    public void saveTrees(Volume volume, String[] selectedTreeNames) throws PersistitException, IOException {
        String[] treeNames = volume.getTreeNames();
        this.writeComment("Volume " + volume.getPath());
        int index = 0;
        while (index < treeNames.length & !this._stop) {
            boolean selected = true;
            if (selectedTreeNames != null) {
                for (int index2 = 0; selected && index2 < selectedTreeNames.length; ++index2) {
                    if (selectedTreeNames[index2].equals(treeNames[index])) continue;
                    selected = false;
                }
            }
            if (!selected) {
                this.writeComment("Tree " + treeNames[index] + " not selected");
            } else {
                this.writeComment("Tree " + treeNames[index]);
                try {
                    Exchange exchange = this._persistit.getExchange(volume, treeNames[index], false);
                    this.save(exchange, null);
                }
                catch (PersistitException exception) {
                    this._lastException = exception;
                    this.writeException(exception);
                }
            }
            ++index;
        }
    }

    public void saveTrees(TreeSelector treeSelector) throws PersistitException, IOException {
        List<Tree> trees = this._persistit.getSelectedTrees(treeSelector);
        for (Tree tree : trees) {
            if (tree.getVolume().getDirectoryTree() == tree) {
                for (String treeName : tree.getVolume().getTreeNames()) {
                    Tree t = tree.getVolume().getTree(treeName, false);
                    try {
                        this.writeComment("Tree " + treeName + " in " + tree.getVolume().getPath());
                        Exchange exchange = new Exchange(t);
                        this.save(exchange, null);
                    }
                    catch (PersistitException exception) {
                        this._lastException = exception;
                        this.writeException(exception);
                    }
                }
                continue;
            }
            try {
                this.writeComment("Tree " + tree.getName() + " in " + tree.getVolume().getPath());
                Exchange exchange = new Exchange(tree);
                this.save(exchange, treeSelector.keyFilter(tree.getVolume().getName(), tree.getName()));
            }
            catch (PersistitException exception) {
                this._lastException = exception;
                this.writeException(exception);
            }
        }
    }

    public void saveAll() throws PersistitException, IOException {
        for (Volume volume : this._persistit.getVolumes()) {
            if (this._stop) break;
            this.saveTrees(volume, null);
        }
    }

    @Override
    protected void runTask() throws PersistitException, IOException {
        this._dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._filePath), 65536));
        this.saveTrees(this._treeSelector);
        this.close();
    }

    @Override
    public String getStatus() {
        if (this._lastTree == null) {
            return null;
        }
        return "Saving " + this._lastTree.getName() + " in " + this._lastTree.getVolume().getPath() + " (" + this._recordCount + ")";
    }
}

