/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Key;
import com.persistit.Management;
import com.persistit.ui.AbstractInspector;
import com.persistit.ui.AdminUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class InspectorPanel
extends JPanel {
    protected AdminUI _adminUI;
    private final JTabbedPane _tabbedPane;
    private String _volumeName;
    private String _treeName;
    private Management.LogicalRecord _logicalRecord;
    private boolean _showValue;
    private int _selectedTab = -1;
    Map _menuMap = new HashMap();

    InspectorPanel(AdminUI ui) {
        this._adminUI = ui;
        this._tabbedPane = new JTabbedPane(2);
        this.setupTabbedPanes();
        this._tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                InspectorPanel.this.handleTabChanged();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbedPane, "Center");
        this._selectedTab = 0;
        this.handleTabChanged();
    }

    private void setupTabbedPanes() {
        String paneSpecification;
        int index = 0;
        while ((paneSpecification = this._adminUI.getProperty("InspectorTabbedPane." + index)) != null && !paneSpecification.startsWith(".")) {
            StringTokenizer st = new StringTokenizer(paneSpecification, ":");
            String className = st.nextToken();
            String caption = st.nextToken();
            String iconName = null;
            if (st.hasMoreTokens()) {
                iconName = st.nextToken();
            }
            try {
                Class<?> cl = Class.forName(className);
                AbstractInspector panel = (AbstractInspector)cl.newInstance();
                panel.setup(this._adminUI, this);
                this._tabbedPane.addTab(caption, panel);
            }
            catch (Exception e) {
                e.printStackTrace();
                this._adminUI.showMessage(e, this._adminUI.getProperty("SetupFailedMessage"), 0);
            }
            ++index;
        }
    }

    void setLogicalRecord(String volumeName, String treeName, Management.LogicalRecord lr) {
        this._volumeName = volumeName;
        this._treeName = treeName;
        this._logicalRecord = lr;
    }

    void setLogicalRecord(Management.LogicalRecord lr) {
        this.setLogicalRecord(this._volumeName, this._treeName, lr);
    }

    Management.LogicalRecord getLogicalRecord() {
        return this._logicalRecord;
    }

    String getVolumeName() {
        return this._volumeName;
    }

    String getTreeName() {
        return this._treeName;
    }

    boolean isShowValue() {
        return this._showValue;
    }

    void setShowValue(boolean showValue) {
        this._showValue = showValue;
    }

    protected synchronized void refresh(boolean reset) {
        Management.LogicalRecord lr = this.getLogicalRecord();
        if (lr == null || lr.getKeyState() == null) {
            this.nullData();
            return;
        }
        if (this._showValue) {
            new Thread(new Fetcher(this.getLogicalRecord())).start();
        } else {
            this.refreshed();
        }
    }

    private void handleTabChanged() {
        AbstractInspector inspector;
        int newTab = this._tabbedPane.getSelectedIndex();
        if (newTab == this._selectedTab) {
            return;
        }
        this._selectedTab = newTab;
        AbstractInspector abstractInspector = inspector = newTab == -1 ? null : (AbstractInspector)this._tabbedPane.getComponent(newTab);
        if (inspector != null) {
            inspector.refreshed();
        }
    }

    AbstractInspector getCurrentInspector() {
        AbstractInspector inspector = this._selectedTab == -1 ? null : (AbstractInspector)this._tabbedPane.getComponent(this._selectedTab);
        return inspector;
    }

    protected void waiting() {
        AbstractInspector inspector = this.getCurrentInspector();
        if (inspector != null) {
            inspector.waiting();
        }
    }

    protected void refreshed() {
        AbstractInspector inspector = this.getCurrentInspector();
        if (inspector != null) {
            inspector.refreshed();
        }
    }

    protected void nullData() {
        AbstractInspector inspector = this.getCurrentInspector();
        if (inspector != null) {
            inspector.nullData();
        }
    }

    protected void setDefaultButton() {
    }

    private class Fetcher
    implements Runnable {
        Management.LogicalRecord _logicalRecord;
        Exception _exception;

        Fetcher(Management.LogicalRecord lr) {
            this._logicalRecord = lr;
        }

        @Override
        public void run() {
            Management management = InspectorPanel.this._adminUI.getManagement();
            if (management == null) {
                return;
            }
            try {
                Management.LogicalRecord[] results = management.getLogicalRecordArray(InspectorPanel.this.getVolumeName(), InspectorPanel.this.getTreeName(), null, this._logicalRecord.getKeyState(), Key.EQ, 1, Integer.MAX_VALUE, true);
                if (results == null || results.length == 0) {
                    this._logicalRecord = null;
                } else {
                    Management.LogicalRecord lr = results[0];
                    if (this._logicalRecord != null && this._logicalRecord.getKeyState().equals(lr.getKeyState()) && this._logicalRecord.getValueState().equals(lr.getValueState())) {
                        return;
                    }
                    this._logicalRecord = results[0];
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Fetcher.this._exception != null) {
                            InspectorPanel.this._adminUI.postException(Fetcher.this._exception);
                        } else {
                            InspectorPanel.this.setLogicalRecord(InspectorPanel.this.getVolumeName(), InspectorPanel.this.getTreeName(), Fetcher.this._logicalRecord);
                        }
                        InspectorPanel.this.refreshed();
                    }
                });
            }
            catch (RemoteException re) {
                this._exception = re;
            }
        }
    }
}

