/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.AbstractTableModel;

public class PoolDisplayPanel
extends JPanel {
    private static final String[] HEADER_NAMES = new String[]{"Index", "Page", "Type", "Status", "Writer Thread", "Available Space", "Right Sibling"};
    private final Management _management;
    private final BufferTableModel _btm = new BufferTableModel();

    public PoolDisplayPanel(Management management) {
        this._management = management;
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(800, 600));
        this.add((Component)new JScrollPane(new JTable(this._btm)), "Center");
        JPanel selector = new JPanel(new FlowLayout());
        this.add((Component)selector, "South");
        ButtonGroup bg = new ButtonGroup();
        final JLabel stats = new JLabel();
        stats.setMinimumSize(new Dimension(150, 15));
        JRadioButton rb = new JRadioButton(new AbstractAction("All"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PoolDisplayPanel.this._btm.setSource(0);
                stats.setText(PoolDisplayPanel.this._btm.getBufferStats());
            }
        });
        bg.add(rb);
        selector.add(rb);
        rb.setSelected(true);
        rb = new JRadioButton(new AbstractAction("LRU Queue"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PoolDisplayPanel.this._btm.setSource(1);
            }
        });
        bg.add(rb);
        selector.add(rb);
        rb = new JRadioButton(new AbstractAction("Invalid Queue"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PoolDisplayPanel.this._btm.setSource(2);
                stats.setText(PoolDisplayPanel.this._btm.getBufferStats());
            }
        });
        bg.add(rb);
        selector.add(rb);
        JToggleButton tb = new JToggleButton(new AbstractAction("Valid"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PoolDisplayPanel.this._btm.setIncludeMask("v", ((JToggleButton)ae.getSource()).isSelected());
                stats.setText(PoolDisplayPanel.this._btm.getBufferStats());
            }
        });
        selector.add(tb);
        tb = new JToggleButton(new AbstractAction("Dirty"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PoolDisplayPanel.this._btm.setIncludeMask("d", ((JToggleButton)ae.getSource()).isSelected());
                stats.setText(PoolDisplayPanel.this._btm.getBufferStats());
            }
        });
        selector.add(tb);
        tb = new JToggleButton(new AbstractAction("Reader"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PoolDisplayPanel.this._btm.setIncludeMask("r", ((JToggleButton)ae.getSource()).isSelected());
                stats.setText(PoolDisplayPanel.this._btm.getBufferStats());
            }
        });
        selector.add(tb);
        tb = new JToggleButton(new AbstractAction("Writer"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PoolDisplayPanel.this._btm.setIncludeMask("w", ((JToggleButton)ae.getSource()).isSelected());
                stats.setText(PoolDisplayPanel.this._btm.getBufferStats());
            }
        });
        selector.add(tb);
        JButton b = new JButton(new AbstractAction("Refresh"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PoolDisplayPanel.this._btm._selectedBufferCount = -1;
                PoolDisplayPanel.this._btm.fireTableDataChanged();
                stats.setText(PoolDisplayPanel.this._btm.getBufferStats());
            }
        });
        selector.add(b);
        selector.add(stats);
    }

    private class BufferTableModel
    extends AbstractTableModel {
        private int _traversalType = 0;
        private String _includeMask = null;
        private final String _excludeMask;
        private long _missCount;
        private long _newCount;
        private long _hitCount;
        private double _hitRatio;
        private final DecimalFormat _df = new DecimalFormat("#####.#####");
        private Management.BufferInfo[] _buffers;
        private int _selectedBufferCount = -1;

        private BufferTableModel() {
            this._excludeMask = null;
        }

        void setIncludeMask(String mask, boolean selected) {
            if (selected && this._includeMask == null) {
                this._includeMask = "";
            }
            if (selected && this._includeMask.indexOf(mask) == -1) {
                this._includeMask = this._includeMask + mask;
                this._selectedBufferCount = -1;
                this.fireTableDataChanged();
            } else if (!selected && this._includeMask != null && this._includeMask.indexOf(mask) != -1) {
                int p = this._includeMask.indexOf(mask);
                this._includeMask = this._includeMask.substring(0, p) + this._includeMask.substring(p + 1);
                this._selectedBufferCount = -1;
                if (this._includeMask.length() == 0) {
                    this._includeMask = null;
                }
                this.fireTableDataChanged();
            }
        }

        void setSource(int code) {
            if (this._traversalType != code) {
                this._traversalType = code;
                this._selectedBufferCount = -1;
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            if (this._selectedBufferCount < 0) {
                this.loadBuffers();
            }
            return this._selectedBufferCount;
        }

        @Override
        public int getColumnCount() {
            return HEADER_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return HEADER_NAMES[column];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this._selectedBufferCount < 0) {
                this.loadBuffers();
            }
            if (row >= this._selectedBufferCount) {
                return "";
            }
            Management.BufferInfo bufferInfo = this._buffers[row];
            switch (column) {
                case 0: {
                    return Integer.toString(bufferInfo.getPoolIndex());
                }
                case 1: {
                    return Long.toString(bufferInfo.getPageAddress());
                }
                case 2: {
                    if (bufferInfo.getStatusName().indexOf(118) != -1 && bufferInfo.getPageAddress() == 0L) {
                        return "Base";
                    }
                    return bufferInfo.getTypeName();
                }
                case 3: {
                    return bufferInfo.getStatusName();
                }
                case 4: {
                    String threadName = bufferInfo.getWriterThreadName();
                    return threadName == null ? "" : threadName;
                }
                case 5: {
                    return Integer.toString(bufferInfo.getAvailableBytes());
                }
                case 6: {
                    return Long.toString(bufferInfo.getRightSiblingAddress());
                }
            }
            return "?";
        }

        private void loadBuffers() {
            try {
                Management.BufferPoolInfo[] pools = PoolDisplayPanel.this._management.getBufferPoolInfoArray();
                if (pools.length < 1) {
                    this._selectedBufferCount = 0;
                    this._hitCount = 0L;
                    this._missCount = 0L;
                    this._newCount = 0L;
                    this._hitRatio = 0.0;
                } else {
                    String managementClassName = PoolDisplayPanel.this._management.getClass().getName();
                    boolean isRemote = managementClassName.indexOf("Stub") > 0;
                    Management.BufferPoolInfo info = pools[0];
                    if (isRemote) {
                        this._buffers = PoolDisplayPanel.this._management.getBufferInfoArray(info.getBufferSize(), this._traversalType, this._includeMask, this._excludeMask);
                        this._selectedBufferCount = this._buffers == null ? -1 : this._buffers.length;
                    } else {
                        if (this._buffers == null || this._buffers.length < pools[0].getBufferCount()) {
                            this._buffers = new Management.BufferInfo[info.getBufferCount()];
                        }
                        this._selectedBufferCount = PoolDisplayPanel.this._management.populateBufferInfoArray(this._buffers, info.getBufferSize(), this._traversalType, this._includeMask, this._excludeMask);
                    }
                    this._hitCount = info.getHitCount();
                    this._missCount = info.getMissCount();
                    this._newCount = info.getNewCount();
                    this._hitRatio = info.getHitRatio();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this._selectedBufferCount = 0;
                this._hitCount = 0L;
                this._missCount = 0L;
                this._hitRatio = 0.0;
            }
        }

        private String getBufferStats() {
            return Long.toString(this._hitCount) + " / (" + Long.toString(this._missCount) + "+" + Long.toString(this._newCount) + ") = " + this._df.format(this._hitRatio);
        }
    }
}

