/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.util;

import com.persistit.util.Util;
import java.util.ArrayList;
import java.util.List;

public class ArgParser {
    private final String _progName;
    private final String[] _template;
    private final String _flags;
    private final String[] _strArgs;
    private final long[] _longArgs;
    private final boolean[] _specified;
    private boolean _usageOnly;
    private final List<String> _unparsed = new ArrayList<String>();

    public ArgParser(String progName, String[] args, String[] template) {
        int i;
        this._progName = progName;
        this._template = template;
        this._strArgs = new String[template.length];
        this._longArgs = new long[template.length];
        this._specified = new boolean[template.length];
        StringBuilder flags = new StringBuilder();
        String flagsTemplate = "";
        for (i = 0; i < template.length; ++i) {
            if (template[i].startsWith("_flag|")) {
                flagsTemplate = flagsTemplate + this.piece(template[i], '|', 1);
                continue;
            }
            this.doField(null, i);
        }
        for (i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                for (int j = 1; j < arg.length(); ++j) {
                    char ch = arg.charAt(j);
                    if (ch == '?') {
                        this.usage();
                        continue;
                    }
                    if (flagsTemplate.indexOf(ch) >= 0) {
                        flags.append(ch);
                        continue;
                    }
                    this._unparsed.add(arg);
                }
                continue;
            }
            String fieldName = this.piece(args[i], '=', 0);
            int position = this.lookupName(fieldName);
            if (position < 0) {
                this._unparsed.add(args[i]);
                continue;
            }
            String argValue = arg.substring(fieldName.length() + 1);
            this._specified[position] = true;
            this.doField(argValue, position);
        }
        this._flags = flags.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._template.length; ++i) {
            String t = this._template[i];
            if (t.startsWith("_flag|")) {
                sb.append("  flag -");
                sb.append(this.piece(t, '|', 1));
                this.tab(sb, 24);
                sb.append(this.piece(t, '|', 2));
            } else {
                sb.append("  ");
                sb.append(this.piece(t, '|', 0));
                this.tab(sb, 24);
                sb.append(this.piece(t, '|', 2));
            }
            sb.append(Util.NEW_LINE);
        }
        return sb.toString();
    }

    public ArgParser strict() {
        if (!this._unparsed.isEmpty()) {
            throw new IllegalArgumentException("Unrecognized arguments: " + this._unparsed);
        }
        return this;
    }

    public String[] getUnparsedArray() {
        return this._unparsed.toArray(new String[this._unparsed.size()]);
    }

    public List<String> getUnparsedList() {
        return this._unparsed;
    }

    public void usage() {
        this._usageOnly = true;
        System.out.println();
        System.out.println("Usage: java " + this._progName + " arguments");
        System.out.println(this.toString());
    }

    public boolean isUsageOnly() {
        return this._usageOnly;
    }

    public boolean isFlag(int ch) {
        return this._flags.indexOf(ch) >= 0;
    }

    public String getFlags() {
        return this._flags;
    }

    public boolean booleanValue(int index) {
        String t = this._template[index];
        if (t.startsWith("_flag|")) {
            return this.isFlag(t.charAt(6));
        }
        return false;
    }

    public String getStringValue(String fieldName) {
        return this._strArgs[this.lookupName(fieldName)];
    }

    public int getIntValue(String fieldName) {
        return (int)this._longArgs[this.lookupName(fieldName)];
    }

    public int intValue(int index) {
        return (int)this._longArgs[index];
    }

    public long getLongValue(String fieldName) {
        return this._longArgs[this.lookupName(fieldName)];
    }

    public long longValue(int index) {
        return this._longArgs[index];
    }

    public String stringValue(int index) {
        return this._strArgs[index];
    }

    public boolean isSpecified(String fieldName) {
        return this._specified[this.lookupName(fieldName)];
    }

    private int lookupName(String name) {
        String fieldName1 = name + '|';
        for (int i = 0; i < this._template.length; ++i) {
            if (!this._template[i].startsWith(fieldName1)) continue;
            return i;
        }
        return -1;
    }

    private void doField(String arg, int position) {
        String type = this.piece(this._template[position], '|', 1);
        String t = this.piece(type, ':', 0);
        if (arg == null) {
            arg = this.piece(type, ':', 1);
        }
        if ("int".equals(t)) {
            long lo = this.longVal(this.piece(type, ':', 2), 0L);
            long hi = this.longVal(this.piece(type, ':', 3), Integer.MAX_VALUE);
            long argInt = this.longVal(arg, Long.MIN_VALUE);
            if (this._specified[position] && (argInt == Long.MIN_VALUE || argInt < lo || argInt > hi || argInt > Integer.MAX_VALUE)) {
                throw new IllegalArgumentException("Invalid argument " + this.piece(this._template[position], '|', 0) + "=" + arg);
            }
            this._longArgs[position] = argInt;
        } else if ("long".equals(t)) {
            long lo = this.longVal(this.piece(type, ':', 2), 0L);
            long hi = this.longVal(this.piece(type, ':', 3), Long.MAX_VALUE);
            long argInt = this.longVal(arg, Long.MIN_VALUE);
            if (this._specified[position] && (argInt == Long.MIN_VALUE || argInt < lo || argInt > hi)) {
                throw new IllegalArgumentException("Invalid argument " + this.piece(this._template[position], '|', 0) + "=" + arg);
            }
            this._longArgs[position] = argInt;
        } else {
            this._strArgs[position] = arg;
        }
    }

    private long longVal(String s, long dflt) {
        if (s.length() == 0) {
            return dflt;
        }
        try {
            return Long.parseLong(s.replace(",", ""));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(s + " is not a number");
        }
    }

    private void tab(StringBuilder sb, int count) {
        int last = sb.lastIndexOf(Util.NEW_LINE);
        while (sb.length() - last + 1 < count) {
            sb.append(' ');
        }
    }

    private String piece(String str, char delimiter, int count) {
        int p = -1;
        int q = -1;
        for (int i = 0; i <= count; ++i) {
            if (p == str.length()) {
                return "";
            }
            q = p;
            if ((p = str.indexOf(delimiter, p + 1)) != -1) continue;
            p = str.length();
        }
        return str.substring(q + 1, p);
    }
}

