/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import java.util.IdentityHashMap;
import java.util.Map;
import org.sonar.db.DBSessions;
import org.sonar.db.Dao;
import org.sonar.db.Database;
import org.sonar.db.DbSession;
import org.sonar.db.MyBatis;
import org.sonar.db.alm.AlmAppInstallDao;
import org.sonar.db.ce.CeActivityDao;
import org.sonar.db.ce.CeQueueDao;
import org.sonar.db.ce.CeScannerContextDao;
import org.sonar.db.ce.CeTaskCharacteristicDao;
import org.sonar.db.ce.CeTaskInputDao;
import org.sonar.db.component.AnalysisPropertiesDao;
import org.sonar.db.component.BranchDao;
import org.sonar.db.component.ComponentDao;
import org.sonar.db.component.ComponentKeyUpdaterDao;
import org.sonar.db.component.ProjectLinkDao;
import org.sonar.db.component.SnapshotDao;
import org.sonar.db.duplication.DuplicationDao;
import org.sonar.db.es.EsQueueDao;
import org.sonar.db.event.EventDao;
import org.sonar.db.issue.IssueChangeDao;
import org.sonar.db.issue.IssueDao;
import org.sonar.db.mapping.ProjectMappingsDao;
import org.sonar.db.measure.LiveMeasureDao;
import org.sonar.db.measure.MeasureDao;
import org.sonar.db.measure.custom.CustomMeasureDao;
import org.sonar.db.metric.MetricDao;
import org.sonar.db.notification.NotificationQueueDao;
import org.sonar.db.organization.OrganizationDao;
import org.sonar.db.organization.OrganizationMemberDao;
import org.sonar.db.permission.AuthorizationDao;
import org.sonar.db.permission.GroupPermissionDao;
import org.sonar.db.permission.UserPermissionDao;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDao;
import org.sonar.db.permission.template.PermissionTemplateDao;
import org.sonar.db.plugin.PluginDao;
import org.sonar.db.property.InternalPropertiesDao;
import org.sonar.db.property.PropertiesDao;
import org.sonar.db.purge.PurgeDao;
import org.sonar.db.qualitygate.ProjectQgateAssociationDao;
import org.sonar.db.qualitygate.QualityGateConditionDao;
import org.sonar.db.qualitygate.QualityGateDao;
import org.sonar.db.qualityprofile.ActiveRuleDao;
import org.sonar.db.qualityprofile.DefaultQProfileDao;
import org.sonar.db.qualityprofile.QProfileChangeDao;
import org.sonar.db.qualityprofile.QProfileEditGroupsDao;
import org.sonar.db.qualityprofile.QProfileEditUsersDao;
import org.sonar.db.qualityprofile.QualityProfileDao;
import org.sonar.db.rule.RuleDao;
import org.sonar.db.rule.RuleRepositoryDao;
import org.sonar.db.schemamigration.SchemaMigrationDao;
import org.sonar.db.source.FileSourceDao;
import org.sonar.db.user.GroupDao;
import org.sonar.db.user.GroupMembershipDao;
import org.sonar.db.user.RoleDao;
import org.sonar.db.user.UserDao;
import org.sonar.db.user.UserGroupDao;
import org.sonar.db.user.UserTokenDao;
import org.sonar.db.webhook.WebhookDao;
import org.sonar.db.webhook.WebhookDeliveryDao;

public class DbClient {
    private final Database database;
    private final MyBatis myBatis;
    private final DBSessions dbSessions;
    private final SchemaMigrationDao schemaMigrationDao;
    private final AuthorizationDao authorizationDao;
    private final OrganizationDao organizationDao;
    private final OrganizationMemberDao organizationMemberDao;
    private final QualityProfileDao qualityProfileDao;
    private final PropertiesDao propertiesDao;
    private final AlmAppInstallDao almAppInstallDao;
    private final InternalPropertiesDao internalPropertiesDao;
    private final SnapshotDao snapshotDao;
    private final ComponentDao componentDao;
    private final ComponentKeyUpdaterDao componentKeyUpdaterDao;
    private final MeasureDao measureDao;
    private final UserDao userDao;
    private final UserGroupDao userGroupDao;
    private final UserTokenDao userTokenDao;
    private final GroupMembershipDao groupMembershipDao;
    private final RoleDao roleDao;
    private final GroupPermissionDao groupPermissionDao;
    private final PermissionTemplateDao permissionTemplateDao;
    private final PermissionTemplateCharacteristicDao permissionTemplateCharacteristicDao;
    private final IssueDao issueDao;
    private final IssueChangeDao issueChangeDao;
    private final CeActivityDao ceActivityDao;
    private final CeQueueDao ceQueueDao;
    private final CeTaskInputDao ceTaskInputDao;
    private final CeTaskCharacteristicDao ceTaskCharacteristicsDao;
    private final CeScannerContextDao ceScannerContextDao;
    private final FileSourceDao fileSourceDao;
    private final ProjectLinkDao projectLinkDao;
    private final EventDao eventDao;
    private final PurgeDao purgeDao;
    private final QualityGateDao qualityGateDao;
    private final QualityGateConditionDao gateConditionDao;
    private final ProjectQgateAssociationDao projectQgateAssociationDao;
    private final DuplicationDao duplicationDao;
    private final NotificationQueueDao notificationQueueDao;
    private final CustomMeasureDao customMeasureDao;
    private final MetricDao metricDao;
    private final GroupDao groupDao;
    private final RuleDao ruleDao;
    private final RuleRepositoryDao ruleRepositoryDao;
    private final ActiveRuleDao activeRuleDao;
    private final QProfileChangeDao qProfileChangeDao;
    private final UserPermissionDao userPermissionDao;
    private final DefaultQProfileDao defaultQProfileDao;
    private final EsQueueDao esQueueDao;
    private final PluginDao pluginDao;
    private final BranchDao branchDao;
    private final AnalysisPropertiesDao analysisPropertiesDao;
    private final QProfileEditUsersDao qProfileEditUsersDao;
    private final QProfileEditGroupsDao qProfileEditGroupsDao;
    private final LiveMeasureDao liveMeasureDao;
    private final WebhookDao webhookDao;
    private final WebhookDeliveryDao webhookDeliveryDao;
    private final ProjectMappingsDao projectMappingsDao;

    public DbClient(Database database, MyBatis myBatis, DBSessions dbSessions, Dao ... daos) {
        this.database = database;
        this.myBatis = myBatis;
        this.dbSessions = dbSessions;
        IdentityHashMap<Class, Dao> map = new IdentityHashMap<Class, Dao>();
        for (Dao dao : daos) {
            map.put(dao.getClass(), dao);
        }
        this.almAppInstallDao = this.getDao(map, AlmAppInstallDao.class);
        this.schemaMigrationDao = this.getDao(map, SchemaMigrationDao.class);
        this.authorizationDao = this.getDao(map, AuthorizationDao.class);
        this.organizationDao = this.getDao(map, OrganizationDao.class);
        this.organizationMemberDao = this.getDao(map, OrganizationMemberDao.class);
        this.qualityProfileDao = this.getDao(map, QualityProfileDao.class);
        this.propertiesDao = this.getDao(map, PropertiesDao.class);
        this.internalPropertiesDao = this.getDao(map, InternalPropertiesDao.class);
        this.snapshotDao = this.getDao(map, SnapshotDao.class);
        this.componentDao = this.getDao(map, ComponentDao.class);
        this.componentKeyUpdaterDao = this.getDao(map, ComponentKeyUpdaterDao.class);
        this.measureDao = this.getDao(map, MeasureDao.class);
        this.userDao = this.getDao(map, UserDao.class);
        this.userGroupDao = this.getDao(map, UserGroupDao.class);
        this.userTokenDao = this.getDao(map, UserTokenDao.class);
        this.groupMembershipDao = this.getDao(map, GroupMembershipDao.class);
        this.roleDao = this.getDao(map, RoleDao.class);
        this.groupPermissionDao = this.getDao(map, GroupPermissionDao.class);
        this.permissionTemplateDao = this.getDao(map, PermissionTemplateDao.class);
        this.permissionTemplateCharacteristicDao = this.getDao(map, PermissionTemplateCharacteristicDao.class);
        this.issueDao = this.getDao(map, IssueDao.class);
        this.issueChangeDao = this.getDao(map, IssueChangeDao.class);
        this.ceActivityDao = this.getDao(map, CeActivityDao.class);
        this.ceQueueDao = this.getDao(map, CeQueueDao.class);
        this.ceTaskInputDao = this.getDao(map, CeTaskInputDao.class);
        this.ceTaskCharacteristicsDao = this.getDao(map, CeTaskCharacteristicDao.class);
        this.ceScannerContextDao = this.getDao(map, CeScannerContextDao.class);
        this.fileSourceDao = this.getDao(map, FileSourceDao.class);
        this.projectLinkDao = this.getDao(map, ProjectLinkDao.class);
        this.eventDao = this.getDao(map, EventDao.class);
        this.purgeDao = this.getDao(map, PurgeDao.class);
        this.qualityGateDao = this.getDao(map, QualityGateDao.class);
        this.gateConditionDao = this.getDao(map, QualityGateConditionDao.class);
        this.projectQgateAssociationDao = this.getDao(map, ProjectQgateAssociationDao.class);
        this.duplicationDao = this.getDao(map, DuplicationDao.class);
        this.notificationQueueDao = this.getDao(map, NotificationQueueDao.class);
        this.customMeasureDao = this.getDao(map, CustomMeasureDao.class);
        this.metricDao = this.getDao(map, MetricDao.class);
        this.groupDao = this.getDao(map, GroupDao.class);
        this.ruleDao = this.getDao(map, RuleDao.class);
        this.ruleRepositoryDao = this.getDao(map, RuleRepositoryDao.class);
        this.activeRuleDao = this.getDao(map, ActiveRuleDao.class);
        this.qProfileChangeDao = this.getDao(map, QProfileChangeDao.class);
        this.userPermissionDao = this.getDao(map, UserPermissionDao.class);
        this.defaultQProfileDao = this.getDao(map, DefaultQProfileDao.class);
        this.esQueueDao = this.getDao(map, EsQueueDao.class);
        this.pluginDao = this.getDao(map, PluginDao.class);
        this.branchDao = this.getDao(map, BranchDao.class);
        this.analysisPropertiesDao = this.getDao(map, AnalysisPropertiesDao.class);
        this.qProfileEditUsersDao = this.getDao(map, QProfileEditUsersDao.class);
        this.qProfileEditGroupsDao = this.getDao(map, QProfileEditGroupsDao.class);
        this.liveMeasureDao = this.getDao(map, LiveMeasureDao.class);
        this.webhookDao = this.getDao(map, WebhookDao.class);
        this.webhookDeliveryDao = this.getDao(map, WebhookDeliveryDao.class);
        this.projectMappingsDao = this.getDao(map, ProjectMappingsDao.class);
    }

    public DbSession openSession(boolean batch) {
        return this.dbSessions.openSession(batch);
    }

    public Database getDatabase() {
        return this.database;
    }

    public AlmAppInstallDao almAppInstallDao() {
        return this.almAppInstallDao;
    }

    public SchemaMigrationDao schemaMigrationDao() {
        return this.schemaMigrationDao;
    }

    public AuthorizationDao authorizationDao() {
        return this.authorizationDao;
    }

    public OrganizationDao organizationDao() {
        return this.organizationDao;
    }

    public OrganizationMemberDao organizationMemberDao() {
        return this.organizationMemberDao;
    }

    public IssueDao issueDao() {
        return this.issueDao;
    }

    public IssueChangeDao issueChangeDao() {
        return this.issueChangeDao;
    }

    public QualityProfileDao qualityProfileDao() {
        return this.qualityProfileDao;
    }

    public PropertiesDao propertiesDao() {
        return this.propertiesDao;
    }

    public InternalPropertiesDao internalPropertiesDao() {
        return this.internalPropertiesDao;
    }

    public SnapshotDao snapshotDao() {
        return this.snapshotDao;
    }

    public AnalysisPropertiesDao analysisPropertiesDao() {
        return this.analysisPropertiesDao;
    }

    public ComponentDao componentDao() {
        return this.componentDao;
    }

    public ComponentKeyUpdaterDao componentKeyUpdaterDao() {
        return this.componentKeyUpdaterDao;
    }

    public MeasureDao measureDao() {
        return this.measureDao;
    }

    public UserDao userDao() {
        return this.userDao;
    }

    public UserGroupDao userGroupDao() {
        return this.userGroupDao;
    }

    public UserTokenDao userTokenDao() {
        return this.userTokenDao;
    }

    public GroupMembershipDao groupMembershipDao() {
        return this.groupMembershipDao;
    }

    public RoleDao roleDao() {
        return this.roleDao;
    }

    public GroupPermissionDao groupPermissionDao() {
        return this.groupPermissionDao;
    }

    public PermissionTemplateDao permissionTemplateDao() {
        return this.permissionTemplateDao;
    }

    public PermissionTemplateCharacteristicDao permissionTemplateCharacteristicDao() {
        return this.permissionTemplateCharacteristicDao;
    }

    public CeActivityDao ceActivityDao() {
        return this.ceActivityDao;
    }

    public CeQueueDao ceQueueDao() {
        return this.ceQueueDao;
    }

    public CeTaskInputDao ceTaskInputDao() {
        return this.ceTaskInputDao;
    }

    public CeTaskCharacteristicDao ceTaskCharacteristicsDao() {
        return this.ceTaskCharacteristicsDao;
    }

    public CeScannerContextDao ceScannerContextDao() {
        return this.ceScannerContextDao;
    }

    public FileSourceDao fileSourceDao() {
        return this.fileSourceDao;
    }

    public ProjectLinkDao projectLinkDao() {
        return this.projectLinkDao;
    }

    public EventDao eventDao() {
        return this.eventDao;
    }

    public PurgeDao purgeDao() {
        return this.purgeDao;
    }

    public QualityGateDao qualityGateDao() {
        return this.qualityGateDao;
    }

    public QualityGateConditionDao gateConditionDao() {
        return this.gateConditionDao;
    }

    public ProjectQgateAssociationDao projectQgateAssociationDao() {
        return this.projectQgateAssociationDao;
    }

    public DuplicationDao duplicationDao() {
        return this.duplicationDao;
    }

    public NotificationQueueDao notificationQueueDao() {
        return this.notificationQueueDao;
    }

    public CustomMeasureDao customMeasureDao() {
        return this.customMeasureDao;
    }

    public MetricDao metricDao() {
        return this.metricDao;
    }

    public GroupDao groupDao() {
        return this.groupDao;
    }

    public RuleDao ruleDao() {
        return this.ruleDao;
    }

    public RuleRepositoryDao ruleRepositoryDao() {
        return this.ruleRepositoryDao;
    }

    public ActiveRuleDao activeRuleDao() {
        return this.activeRuleDao;
    }

    public QProfileChangeDao qProfileChangeDao() {
        return this.qProfileChangeDao;
    }

    public UserPermissionDao userPermissionDao() {
        return this.userPermissionDao;
    }

    public DefaultQProfileDao defaultQProfileDao() {
        return this.defaultQProfileDao;
    }

    public EsQueueDao esQueueDao() {
        return this.esQueueDao;
    }

    public PluginDao pluginDao() {
        return this.pluginDao;
    }

    public BranchDao branchDao() {
        return this.branchDao;
    }

    public QProfileEditUsersDao qProfileEditUsersDao() {
        return this.qProfileEditUsersDao;
    }

    public QProfileEditGroupsDao qProfileEditGroupsDao() {
        return this.qProfileEditGroupsDao;
    }

    public LiveMeasureDao liveMeasureDao() {
        return this.liveMeasureDao;
    }

    protected <K extends Dao> K getDao(Map<Class, Dao> map, Class<K> clazz) {
        return (K)map.get(clazz);
    }

    public MyBatis getMyBatis() {
        return this.myBatis;
    }

    public WebhookDao webhookDao() {
        return this.webhookDao;
    }

    public WebhookDeliveryDao webhookDeliveryDao() {
        return this.webhookDeliveryDao;
    }

    public ProjectMappingsDao projectMappingsDao() {
        return this.projectMappingsDao;
    }
}

