/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import org.sonar.db.DbSession;
import org.sonar.db.DelegatingDbSession;

class NonClosingDbSession
extends DelegatingDbSession {
    private boolean dirty;

    NonClosingDbSession(DbSession delegate) {
        super(delegate);
    }

    @Override
    public void doClose() {
        if (this.dirty) {
            this.getDelegate().rollback();
        }
    }

    @Override
    public int insert(String statement) {
        this.dirty = true;
        return super.insert(statement);
    }

    @Override
    public int insert(String statement, Object parameter) {
        this.dirty = true;
        return super.insert(statement, parameter);
    }

    @Override
    public int update(String statement) {
        this.dirty = true;
        return super.update(statement);
    }

    @Override
    public int update(String statement, Object parameter) {
        this.dirty = true;
        return super.update(statement, parameter);
    }

    @Override
    public int delete(String statement) {
        this.dirty = true;
        return super.delete(statement);
    }

    @Override
    public int delete(String statement, Object parameter) {
        this.dirty = true;
        return super.delete(statement, parameter);
    }

    @Override
    public void commit() {
        super.commit();
        this.dirty = false;
    }

    @Override
    public void commit(boolean force) {
        super.commit(force);
        this.dirty = false;
    }

    @Override
    public void rollback() {
        super.rollback();
        this.dirty = false;
    }

    @Override
    public void rollback(boolean force) {
        super.rollback(force);
        this.dirty = false;
    }
}

