/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Pagination {
    private static final Pagination ALL = new Builder(1).andSize(Integer.MAX_VALUE);
    private final int page;
    private final int pageSize;

    private Pagination(Builder builder) {
        this.page = builder.page;
        this.pageSize = builder.pageSize;
    }

    public static Pagination all() {
        return ALL;
    }

    public static Builder forPage(int page) {
        return new Builder(page);
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getOffset() {
        return (this.page - 1) * this.pageSize;
    }

    public int getStartRowNumber() {
        return this.getOffset() + 1;
    }

    public int getEndRowNumber() {
        return this.page * this.pageSize;
    }

    public static final class Builder {
        private final int page;
        private int pageSize = 0;

        public Builder(int page) {
            Preconditions.checkArgument((page >= 1 ? 1 : 0) != 0, (Object)"page index must be >= 1");
            this.page = page;
        }

        public Pagination andSize(int pageSize) {
            Preconditions.checkArgument((pageSize >= 1 ? 1 : 0) != 0, (Object)"page size must be >= 1");
            this.pageSize = pageSize;
            return new Pagination(this);
        }
    }
}

