/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.alm;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.alm.AlmAppInstallMapper;

public class AlmAppInstallDao
implements Dao {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public AlmAppInstallDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    public void insertOrUpdate(DbSession dbSession, ALM alm, String ownerId, String installId) {
        AlmAppInstallDao.checkAlm(alm);
        AlmAppInstallDao.checkOwnerId(ownerId);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)installId), (Object)"installId can't be null nor empty");
        AlmAppInstallMapper mapper = AlmAppInstallDao.getMapper(dbSession);
        long now = this.system2.now();
        if (mapper.update(alm.getId(), ownerId, installId, now) == 0) {
            mapper.insert(this.uuidFactory.create(), alm.getId(), ownerId, installId, now);
        }
    }

    public Optional<String> getInstallId(DbSession dbSession, ALM alm, String ownerId) {
        AlmAppInstallDao.checkAlm(alm);
        AlmAppInstallDao.checkOwnerId(ownerId);
        AlmAppInstallMapper mapper = AlmAppInstallDao.getMapper(dbSession);
        return Optional.ofNullable(mapper.selectInstallId(alm.getId(), ownerId));
    }

    public void delete(DbSession dbSession, ALM alm, String ownerId) {
        AlmAppInstallDao.checkAlm(alm);
        AlmAppInstallDao.checkOwnerId(ownerId);
        AlmAppInstallMapper mapper = AlmAppInstallDao.getMapper(dbSession);
        mapper.delete(alm.getId(), ownerId);
    }

    private static void checkAlm(@Nullable ALM alm) {
        Objects.requireNonNull(alm, "alm can't be null");
    }

    private static void checkOwnerId(@Nullable String ownerId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)ownerId), (Object)"ownerId can't be null nor empty");
    }

    private static AlmAppInstallMapper getMapper(DbSession dbSession) {
        return (AlmAppInstallMapper)dbSession.getMapper(AlmAppInstallMapper.class);
    }

    public static enum ALM {
        BITBUCKETCLOUD,
        GITHUB;


        String getId() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

