/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.ce;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeActivityMapper;
import org.sonar.db.ce.CeTaskQuery;

public class CeActivityDao
implements Dao {
    private final System2 system2;

    public CeActivityDao(System2 system2) {
        this.system2 = system2;
    }

    public Optional<CeActivityDto> selectByUuid(DbSession dbSession, String uuid) {
        return Optional.ofNullable(CeActivityDao.mapper(dbSession).selectByUuid(uuid));
    }

    public void insert(DbSession dbSession, CeActivityDto dto) {
        dto.setCreatedAt(this.system2.now());
        dto.setUpdatedAt(this.system2.now());
        dto.setIsLast(dto.getStatus() != CeActivityDto.Status.CANCELED);
        CeActivityMapper ceActivityMapper = CeActivityDao.mapper(dbSession);
        if (dto.getIsLast()) {
            ceActivityMapper.updateIsLastToFalseForLastKey(dto.getIsLastKey(), dto.getUpdatedAt());
        }
        ceActivityMapper.insert(dto);
    }

    public List<CeActivityDto> selectOlderThan(DbSession dbSession, long beforeDate) {
        return CeActivityDao.mapper(dbSession).selectOlderThan(beforeDate);
    }

    public void deleteByUuids(DbSession dbSession, Set<String> uuids) {
        DatabaseUtils.executeLargeUpdates(uuids, CeActivityDao.mapper(dbSession)::deleteByUuids);
    }

    public List<CeActivityDto> selectByQuery(DbSession dbSession, CeTaskQuery query, Pagination pagination) {
        if (query.isShortCircuitedByComponentUuids()) {
            return Collections.emptyList();
        }
        return CeActivityDao.mapper(dbSession).selectByQuery(query, pagination);
    }

    public int countLastByStatusAndComponentUuid(DbSession dbSession, CeActivityDto.Status status, @Nullable String componentUuid) {
        return CeActivityDao.mapper(dbSession).countLastByStatusAndComponentUuid(status, componentUuid);
    }

    private static CeActivityMapper mapper(DbSession dbSession) {
        return (CeActivityMapper)dbSession.getMapper(CeActivityMapper.class);
    }
}

