/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.ce;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.ce.CeQueueDto;

public class CeActivityDto {
    private static final int MAX_SIZE_ERROR_MESSAGE = 1000;
    private String uuid;
    private String componentUuid;
    private String analysisUuid;
    private Status status;
    private String taskType;
    private boolean isLast;
    private String isLastKey;
    private String submitterUuid;
    private String workerUuid;
    private long submittedAt;
    private Long startedAt;
    private Long executedAt;
    private long createdAt;
    private long updatedAt;
    private Long executionTimeMs;
    private String errorMessage;
    private String errorStacktrace;
    @Nullable
    private String errorType;
    private boolean hasScannerContext;

    CeActivityDto() {
    }

    public CeActivityDto(CeQueueDto queueDto) {
        this.uuid = queueDto.getUuid();
        this.taskType = queueDto.getTaskType();
        this.componentUuid = queueDto.getComponentUuid();
        this.isLastKey = String.format("%s%s", this.taskType, Strings.nullToEmpty((String)this.componentUuid));
        this.submitterUuid = queueDto.getSubmitterUuid();
        this.workerUuid = queueDto.getWorkerUuid();
        this.submittedAt = queueDto.getCreatedAt();
        this.startedAt = queueDto.getStartedAt();
    }

    public String getUuid() {
        return this.uuid;
    }

    public CeActivityDto setUuid(String s) {
        Preconditions.checkArgument((s.length() <= 40 ? 1 : 0) != 0, (String)"Value is too long for column CE_ACTIVITY.UUID: %s", (Object[])new Object[]{s});
        this.uuid = s;
        return this;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public CeActivityDto setTaskType(String s) {
        this.taskType = s;
        return this;
    }

    @CheckForNull
    public String getComponentUuid() {
        return this.componentUuid;
    }

    public CeActivityDto setComponentUuid(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 40 ? 1 : 0) != 0, (String)"Value is too long for column CE_ACTIVITY.COMPONENT_UUID: %s", (Object[])new Object[]{s});
        this.componentUuid = s;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public CeActivityDto setStatus(Status s) {
        this.status = s;
        return this;
    }

    public boolean getIsLast() {
        return this.isLast;
    }

    CeActivityDto setIsLast(boolean b) {
        this.isLast = b;
        return this;
    }

    public String getIsLastKey() {
        return this.isLastKey;
    }

    @CheckForNull
    public String getSubmitterUuid() {
        return this.submitterUuid;
    }

    public long getSubmittedAt() {
        return this.submittedAt;
    }

    public CeActivityDto setSubmittedAt(long submittedAt) {
        this.submittedAt = submittedAt;
        return this;
    }

    @CheckForNull
    public Long getStartedAt() {
        return this.startedAt;
    }

    public CeActivityDto setStartedAt(@Nullable Long l) {
        this.startedAt = l;
        return this;
    }

    @CheckForNull
    public Long getExecutedAt() {
        return this.executedAt;
    }

    public CeActivityDto setExecutedAt(@Nullable Long l) {
        this.executedAt = l;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public CeActivityDto setCreatedAt(long l) {
        this.createdAt = l;
        return this;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public CeActivityDto setUpdatedAt(long l) {
        this.updatedAt = l;
        return this;
    }

    @CheckForNull
    public Long getExecutionTimeMs() {
        return this.executionTimeMs;
    }

    public CeActivityDto setExecutionTimeMs(@Nullable Long l) {
        Preconditions.checkArgument((l == null || l >= 0L ? 1 : 0) != 0, (String)"Execution time must be positive: %s", (Object[])new Object[]{l});
        this.executionTimeMs = l;
        return this;
    }

    @CheckForNull
    public String getAnalysisUuid() {
        return this.analysisUuid;
    }

    public CeActivityDto setAnalysisUuid(@Nullable String s) {
        this.analysisUuid = s;
        return this;
    }

    @CheckForNull
    public String getWorkerUuid() {
        return this.workerUuid;
    }

    public CeActivityDto setWorkerUuid(String workerUuid) {
        this.workerUuid = workerUuid;
        return this;
    }

    @CheckForNull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public CeActivityDto setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = CeActivityDto.ensureNotTooBig(errorMessage, 1000);
        return this;
    }

    @CheckForNull
    public String getErrorType() {
        return this.errorType;
    }

    public CeActivityDto setErrorType(@Nullable String s) {
        this.errorType = CeActivityDto.ensureNotTooBig(s, 20);
        return this;
    }

    @CheckForNull
    private static String ensureNotTooBig(@Nullable String str, int maxSize) {
        if (str == null) {
            return null;
        }
        if (str.length() <= maxSize) {
            return str;
        }
        return str.substring(0, maxSize);
    }

    @CheckForNull
    public String getErrorStacktrace() {
        return this.errorStacktrace;
    }

    @CheckForNull
    public CeActivityDto setErrorStacktrace(@Nullable String errorStacktrace) {
        this.errorStacktrace = errorStacktrace;
        return this;
    }

    public boolean isHasScannerContext() {
        return this.hasScannerContext;
    }

    protected void setHasScannerContext(boolean hasScannerContext) {
        this.hasScannerContext = hasScannerContext;
    }

    public String toString() {
        return "CeActivityDto{uuid='" + this.uuid + '\'' + ", componentUuid='" + this.componentUuid + '\'' + ", analysisUuid='" + this.analysisUuid + '\'' + ", status=" + (Object)((Object)this.status) + ", taskType='" + this.taskType + '\'' + ", isLast=" + this.isLast + ", isLastKey='" + this.isLastKey + '\'' + ", submitterUuid='" + this.submitterUuid + '\'' + ", workerUuid='" + this.workerUuid + '\'' + ", submittedAt=" + this.submittedAt + ", startedAt=" + this.startedAt + ", executedAt=" + this.executedAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", executionTimeMs=" + this.executionTimeMs + ", errorMessage='" + this.errorMessage + '\'' + ", errorStacktrace='" + this.errorStacktrace + '\'' + ", hasScannerContext=" + this.hasScannerContext + '}';
    }

    public static enum Status {
        SUCCESS,
        FAILED,
        CANCELED;

    }
}

