/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.ce;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.ibatis.session.RowBounds;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.ce.CeQueueMapper;
import org.sonar.db.ce.CeTaskQuery;
import org.sonar.db.ce.QueueCount;
import org.sonar.db.ce.UpdateIf;

public class CeQueueDao
implements Dao {
    private static final Pagination ONE_RESULT_PAGINATION = Pagination.forPage(1).andSize(1);
    private final System2 system2;

    public CeQueueDao(System2 system2) {
        this.system2 = system2;
    }

    public List<CeQueueDto> selectAllInAscOrder(DbSession session) {
        return CeQueueDao.mapper(session).selectAllInAscOrder();
    }

    public List<CeQueueDto> selectByQueryInDescOrder(DbSession dbSession, CeTaskQuery query, int pageSize) {
        if (query.isShortCircuitedByComponentUuids() || query.isOnlyCurrents() || query.getMaxExecutedAt() != null) {
            return Collections.emptyList();
        }
        return CeQueueDao.mapper(dbSession).selectByQueryInDescOrder(query, new RowBounds(0, pageSize));
    }

    public int countByQuery(DbSession dbSession, CeTaskQuery query) {
        if (query.isShortCircuitedByComponentUuids() || query.isOnlyCurrents() || query.getMaxExecutedAt() != null) {
            return 0;
        }
        return CeQueueDao.mapper(dbSession).countByQuery(query);
    }

    public List<CeQueueDto> selectByComponentUuid(DbSession session, String componentUuid) {
        return CeQueueDao.mapper(session).selectByComponentUuid(componentUuid);
    }

    public Optional<CeQueueDto> selectByUuid(DbSession session, String uuid) {
        return Optional.ofNullable(CeQueueDao.mapper(session).selectByUuid(uuid));
    }

    public List<CeQueueDto> selectPending(DbSession dbSession) {
        return CeQueueDao.mapper(dbSession).selectPending();
    }

    public void resetTasksWithUnknownWorkerUUIDs(DbSession dbSession, Set<String> knownWorkerUUIDs) {
        if (knownWorkerUUIDs.isEmpty()) {
            CeQueueDao.mapper(dbSession).resetAllInProgressTasks(this.system2.now());
        } else {
            DatabaseUtils.executeLargeUpdates(knownWorkerUUIDs, uuids -> CeQueueDao.mapper(dbSession).resetTasksWithUnknownWorkerUUIDs((List<String>)uuids, this.system2.now()));
        }
    }

    public CeQueueDto insert(DbSession session, CeQueueDto dto) {
        if (dto.getCreatedAt() == 0L || dto.getUpdatedAt() == 0L) {
            long now = this.system2.now();
            dto.setCreatedAt(now);
            dto.setUpdatedAt(now);
        }
        CeQueueDao.mapper(session).insert(dto);
        return dto;
    }

    public void deleteByUuid(DbSession session, String uuid) {
        CeQueueDao.mapper(session).deleteByUuid(uuid);
    }

    public int resetToPendingForWorker(DbSession session, String workerUuid) {
        return CeQueueDao.mapper(session).resetToPendingForWorker(workerUuid, this.system2.now());
    }

    public int countByStatus(DbSession dbSession, CeQueueDto.Status status) {
        return CeQueueDao.mapper(dbSession).countByStatusAndComponentUuid(status, null);
    }

    public int countByStatusAndComponentUuid(DbSession dbSession, CeQueueDto.Status status, @Nullable String componentUuid) {
        return CeQueueDao.mapper(dbSession).countByStatusAndComponentUuid(status, componentUuid);
    }

    public Map<String, Integer> countByStatusAndComponentUuids(DbSession dbSession, CeQueueDto.Status status, Set<String> componentUuids) {
        if (componentUuids.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DatabaseUtils.executeLargeUpdates(componentUuids, uuids -> {
            List<QueueCount> i = CeQueueDao.mapper(dbSession).countByStatusAndComponentUuids(status, componentUuids);
            i.forEach(o -> builder.put((Object)o.getComponentUuid(), (Object)o.getTotal()));
        });
        return builder.build();
    }

    public Optional<CeQueueDto> peek(DbSession session, String workerUuid) {
        List<String> eligibles = CeQueueDao.mapper(session).selectEligibleForPeek(ONE_RESULT_PAGINATION);
        if (eligibles.isEmpty()) {
            return Optional.empty();
        }
        String eligible = eligibles.get(0);
        return this.tryToPeek(session, eligible, workerUuid);
    }

    private Optional<CeQueueDto> tryToPeek(DbSession session, String eligibleTaskUuid, String workerUuid) {
        long now = this.system2.now();
        int touchedRows = CeQueueDao.mapper(session).updateIf(eligibleTaskUuid, new UpdateIf.NewProperties(CeQueueDto.Status.IN_PROGRESS, workerUuid, now, now), new UpdateIf.OldProperties(CeQueueDto.Status.PENDING));
        if (touchedRows != 1) {
            return Optional.empty();
        }
        CeQueueDto result = CeQueueDao.mapper(session).selectByUuid(eligibleTaskUuid);
        session.commit();
        return Optional.ofNullable(result);
    }

    private static CeQueueMapper mapper(DbSession session) {
        return (CeQueueMapper)session.getMapper(CeQueueMapper.class);
    }
}

