/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.ce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.utils.System2;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeScannerContextMapper;
import org.sonar.db.ce.LogsIteratorInputStream;

public class CeScannerContextDao
implements Dao {
    private final System2 system;

    public CeScannerContextDao(System2 system) {
        this.system = system;
    }

    public void insert(DbSession dbSession, String taskUuid, CloseableIterator<String> scannerContextLines) {
        Preconditions.checkArgument((boolean)scannerContextLines.hasNext(), (Object)"Scanner context can not be empty");
        long now = this.system.now();
        Connection connection = dbSession.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO ce_scanner_context (task_uuid, created_at, updated_at, context_data) VALUES (?, ?, ?, ?)");
             LogsIteratorInputStream inputStream = new LogsIteratorInputStream(scannerContextLines, StandardCharsets.UTF_8);){
            stmt.setString(1, taskUuid);
            stmt.setLong(2, now);
            stmt.setLong(3, now);
            stmt.setBinaryStream(4, inputStream);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (IOException | SQLException e) {
            throw new IllegalStateException("Fail to insert scanner context for task " + taskUuid, e);
        }
    }

    /*
     * Exception decompiling
     */
    public Optional<String> selectScannerContext(DbSession dbSession, String taskUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Set<String> selectOlderThan(DbSession dbSession, long beforeDate) {
        return CeScannerContextDao.mapper(dbSession).selectOlderThan(beforeDate);
    }

    public void deleteByUuids(DbSession dbSession, Collection<String> uuids) {
        DatabaseUtils.executeLargeUpdates(uuids, CeScannerContextDao.mapper(dbSession)::deleteByUuids);
    }

    private static CeScannerContextMapper mapper(DbSession dbSession) {
        return (CeScannerContextMapper)dbSession.getMapper(CeScannerContextMapper.class);
    }
}

