/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchMapper;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.KeyType;

public class BranchDao
implements Dao {
    private final System2 system2;

    public BranchDao(System2 system2) {
        this.system2 = system2;
    }

    public void insert(DbSession dbSession, BranchDto dto) {
        BranchDao.setKeyType(dto);
        BranchDao.mapper(dbSession).insert(dto, this.system2.now());
    }

    public void upsert(DbSession dbSession, BranchDto dto) {
        BranchMapper mapper = BranchDao.mapper(dbSession);
        long now = this.system2.now();
        BranchDao.setKeyType(dto);
        if (mapper.update(dto, now) == 0) {
            mapper.insert(dto, now);
        }
    }

    private static void setKeyType(BranchDto dto) {
        if (dto.getBranchType() == BranchType.PULL_REQUEST) {
            dto.setKeyType(KeyType.PULL_REQUEST);
        } else {
            dto.setKeyType(KeyType.BRANCH);
        }
    }

    public int updateMainBranchName(DbSession dbSession, String projectUuid, String newBranchKey) {
        long now = this.system2.now();
        return BranchDao.mapper(dbSession).updateMainBranchName(projectUuid, newBranchKey, now);
    }

    public Optional<BranchDto> selectByBranchKey(DbSession dbSession, String projectUuid, String key) {
        return BranchDao.selectByKey(dbSession, projectUuid, key, KeyType.BRANCH);
    }

    public Optional<BranchDto> selectByPullRequestKey(DbSession dbSession, String projectUuid, String key) {
        return BranchDao.selectByKey(dbSession, projectUuid, key, KeyType.PULL_REQUEST);
    }

    private static Optional<BranchDto> selectByKey(DbSession dbSession, String projectUuid, String key, KeyType keyType) {
        return Optional.ofNullable(BranchDao.mapper(dbSession).selectByKey(projectUuid, key, keyType));
    }

    public Collection<BranchDto> selectByComponent(DbSession dbSession, ComponentDto component) {
        String projectUuid = component.getMainBranchProjectUuid();
        if (projectUuid == null) {
            projectUuid = component.projectUuid();
        }
        return BranchDao.mapper(dbSession).selectByProjectUuid(projectUuid);
    }

    public List<BranchDto> selectByUuids(DbSession session, Collection<String> uuids) {
        return DatabaseUtils.executeLargeInputs(uuids, BranchDao.mapper(session)::selectByUuids);
    }

    public Optional<BranchDto> selectByUuid(DbSession session, String uuid) {
        return Optional.ofNullable(BranchDao.mapper(session).selectByUuid(uuid));
    }

    public boolean hasNonMainBranches(DbSession dbSession) {
        return BranchDao.mapper(dbSession).countNonMainBranches() > 0L;
    }

    private static BranchMapper mapper(DbSession dbSession) {
        return (BranchMapper)dbSession.getMapper(BranchMapper.class);
    }
}

