/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public final class SnapshotDto {
    public static final String STATUS_UNPROCESSED = "U";
    public static final String STATUS_PROCESSED = "P";
    public static final int MAX_VERSION_LENGTH = 100;
    private Long id;
    private String uuid;
    private String componentUuid;
    private Long createdAt;
    private Long buildDate;
    private String status = "U";
    private Integer purgeStatus;
    private Boolean last;
    private String version;
    private String periodMode;
    private String periodParam;
    private Long periodDate;

    public Long getId() {
        return this.id;
    }

    public SnapshotDto setId(Long id) {
        this.id = id;
        return this;
    }

    public SnapshotDto setUuid(String s) {
        this.uuid = s;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Long getBuildDate() {
        return this.buildDate;
    }

    public SnapshotDto setBuildDate(Long buildDate) {
        this.buildDate = buildDate;
        return this;
    }

    public String getComponentUuid() {
        return this.componentUuid;
    }

    public SnapshotDto setComponentUuid(String componentUuid) {
        this.componentUuid = componentUuid;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public SnapshotDto setStatus(String status) {
        this.status = status;
        return this;
    }

    @CheckForNull
    public Integer getPurgeStatus() {
        return this.purgeStatus;
    }

    public SnapshotDto setPurgeStatus(@Nullable Integer purgeStatus) {
        this.purgeStatus = purgeStatus;
        return this;
    }

    public Boolean getLast() {
        return this.last;
    }

    public SnapshotDto setLast(Boolean last) {
        this.last = last;
        return this;
    }

    @CheckForNull
    public String getVersion() {
        return this.version;
    }

    public SnapshotDto setVersion(@Nullable String version) {
        if (version != null) {
            Preconditions.checkArgument((version.length() <= 100 ? 1 : 0) != 0, (String)"Event name length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{version.length(), 100, version});
        }
        this.version = version;
        return this;
    }

    private void setRawVersion(@Nullable String version) {
        this.version = version;
    }

    public SnapshotDto setPeriodMode(@Nullable String p) {
        this.periodMode = p;
        return this;
    }

    @CheckForNull
    public String getPeriodMode() {
        return this.periodMode;
    }

    public SnapshotDto setPeriodParam(@Nullable String p) {
        this.periodParam = p;
        return this;
    }

    @CheckForNull
    public String getPeriodModeParameter() {
        return this.periodParam;
    }

    public SnapshotDto setPeriodDate(@Nullable Long date) {
        this.periodDate = date;
        return this;
    }

    @CheckForNull
    public Long getPeriodDate() {
        return this.periodDate;
    }

    public SnapshotDto setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotDto that = (SnapshotDto)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.componentUuid, that.componentUuid) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.buildDate, that.buildDate) && Objects.equals(this.status, that.status) && Objects.equals(this.purgeStatus, that.purgeStatus) && Objects.equals(this.last, that.last) && Objects.equals(this.version, that.version) && Objects.equals(this.periodMode, that.periodMode) && Objects.equals(this.periodParam, that.periodParam) && Objects.equals(this.periodDate, that.periodDate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uuid, this.componentUuid, this.createdAt, this.buildDate, this.status, this.purgeStatus, this.last, this.version, this.periodMode, this.periodParam, this.periodDate);
    }

    public String toString() {
        return "SnapshotDto{id=" + this.id + ", uuid='" + this.uuid + '\'' + ", componentUuid='" + this.componentUuid + '\'' + ", createdAt=" + this.createdAt + ", buildDate=" + this.buildDate + ", status='" + this.status + '\'' + ", purgeStatus=" + this.purgeStatus + ", last=" + this.last + ", version='" + this.version + '\'' + ", periodMode='" + this.periodMode + '\'' + ", periodParam='" + this.periodParam + '\'' + ", periodDate=" + this.periodDate + '}';
    }
}

