/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.es;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.db.es.EsQueueMapper;

public class EsQueueDao
implements Dao {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public EsQueueDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    public EsQueueDto insert(DbSession dbSession, EsQueueDto item) {
        this.insert(dbSession, Collections.singletonList(item));
        return item;
    }

    public Collection<EsQueueDto> insert(DbSession dbSession, Collection<EsQueueDto> items) {
        long now = this.system2.now();
        EsQueueMapper mapper = EsQueueDao.mapper(dbSession);
        items.forEach(item -> {
            item.setUuid(this.uuidFactory.create());
            mapper.insert((EsQueueDto)item, now);
        });
        return items;
    }

    public void delete(DbSession dbSession, EsQueueDto item) {
        this.delete(dbSession, Collections.singletonList(item));
    }

    public void delete(DbSession dbSession, Collection<EsQueueDto> items) {
        EsQueueMapper mapper = EsQueueDao.mapper(dbSession);
        List uuids = (List)items.stream().map(EsQueueDto::getUuid).filter(Objects::nonNull).collect(MoreCollectors.toArrayList((int)items.size()));
        DatabaseUtils.executeLargeUpdates((Collection)uuids, mapper::delete);
    }

    public Collection<EsQueueDto> selectForRecovery(DbSession dbSession, long beforeDate, long limit) {
        return EsQueueDao.mapper(dbSession).selectForRecovery(beforeDate, limit);
    }

    private static EsQueueMapper mapper(DbSession dbSession) {
        return (EsQueueMapper)dbSession.getMapper(EsQueueMapper.class);
    }
}

