/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.es;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;

public class RuleExtensionId {
    private final int ruleId;
    private final String organizationUuid;
    private final String id;
    private static final Splitter ID_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"|"));

    public RuleExtensionId(String organizationUuid, int ruleId) {
        this.organizationUuid = organizationUuid;
        this.ruleId = ruleId;
        this.id = String.format("%s|%s", ruleId, organizationUuid);
    }

    public RuleExtensionId(String ruleExtensionId) {
        List splittedId = ID_SPLITTER.splitToList((CharSequence)ruleExtensionId);
        Preconditions.checkArgument((splittedId.size() == 2 ? 1 : 0) != 0, (String)"Incorrect Id %s", (Object[])new Object[]{ruleExtensionId});
        this.id = ruleExtensionId;
        this.ruleId = Integer.parseInt((String)splittedId.get(0));
        this.organizationUuid = (String)splittedId.get(1);
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleExtensionId)) {
            return false;
        }
        RuleExtensionId that = (RuleExtensionId)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

