/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.event;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.event.EventDto;
import org.sonar.db.event.EventMapper;

public class EventDao
implements Dao {
    public Optional<EventDto> selectByUuid(DbSession dbSession, String uuid) {
        return Optional.ofNullable(EventDao.mapper(dbSession).selectByUuid(uuid));
    }

    public List<EventDto> selectByComponentUuid(DbSession session, String componentUuid) {
        return ((EventMapper)session.getMapper(EventMapper.class)).selectByComponentUuid(componentUuid);
    }

    public List<EventDto> selectByAnalysisUuid(DbSession dbSession, String uuid) {
        return EventDao.mapper(dbSession).selectByAnalysisUuid(uuid);
    }

    public List<EventDto> selectByAnalysisUuids(DbSession dbSession, List<String> analyses) {
        return DatabaseUtils.executeLargeInputs(analyses, EventDao.mapper(dbSession)::selectByAnalysisUuids);
    }

    public EventDto insert(DbSession session, EventDto dto) {
        ((EventMapper)session.getMapper(EventMapper.class)).insert(dto);
        return dto;
    }

    public void update(DbSession dbSession, String uuid, @Nullable String name, @Nullable String description) {
        EventDao.mapper(dbSession).update(uuid, name, description);
    }

    public void delete(DbSession session, Long id) {
        EventDao.mapper(session).deleteById(id);
    }

    public void delete(DbSession session, String uuid) {
        EventDao.mapper(session).deleteByUuid(uuid);
    }

    private static EventMapper mapper(DbSession session) {
        return (EventMapper)session.getMapper(EventMapper.class);
    }
}

