/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.issue;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.db.Dao;
import org.sonar.db.DaoUtils;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.RowNotFoundException;
import org.sonar.db.WildcardPosition;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.issue.IssueGroupDto;
import org.sonar.db.issue.IssueMapper;
import org.sonar.db.issue.ShortBranchIssueDto;

public class IssueDao
implements Dao {
    public Optional<IssueDto> selectByKey(DbSession session, String key) {
        return Optional.ofNullable(IssueDao.mapper(session).selectByKey(key));
    }

    public IssueDto selectOrFailByKey(DbSession session, String key) {
        Optional<IssueDto> issue = this.selectByKey(session, key);
        if (!issue.isPresent()) {
            throw new RowNotFoundException(String.format("Issue with key '%s' does not exist", key));
        }
        return issue.get();
    }

    public List<IssueDto> selectByKeys(DbSession session, Collection<String> keys) {
        return DatabaseUtils.executeLargeInputs(keys, IssueDao.mapper(session)::selectByKeys);
    }

    public Set<String> selectComponentUuidsOfOpenIssuesForProjectUuid(DbSession session, String projectUuid) {
        return IssueDao.mapper(session).selectComponentUuidsOfOpenIssuesForProjectUuid(projectUuid);
    }

    public List<IssueDto> selectNonClosedByComponentUuidExcludingExternals(DbSession dbSession, String componentUuid) {
        return IssueDao.mapper(dbSession).selectNonClosedByComponentUuidExcludingExternals(componentUuid);
    }

    public List<IssueDto> selectNonClosedByModuleOrProjectExcludingExternals(DbSession dbSession, ComponentDto module) {
        String likeModuleUuidPath = DaoUtils.buildLikeValue(module.moduleUuidPath(), WildcardPosition.AFTER);
        return IssueDao.mapper(dbSession).selectNonClosedByModuleOrProject(module.projectUuid(), likeModuleUuidPath);
    }

    public List<ShortBranchIssueDto> selectOpenByComponentUuids(DbSession dbSession, Collection<String> componentUuids) {
        return DatabaseUtils.executeLargeInputs(componentUuids, IssueDao.mapper(dbSession)::selectOpenByComponentUuids);
    }

    public Collection<IssueGroupDto> selectIssueGroupsByBaseComponent(DbSession dbSession, ComponentDto baseComponent, long leakPeriodBeginningDate) {
        return IssueDao.mapper(dbSession).selectIssueGroupsByBaseComponent(baseComponent, leakPeriodBeginningDate);
    }

    public void insert(DbSession session, IssueDto dto) {
        IssueDao.mapper(session).insert(dto);
    }

    public void insert(DbSession session, IssueDto dto, IssueDto ... others) {
        IssueMapper mapper = IssueDao.mapper(session);
        mapper.insert(dto);
        for (IssueDto other : others) {
            mapper.insert(other);
        }
    }

    public void update(DbSession session, IssueDto dto) {
        IssueDao.mapper(session).update(dto);
    }

    private static IssueMapper mapper(DbSession session) {
        return (IssueMapper)session.getMapper(IssueMapper.class);
    }
}

