/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.issue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Date;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.Uuids;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;

public class IssueTesting {
    private IssueTesting() {
    }

    public static IssueDto newIssue(RuleDefinitionDto rule, ComponentDto project, ComponentDto file) {
        Preconditions.checkArgument((boolean)project.qualifier().equals("TRK"));
        Preconditions.checkArgument((boolean)file.projectUuid().equals(project.uuid()));
        return new IssueDto().setKee("uuid_" + RandomStringUtils.randomAlphabetic((int)5)).setRule(rule).setType(RuleType.values()[RandomUtils.nextInt((int)RuleType.values().length)]).setProject(project).setComponent(file).setStatus("OPEN").setResolution(null).setSeverity((String)Severity.ALL.get(RandomUtils.nextInt((int)Severity.ALL.size()))).setEffort(Long.valueOf(RandomUtils.nextInt((int)10))).setAssigneeUuid("assignee-uuid_" + RandomStringUtils.randomAlphabetic((int)26)).setAuthorLogin("author_" + RandomStringUtils.randomAlphabetic((int)5)).setLine(RandomUtils.nextInt((int)1000) + 1).setMessage("message_" + RandomStringUtils.randomAlphabetic((int)5)).setChecksum("checksum_" + RandomStringUtils.randomAlphabetic((int)5)).setTags(Sets.newHashSet((Object[])new String[]{"tag_" + RandomStringUtils.randomAlphanumeric((int)5), "tag_" + RandomStringUtils.randomAlphanumeric((int)5)})).setIssueCreationDate(new Date(System.currentTimeMillis() - 2000L)).setIssueUpdateDate(new Date(System.currentTimeMillis() - 1500L)).setCreatedAt(System.currentTimeMillis() - 1000L).setUpdatedAt(System.currentTimeMillis() - 500L);
    }

    public static IssueChangeDto newIssuechangeDto(IssueDto issue) {
        return new IssueChangeDto().setKey("uuid_" + RandomStringUtils.randomAlphabetic((int)10)).setIssueKey(issue.getKey()).setChangeData("data_" + RandomStringUtils.randomAlphanumeric((int)40)).setChangeType("diff").setUserUuid("userUuid_" + RandomStringUtils.randomAlphanumeric((int)40)).setIssueChangeCreationDate(RandomUtils.nextLong()).setCreatedAt(RandomUtils.nextLong()).setUpdatedAt(RandomUtils.nextLong());
    }

    @Deprecated
    public static IssueDto newDto(RuleDto rule, ComponentDto file, ComponentDto project) {
        return new IssueDto().setKee(Uuids.createFast()).setRule(rule.getDefinition()).setType(RuleType.CODE_SMELL).setComponent(file).setProject(project).setStatus("OPEN").setResolution(null).setSeverity("MAJOR").setEffort(10L).setIssueCreationDate(DateUtils.parseDate((String)"2014-09-04")).setIssueUpdateDate(DateUtils.parseDate((String)"2014-12-04")).setCreatedAt(1400000000000L).setUpdatedAt(1400000000000L);
    }
}

