/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.mapping;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.mapping.ProjectMappingDto;
import org.sonar.db.mapping.ProjectMappingsMapper;

public class ProjectMappingsDao
implements Dao {
    public static final String BITBUCKETCLOUD_REPO_MAPPING = "bitbucketcloud.repo";
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public ProjectMappingsDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    public void put(DbSession dbSession, String keyType, String key, String projectUuid) {
        ProjectMappingsDao.checkKeyType(keyType);
        ProjectMappingsDao.checkKey(key);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)projectUuid), (Object)"projectUuid can't be null nor empty");
        ProjectMappingsMapper mapper = ProjectMappingsDao.getMapper(dbSession);
        mapper.deleteByKey(keyType, key);
        long now = this.system2.now();
        mapper.put(this.uuidFactory.create(), keyType, key, projectUuid, now);
    }

    public Optional<ProjectMappingDto> get(DbSession dbSession, String keyType, String key) {
        ProjectMappingsDao.checkKeyType(keyType);
        ProjectMappingsDao.checkKey(key);
        ProjectMappingsMapper mapper = ProjectMappingsDao.getMapper(dbSession);
        return Optional.ofNullable(mapper.selectByKey(keyType, key));
    }

    public void clear(DbSession dbSession, String keyType, String key) {
        ProjectMappingsDao.checkKeyType(keyType);
        ProjectMappingsDao.checkKey(key);
        ProjectMappingsMapper mapper = ProjectMappingsDao.getMapper(dbSession);
        mapper.deleteByKey(keyType, key);
    }

    private static void checkKeyType(@Nullable String keyType) {
        Preconditions.checkArgument((keyType != null && !keyType.isEmpty() ? 1 : 0) != 0, (Object)"key type can't be null nor empty");
    }

    private static void checkKey(@Nullable String key) {
        Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"key can't be null nor empty");
    }

    private static ProjectMappingsMapper getMapper(DbSession dbSession) {
        return (ProjectMappingsMapper)dbSession.getMapper(ProjectMappingsMapper.class);
    }
}

