/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.metric;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.db.metric.MetricValidator;

public class MetricDto {
    private Integer id;
    private String kee;
    private String shortName;
    private String valueType;
    private String description;
    private String domain;
    private int direction;
    private boolean qualitative;
    private boolean userManaged;
    private Double worstValue;
    private Double bestValue;
    private boolean optimizedBestValue;
    private boolean hidden;
    private boolean deleteHistoricalData;
    private boolean enabled;
    private Integer decimalScale;

    public Integer getId() {
        return this.id;
    }

    public MetricDto setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getKey() {
        return this.kee;
    }

    public MetricDto setKey(String key) {
        this.kee = MetricValidator.checkMetricKey(key);
        return this;
    }

    public String getShortName() {
        return this.shortName;
    }

    public MetricDto setShortName(String shortName) {
        this.shortName = MetricValidator.checkMetricName(shortName);
        return this;
    }

    public String getValueType() {
        return this.valueType;
    }

    public MetricDto setValueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public MetricDto setDescription(@Nullable String description) {
        this.description = MetricValidator.checkMetricDescription(description);
        return this;
    }

    @CheckForNull
    public String getDomain() {
        return this.domain;
    }

    public MetricDto setDomain(@Nullable String domain) {
        this.domain = MetricValidator.checkMetricDomain(domain);
        return this;
    }

    public int getDirection() {
        return this.direction;
    }

    public MetricDto setDirection(int direction) {
        this.direction = direction;
        return this;
    }

    public boolean isQualitative() {
        return this.qualitative;
    }

    public MetricDto setQualitative(boolean qualitative) {
        this.qualitative = qualitative;
        return this;
    }

    public boolean isUserManaged() {
        return this.userManaged;
    }

    public MetricDto setUserManaged(boolean userManaged) {
        this.userManaged = userManaged;
        return this;
    }

    @CheckForNull
    public Double getWorstValue() {
        return this.worstValue;
    }

    public MetricDto setWorstValue(@Nullable Double worstValue) {
        this.worstValue = worstValue;
        return this;
    }

    @CheckForNull
    public Double getBestValue() {
        return this.bestValue;
    }

    public MetricDto setBestValue(@Nullable Double bestValue) {
        this.bestValue = bestValue;
        return this;
    }

    public boolean isOptimizedBestValue() {
        return this.optimizedBestValue;
    }

    public MetricDto setOptimizedBestValue(boolean optimizedBestValue) {
        this.optimizedBestValue = optimizedBestValue;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public MetricDto setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public boolean isDeleteHistoricalData() {
        return this.deleteHistoricalData;
    }

    public MetricDto setDeleteHistoricalData(boolean deleteHistoricalData) {
        this.deleteHistoricalData = deleteHistoricalData;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MetricDto setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @CheckForNull
    public Integer getDecimalScale() {
        return this.decimalScale;
    }

    public MetricDto setDecimalScale(@Nullable Integer i) {
        this.decimalScale = i;
        return this;
    }

    public boolean isDataType() {
        return Metric.ValueType.DATA.name().equals(this.valueType) || Metric.ValueType.DISTRIB.name().equals(this.valueType) || Metric.ValueType.STRING.name().equals(this.valueType);
    }
}

