/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.organization;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.util.stream.MoreCollectors;

public class OrganizationQuery {
    private static final OrganizationQuery NO_QUERY = OrganizationQuery.newOrganizationQueryBuilder().build();
    private final Set<String> keys;
    private final Integer userId;

    private OrganizationQuery(Builder builder) {
        this.keys = builder.keys;
        this.userId = builder.member;
    }

    @CheckForNull
    public Set<String> getKeys() {
        return this.keys;
    }

    @CheckForNull
    public Integer getMember() {
        return this.userId;
    }

    public static OrganizationQuery returnAll() {
        return NO_QUERY;
    }

    public static Builder newOrganizationQueryBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> keys;
        private Integer member;

        private Builder() {
        }

        public Builder setKeys(@Nullable Collection<String> keys) {
            if (keys != null && !keys.isEmpty()) {
                this.keys = (Set)keys.stream().filter(Objects::nonNull).collect(MoreCollectors.toSet((int)keys.size()));
            }
            return this;
        }

        public Builder setMember(@Nullable Integer userId) {
            this.member = userId;
            return this;
        }

        public OrganizationQuery build() {
            return new OrganizationQuery(this);
        }
    }
}

