/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.permission;

import java.util.Arrays;
import java.util.stream.Stream;

public enum OrganizationPermission {
    ADMINISTER("admin"),
    ADMINISTER_QUALITY_GATES("gateadmin"),
    ADMINISTER_QUALITY_PROFILES("profileadmin"),
    PROVISION_PROJECTS("provisioning"),
    SCAN("scan");

    private final String key;

    private OrganizationPermission(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.key;
    }

    public static OrganizationPermission fromKey(String key) {
        for (OrganizationPermission p : OrganizationPermission.values()) {
            if (!p.getKey().equals(key)) continue;
            return p;
        }
        throw new IllegalArgumentException("Unsupported permission: " + key);
    }

    public static Stream<OrganizationPermission> all() {
        return Arrays.stream(OrganizationPermission.values());
    }
}

