/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.permission;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.Paging;
import org.sonar.db.DaoUtils;
import org.sonar.db.WildcardPosition;

@Immutable
public class PermissionQuery {
    public static final int RESULTS_MAX_SIZE = 100;
    public static final int SEARCH_QUERY_MIN_LENGTH = 3;
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final int DEFAULT_PAGE_INDEX = 1;
    private final String organizationUuid;
    private final String permission;
    private final String componentUuid;
    private final String template;
    private final String searchQuery;
    private final String searchQueryToSql;
    private final String searchQueryToSqlLowercase;
    private final boolean withAtLeastOnePermission;
    private final int pageSize;
    private final int pageOffset;

    private PermissionQuery(Builder builder) {
        this.organizationUuid = builder.organizationUuid;
        this.permission = builder.permission;
        this.withAtLeastOnePermission = builder.withAtLeastOnePermission;
        this.componentUuid = builder.componentUuid;
        this.template = builder.template;
        this.searchQuery = builder.searchQuery;
        this.searchQueryToSql = builder.searchQuery == null ? null : DaoUtils.buildLikeValue(builder.searchQuery, WildcardPosition.BEFORE_AND_AFTER);
        this.searchQueryToSqlLowercase = this.searchQueryToSql == null ? null : this.searchQueryToSql.toLowerCase(Locale.ENGLISH);
        this.pageSize = builder.pageSize;
        this.pageOffset = Paging.offset((int)builder.pageIndex, (int)builder.pageSize);
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    @CheckForNull
    public String getPermission() {
        return this.permission;
    }

    public boolean withAtLeastOnePermission() {
        return this.withAtLeastOnePermission;
    }

    @Deprecated
    public String template() {
        return this.template;
    }

    @CheckForNull
    public String getComponentUuid() {
        return this.componentUuid;
    }

    @CheckForNull
    public String getSearchQuery() {
        return this.searchQuery;
    }

    @CheckForNull
    public String getSearchQueryToSql() {
        return this.searchQueryToSql;
    }

    @CheckForNull
    public String getSearchQueryToSqlLowercase() {
        return this.searchQueryToSqlLowercase;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String permission;
        private String organizationUuid;
        private String componentUuid;
        private String template;
        private String searchQuery;
        private boolean withAtLeastOnePermission;
        private Integer pageIndex;
        private Integer pageSize;

        private Builder() {
        }

        public Builder setPermission(@Nullable String permission) {
            this.withAtLeastOnePermission = permission != null;
            this.permission = permission;
            return this;
        }

        public Builder setTemplate(@Nullable String template) {
            this.template = template;
            return this;
        }

        public Builder setComponentUuid(@Nullable String componentUuid) {
            this.componentUuid = componentUuid;
            return this;
        }

        public Builder setOrganizationUuid(String organizationUuid) {
            this.organizationUuid = organizationUuid;
            return this;
        }

        public Builder setSearchQuery(@Nullable String s) {
            this.searchQuery = StringUtils.defaultIfBlank((String)s, null);
            return this;
        }

        public Builder setPageIndex(@Nullable Integer i) {
            this.pageIndex = i;
            return this;
        }

        public Builder setPageSize(@Nullable Integer i) {
            this.pageSize = i;
            return this;
        }

        public Builder withAtLeastOnePermission() {
            this.withAtLeastOnePermission = true;
            return this;
        }

        public PermissionQuery build() {
            Objects.requireNonNull(this.organizationUuid, "Organization UUID cannot be null");
            this.pageIndex = (Integer)MoreObjects.firstNonNull((Object)this.pageIndex, (Object)1);
            this.pageSize = (Integer)MoreObjects.firstNonNull((Object)this.pageSize, (Object)20);
            Preconditions.checkArgument((this.searchQuery == null || this.searchQuery.length() >= 3 ? 1 : 0) != 0, (String)"Search query should contains at least %s characters", (Object[])new Object[]{3});
            return new PermissionQuery(this);
        }
    }
}

