/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.permission;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentMapper;
import org.sonar.db.permission.CountPerProjectPermission;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.db.permission.UserPermissionDto;
import org.sonar.db.permission.UserPermissionMapper;

public class UserPermissionDao
implements Dao {
    public List<UserPermissionDto> selectUserPermissionsByQuery(DbSession dbSession, PermissionQuery query, Collection<Integer> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        Preconditions.checkArgument((userIds.size() <= 1000 ? 1 : 0) != 0, (Object)"Maximum 1'000 users are accepted");
        return UserPermissionDao.mapper(dbSession).selectUserPermissionsByQueryAndUserIds(query, userIds);
    }

    public List<Integer> selectUserIdsByQuery(DbSession dbSession, PermissionQuery query) {
        return (List)UserPermissionDao.mapper(dbSession).selectUserIdsByQuery(query).stream().skip(query.getPageOffset()).limit(query.getPageSize()).collect(MoreCollectors.toList());
    }

    public int countUsersByQuery(DbSession dbSession, PermissionQuery query) {
        return UserPermissionDao.mapper(dbSession).countUsersByQuery(query);
    }

    public List<CountPerProjectPermission> countUsersByProjectPermission(DbSession dbSession, Collection<Long> projectIds) {
        return DatabaseUtils.executeLargeInputs(projectIds, UserPermissionDao.mapper(dbSession)::countUsersByProjectPermission);
    }

    public List<String> selectGlobalPermissionsOfUser(DbSession dbSession, int userId, String organizationUuid) {
        return UserPermissionDao.mapper(dbSession).selectGlobalPermissionsOfUser(userId, organizationUuid);
    }

    public List<String> selectProjectPermissionsOfUser(DbSession dbSession, int userId, long projectId) {
        return UserPermissionDao.mapper(dbSession).selectProjectPermissionsOfUser(userId, projectId);
    }

    public Set<Integer> selectUserIdsWithPermissionOnProjectBut(DbSession session, long projectId, String permission) {
        return UserPermissionDao.mapper(session).selectUserIdsWithPermissionOnProjectBut(projectId, permission);
    }

    public void insert(DbSession dbSession, UserPermissionDto dto) {
        UserPermissionDao.ensureComponentPermissionConsistency(dbSession, dto);
        UserPermissionDao.mapper(dbSession).insert(dto);
    }

    private static void ensureComponentPermissionConsistency(DbSession dbSession, UserPermissionDto dto) {
        if (dto.getComponentId() == null) {
            return;
        }
        ComponentMapper componentMapper = (ComponentMapper)dbSession.getMapper(ComponentMapper.class);
        Preconditions.checkArgument((componentMapper.countComponentByOrganizationAndId(dto.getOrganizationUuid(), dto.getComponentId()) == 1 ? 1 : 0) != 0, (String)"Can't insert permission '%s' for component with id '%s' in organization with uuid '%s' because this component does not belong to organization with uuid '%s'", (Object[])new Object[]{dto.getPermission(), dto.getComponentId(), dto.getOrganizationUuid(), dto.getOrganizationUuid()});
    }

    public void deleteGlobalPermission(DbSession dbSession, int userId, String permission, String organizationUuid) {
        UserPermissionDao.mapper(dbSession).deleteGlobalPermission(userId, permission, organizationUuid);
    }

    public void deleteProjectPermission(DbSession dbSession, int userId, String permission, long projectId) {
        UserPermissionDao.mapper(dbSession).deleteProjectPermission(userId, permission, projectId);
    }

    public void deleteProjectPermissions(DbSession dbSession, long projectId) {
        UserPermissionDao.mapper(dbSession).deleteProjectPermissions(projectId);
    }

    public int deleteProjectPermissionOfAnyUser(DbSession dbSession, long projectId, String permission) {
        return UserPermissionDao.mapper(dbSession).deleteProjectPermissionOfAnyUser(projectId, permission);
    }

    public void deleteByOrganization(DbSession dbSession, String organizationUuid) {
        UserPermissionDao.mapper(dbSession).deleteByOrganization(organizationUuid);
    }

    public void deleteOrganizationMemberPermissions(DbSession dbSession, String organizationUuid, int userId) {
        UserPermissionDao.mapper(dbSession).deleteOrganizationMemberPermissions(organizationUuid, userId);
    }

    public void deleteByUserId(DbSession dbSession, int userId) {
        UserPermissionDao.mapper(dbSession).deleteByUserId(userId);
    }

    private static UserPermissionMapper mapper(DbSession dbSession) {
        return (UserPermissionMapper)dbSession.getMapper(UserPermissionMapper.class);
    }
}

