/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.System2;
import org.sonar.db.purge.IdUuidPair;

public class PurgeConfiguration {
    private final IdUuidPair rootProjectIdUuid;
    private final Collection<String> scopesWithoutHistoricalData;
    private final int maxAgeInDaysOfClosedIssues;
    private final Optional<Integer> maxAgeInDaysOfInactiveShortLivingBranches;
    private final System2 system2;
    private final Collection<String> disabledComponentUuids;

    public PurgeConfiguration(IdUuidPair rootProjectId, Collection<String> scopesWithoutHistoricalData, int maxAgeInDaysOfClosedIssues, Optional<Integer> maxAgeInDaysOfInactiveShortLivingBranches, System2 system2, Collection<String> disabledComponentUuids) {
        this.rootProjectIdUuid = rootProjectId;
        this.scopesWithoutHistoricalData = scopesWithoutHistoricalData;
        this.maxAgeInDaysOfClosedIssues = maxAgeInDaysOfClosedIssues;
        this.system2 = system2;
        this.disabledComponentUuids = disabledComponentUuids;
        this.maxAgeInDaysOfInactiveShortLivingBranches = maxAgeInDaysOfInactiveShortLivingBranches;
    }

    public static PurgeConfiguration newDefaultPurgeConfiguration(Configuration config, IdUuidPair rootId, Collection<String> disabledComponentUuids) {
        List<String> scopes = Collections.singletonList("FIL");
        if (config.getBoolean("sonar.dbcleaner.cleanDirectory").orElse(false).booleanValue()) {
            scopes = Arrays.asList("DIR", "FIL");
        }
        return new PurgeConfiguration(rootId, scopes, (Integer)config.getInt("sonar.dbcleaner.daysBeforeDeletingClosedIssues").get(), config.getInt("sonar.dbcleaner.daysBeforeDeletingInactiveShortLivingBranches"), System2.INSTANCE, disabledComponentUuids);
    }

    public IdUuidPair rootProjectIdUuid() {
        return this.rootProjectIdUuid;
    }

    public Collection<String> getScopesWithoutHistoricalData() {
        return this.scopesWithoutHistoricalData;
    }

    public Collection<String> getDisabledComponentUuids() {
        return this.disabledComponentUuids;
    }

    @CheckForNull
    public Date maxLiveDateOfClosedIssues() {
        return this.maxLiveDateOfClosedIssues(new Date(this.system2.now()));
    }

    public Optional<Date> maxLiveDateOfInactiveShortLivingBranches() {
        return this.maxAgeInDaysOfInactiveShortLivingBranches.map(age -> DateUtils.addDays((Date)new Date(this.system2.now()), (int)(-age.intValue())));
    }

    @CheckForNull
    @VisibleForTesting
    Date maxLiveDateOfClosedIssues(Date now) {
        if (this.maxAgeInDaysOfClosedIssues > 0) {
            return DateUtils.addDays((Date)now, (int)(-this.maxAgeInDaysOfClosedIssues));
        }
        return null;
    }
}

