/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchMapper;
import org.sonar.db.component.ComponentDao;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentTreeQuery;
import org.sonar.db.purge.IdUuidPair;
import org.sonar.db.purge.PurgeCommands;
import org.sonar.db.purge.PurgeConfiguration;
import org.sonar.db.purge.PurgeListener;
import org.sonar.db.purge.PurgeMapper;
import org.sonar.db.purge.PurgeProfiler;
import org.sonar.db.purge.PurgeSnapshotQuery;
import org.sonar.db.purge.PurgeableAnalysisDto;

public class PurgeDao
implements Dao {
    private static final Logger LOG = Loggers.get(PurgeDao.class);
    private static final String[] UNPROCESSED_STATUS = new String[]{"U"};
    private static final ImmutableSet<String> QUALIFIERS_PROJECT_VIEW = ImmutableSet.of((Object)"TRK", (Object)"VW");
    private static final ImmutableSet<String> QUALIFIERS_MODULE_SUBVIEW = ImmutableSet.of((Object)"BRC", (Object)"SVW");
    private static final String SCOPE_PROJECT = "PRJ";
    private final ComponentDao componentDao;
    private final System2 system2;

    public PurgeDao(ComponentDao componentDao, System2 system2) {
        this.componentDao = componentDao;
        this.system2 = system2;
    }

    public void purge(DbSession session, PurgeConfiguration conf, PurgeListener listener, PurgeProfiler profiler) {
        PurgeMapper mapper = (PurgeMapper)session.getMapper(PurgeMapper.class);
        PurgeCommands commands = new PurgeCommands(session, mapper, profiler);
        String rootUuid = conf.rootProjectIdUuid().getUuid();
        PurgeDao.deleteAbortedAnalyses(rootUuid, commands);
        this.deleteDataOfComponentsWithoutHistoricalData(session, rootUuid, conf.getScopesWithoutHistoricalData(), commands);
        PurgeDao.purgeAnalyses(commands, rootUuid);
        this.purgeDisabledComponents(session, conf, listener);
        PurgeDao.deleteOldClosedIssues(conf, mapper, listener);
        PurgeDao.purgeStaleBranches(commands, conf, mapper, rootUuid);
    }

    private static void purgeStaleBranches(PurgeCommands commands, PurgeConfiguration conf, PurgeMapper mapper, String rootUuid) {
        Optional<Date> maxDate = conf.maxLiveDateOfInactiveShortLivingBranches();
        if (!maxDate.isPresent()) {
            return;
        }
        LOG.debug("<- Purge stale branches");
        List<String> branchUuids = mapper.selectStaleShortLivingBranchesAndPullRequests(rootUuid, DateUtils.dateToLong((Date)maxDate.get()));
        for (String branchUuid : branchUuids) {
            PurgeDao.deleteRootComponent(branchUuid, mapper, commands);
        }
    }

    private static void purgeAnalyses(PurgeCommands commands, String rootUuid) {
        List<IdUuidPair> analysisUuids = commands.selectSnapshotIdUuids(new PurgeSnapshotQuery().setComponentUuid(rootUuid).setIslast(false).setNotPurged(true));
        commands.purgeAnalyses(analysisUuids);
    }

    private static void deleteOldClosedIssues(PurgeConfiguration conf, PurgeMapper mapper, PurgeListener listener) {
        Date toDate = conf.maxLiveDateOfClosedIssues();
        String rootUuid = conf.rootProjectIdUuid().getUuid();
        List<String> issueKeys = mapper.selectOldClosedIssueKeys(rootUuid, DateUtils.dateToLong((Date)toDate));
        DatabaseUtils.executeLargeInputs(issueKeys, input -> {
            mapper.deleteIssueChangesFromIssueKeys((List<String>)input);
            return Collections.emptyList();
        });
        DatabaseUtils.executeLargeInputs(issueKeys, input -> {
            mapper.deleteIssuesFromKeys((List<String>)input);
            return Collections.emptyList();
        });
        listener.onIssuesRemoval(rootUuid, issueKeys);
    }

    private static void deleteAbortedAnalyses(String rootUuid, PurgeCommands commands) {
        LOG.debug("<- Delete aborted builds");
        PurgeSnapshotQuery query = new PurgeSnapshotQuery().setIslast(false).setStatus(UNPROCESSED_STATUS).setComponentUuid(rootUuid);
        commands.deleteAnalyses(query);
    }

    private void deleteDataOfComponentsWithoutHistoricalData(DbSession dbSession, String rootUuid, Collection<String> scopesWithoutHistoricalData, PurgeCommands purgeCommands) {
        if (scopesWithoutHistoricalData.isEmpty()) {
            return;
        }
        List<String> analysisUuids = purgeCommands.selectSnapshotUuids(new PurgeSnapshotQuery().setComponentUuid(rootUuid).setIslast(false).setNotPurged(true));
        List componentWithoutHistoricalDataUuids = (List)this.componentDao.selectDescendants(dbSession, ComponentTreeQuery.builder().setBaseUuid(rootUuid).setScopes(scopesWithoutHistoricalData).setStrategy(ComponentTreeQuery.Strategy.LEAVES).build()).stream().map(ComponentDto::uuid).collect(MoreCollectors.toList());
        purgeCommands.deleteComponentMeasures(analysisUuids, componentWithoutHistoricalDataUuids);
    }

    private void purgeDisabledComponents(DbSession session, PurgeConfiguration conf, PurgeListener listener) {
        PurgeMapper mapper = PurgeDao.mapper(session);
        DatabaseUtils.executeLargeInputs(conf.getDisabledComponentUuids(), input -> {
            mapper.deleteFileSourcesByFileUuid((List<String>)input);
            mapper.resolveComponentIssuesNotAlreadyResolved((List<String>)input, this.system2.now());
            return Collections.emptyList();
        });
        listener.onComponentsDisabling(conf.rootProjectIdUuid().getUuid(), conf.getDisabledComponentUuids());
        session.commit();
    }

    public List<PurgeableAnalysisDto> selectPurgeableAnalyses(String componentUuid, DbSession session) {
        ArrayList result = Lists.newArrayList();
        result.addAll(PurgeDao.mapper(session).selectPurgeableAnalysesWithEvents(componentUuid));
        result.addAll(PurgeDao.mapper(session).selectPurgeableAnalysesWithoutEvents(componentUuid));
        Collections.sort(result);
        return result;
    }

    public void deleteBranch(DbSession session, String uuid) {
        PurgeProfiler profiler = new PurgeProfiler();
        PurgeMapper purgeMapper = PurgeDao.mapper(session);
        PurgeCommands purgeCommands = new PurgeCommands(session, profiler);
        PurgeDao.deleteRootComponent(uuid, purgeMapper, purgeCommands);
    }

    public void deleteProject(DbSession session, String uuid) {
        PurgeProfiler profiler = new PurgeProfiler();
        PurgeMapper purgeMapper = PurgeDao.mapper(session);
        PurgeCommands purgeCommands = new PurgeCommands(session, profiler);
        ((BranchMapper)session.getMapper(BranchMapper.class)).selectByProjectUuid(uuid).stream().filter(branch -> !uuid.equals(branch.getUuid())).forEach(branch -> PurgeDao.deleteRootComponent(branch.getUuid(), purgeMapper, purgeCommands));
        PurgeDao.deleteRootComponent(uuid, purgeMapper, purgeCommands);
    }

    private static void deleteRootComponent(String rootUuid, PurgeMapper mapper, PurgeCommands commands) {
        List<IdUuidPair> rootAndModulesOrSubviews = mapper.selectRootAndModulesOrSubviewsByProjectUuid(rootUuid);
        long rootId = rootAndModulesOrSubviews.stream().filter(pair -> pair.getUuid().equals(rootUuid)).map(IdUuidPair::getId).findFirst().orElseThrow(() -> new IllegalArgumentException("Couldn't find root component with uuid " + rootUuid));
        commands.deletePermissions(rootId);
        commands.deleteLinks(rootUuid);
        commands.deleteAnalyses(rootUuid);
        commands.deleteByRootAndModulesOrSubviews(rootAndModulesOrSubviews);
        commands.deleteComponents(rootUuid);
        commands.deleteIssues(rootUuid);
        commands.deleteFileSources(rootUuid);
        commands.deleteCeActivity(rootUuid);
        commands.deleteCeQueue(rootUuid);
        commands.deleteWebhookDeliveries(rootUuid);
        commands.deleteProjectMappings(rootUuid);
        commands.deleteBranch(rootUuid);
        commands.deleteLiveMeasures(rootUuid);
    }

    public void deleteNonRootComponentsInView(DbSession dbSession, Collection<ComponentDto> components) {
        Set nonRootComponents = (Set)components.stream().filter(PurgeDao::isNotRoot).collect(MoreCollectors.toSet());
        if (nonRootComponents.isEmpty()) {
            return;
        }
        PurgeProfiler profiler = new PurgeProfiler();
        PurgeCommands purgeCommands = new PurgeCommands(dbSession, profiler);
        PurgeDao.deleteNonRootComponentsInView(nonRootComponents, purgeCommands);
    }

    private static void deleteNonRootComponentsInView(Set<ComponentDto> nonRootComponents, PurgeCommands purgeCommands) {
        List subviewsOrProjectCopies = (List)nonRootComponents.stream().filter(PurgeDao::isModuleOrSubview).map(PurgeDao::toIdUuidPair).collect(MoreCollectors.toList());
        purgeCommands.deleteByRootAndModulesOrSubviews(subviewsOrProjectCopies);
        List nonRootComponentUuids = (List)nonRootComponents.stream().map(ComponentDto::uuid).collect(MoreCollectors.toList((int)nonRootComponents.size()));
        purgeCommands.deleteComponentMeasures(nonRootComponentUuids);
        purgeCommands.deleteComponents(nonRootComponentUuids);
    }

    private static boolean isNotRoot(ComponentDto dto) {
        return !SCOPE_PROJECT.equals(dto.scope()) || !QUALIFIERS_PROJECT_VIEW.contains((Object)dto.qualifier());
    }

    private static boolean isModuleOrSubview(ComponentDto dto) {
        return SCOPE_PROJECT.equals(dto.scope()) && QUALIFIERS_MODULE_SUBVIEW.contains((Object)dto.qualifier());
    }

    private static IdUuidPair toIdUuidPair(ComponentDto dto) {
        return new IdUuidPair(dto.getId(), dto.uuid());
    }

    public void deleteAnalyses(DbSession session, PurgeProfiler profiler, List<IdUuidPair> analysisIdUuids) {
        new PurgeCommands(session, profiler).deleteAnalyses(analysisIdUuids);
    }

    private static PurgeMapper mapper(DbSession session) {
        return (PurgeMapper)session.getMapper(PurgeMapper.class);
    }
}

