/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge.period;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbSession;
import org.sonar.db.purge.IdUuidPair;
import org.sonar.db.purge.PurgeDao;
import org.sonar.db.purge.PurgeProfiler;
import org.sonar.db.purge.PurgeableAnalysisDto;
import org.sonar.db.purge.period.Filter;
import org.sonar.db.purge.period.Filters;

public class DefaultPeriodCleaner {
    private static final Logger LOG = Loggers.get(DefaultPeriodCleaner.class);
    private final PurgeDao purgeDao;
    private final PurgeProfiler profiler;

    public DefaultPeriodCleaner(PurgeDao purgeDao, PurgeProfiler profiler) {
        this.purgeDao = purgeDao;
        this.profiler = profiler;
    }

    public void clean(DbSession session, String rootUuid, Configuration config) {
        this.doClean(rootUuid, new Filters(config).all(), session);
    }

    @VisibleForTesting
    void doClean(String rootUuid, List<Filter> filters, DbSession session) {
        ArrayList<PurgeableAnalysisDto> history = new ArrayList<PurgeableAnalysisDto>(this.selectAnalysesOfComponent(rootUuid, session));
        for (Filter filter : filters) {
            filter.log();
            history.removeAll(this.delete(rootUuid, filter.filter(history), session));
        }
    }

    private List<PurgeableAnalysisDto> delete(String rootUuid, List<PurgeableAnalysisDto> snapshots, DbSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("<- Delete analyses of component {}: {}", (Object)rootUuid, (Object)Joiner.on((String)", ").join((Iterable)snapshots.stream().map(snapshot -> snapshot.getAnalysisUuid() + "@" + DateUtils.formatDateTime((Date)snapshot.getDate())).collect(MoreCollectors.toArrayList((int)snapshots.size()))));
        }
        this.purgeDao.deleteAnalyses(session, this.profiler, (List)snapshots.stream().map(DefaultPeriodCleaner::toIdUuidPair).collect(MoreCollectors.toList((int)snapshots.size())));
        return snapshots;
    }

    private static IdUuidPair toIdUuidPair(PurgeableAnalysisDto snapshot) {
        return new IdUuidPair(snapshot.getAnalysisId(), snapshot.getAnalysisUuid());
    }

    private List<PurgeableAnalysisDto> selectAnalysesOfComponent(String componentUuid, DbSession session) {
        return this.purgeDao.selectPurgeableAnalyses(componentUuid, session);
    }
}

