/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualitygate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;

public class QualityGateConditionDto {
    public static final String OPERATOR_EQUALS = "EQ";
    public static final String OPERATOR_NOT_EQUALS = "NE";
    public static final String OPERATOR_GREATER_THAN = "GT";
    public static final String OPERATOR_LESS_THAN = "LT";
    public static final List<String> ALL_OPERATORS = ImmutableList.of((Object)"LT", (Object)"GT", (Object)"EQ", (Object)"NE");
    private static final List<String> NUMERIC_OPERATORS = ImmutableList.of((Object)"LT", (Object)"GT", (Object)"EQ", (Object)"NE");
    private static final List<String> STRING_OPERATORS = ImmutableList.of((Object)"EQ", (Object)"NE", (Object)"LT", (Object)"GT");
    private static final List<String> LEVEL_OPERATORS = ImmutableList.of((Object)"EQ", (Object)"NE");
    private static final List<String> BOOLEAN_OPERATORS = ImmutableList.of((Object)"EQ");
    private static final List<String> RATING_OPERATORS = ImmutableList.of((Object)"GT");
    private static final Map<Metric.ValueType, List<String>> OPERATORS_BY_TYPE = ImmutableMap.builder().put((Object)Metric.ValueType.BOOL, BOOLEAN_OPERATORS).put((Object)Metric.ValueType.LEVEL, LEVEL_OPERATORS).put((Object)Metric.ValueType.STRING, STRING_OPERATORS).put((Object)Metric.ValueType.INT, NUMERIC_OPERATORS).put((Object)Metric.ValueType.FLOAT, NUMERIC_OPERATORS).put((Object)Metric.ValueType.PERCENT, NUMERIC_OPERATORS).put((Object)Metric.ValueType.MILLISEC, NUMERIC_OPERATORS).put((Object)Metric.ValueType.RATING, RATING_OPERATORS).put((Object)Metric.ValueType.WORK_DUR, NUMERIC_OPERATORS).build();
    private long id;
    private long qualityGateId;
    private long metricId;
    private String metricKey;
    private Integer period;
    private String operator;
    private String warningThreshold;
    private String errorThreshold;
    private Date createdAt;
    private Date updatedAt;

    public long getId() {
        return this.id;
    }

    public QualityGateConditionDto setId(long id) {
        this.id = id;
        return this;
    }

    public long getQualityGateId() {
        return this.qualityGateId;
    }

    public QualityGateConditionDto setQualityGateId(long qualityGateId) {
        this.qualityGateId = qualityGateId;
        return this;
    }

    public long getMetricId() {
        return this.metricId;
    }

    public QualityGateConditionDto setMetricId(long metricId) {
        this.metricId = metricId;
        return this;
    }

    @CheckForNull
    public String getMetricKey() {
        return this.metricKey;
    }

    public QualityGateConditionDto setMetricKey(@Nullable String metricKey) {
        this.metricKey = metricKey;
        return this;
    }

    @CheckForNull
    public Integer getPeriod() {
        return this.period;
    }

    public QualityGateConditionDto setPeriod(@Nullable Integer period) {
        this.period = period;
        return this;
    }

    public String getOperator() {
        return this.operator;
    }

    public QualityGateConditionDto setOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public String getWarningThreshold() {
        return this.warningThreshold;
    }

    public QualityGateConditionDto setWarningThreshold(@Nullable String warningThreshold) {
        this.warningThreshold = warningThreshold;
        return this;
    }

    public String getErrorThreshold() {
        return this.errorThreshold;
    }

    public QualityGateConditionDto setErrorThreshold(@Nullable String errorThreshold) {
        this.errorThreshold = errorThreshold;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public QualityGateConditionDto setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public QualityGateConditionDto setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public static boolean isOperatorAllowed(String operator, Metric.ValueType metricType) {
        return QualityGateConditionDto.getOperatorsForType(metricType).contains(operator);
    }

    public static Collection<String> getOperatorsForType(Metric.ValueType metricType) {
        if (OPERATORS_BY_TYPE.containsKey(metricType)) {
            return OPERATORS_BY_TYPE.get(metricType);
        }
        return Collections.emptySet();
    }
}

