/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.rule;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleQuery;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.RowNotFoundException;
import org.sonar.db.es.RuleExtensionId;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.rule.DeprecatedRuleKeyDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleExtensionForIndexingDto;
import org.sonar.db.rule.RuleForIndexingDto;
import org.sonar.db.rule.RuleMapper;
import org.sonar.db.rule.RuleMetadataDto;
import org.sonar.db.rule.RuleParamDto;

public class RuleDao
implements Dao {
    public Optional<RuleDto> selectByKey(DbSession session, OrganizationDto organization, RuleKey key) {
        RuleDto res = RuleDao.mapper(session).selectByKey(organization.getUuid(), key);
        RuleDao.ensureOrganizationIsSet(organization.getUuid(), res);
        return Optional.ofNullable(res);
    }

    public RuleDto selectOrFailByKey(DbSession session, RuleKey key) {
        RuleDefinitionDto ruleDefinitionDto = this.selectOrFailDefinitionByKey(session, key);
        return new RuleDto(ruleDefinitionDto, new RuleMetadataDto());
    }

    public Optional<RuleDefinitionDto> selectDefinitionByKey(DbSession session, RuleKey key) {
        return Optional.ofNullable(RuleDao.mapper(session).selectDefinitionByKey(key));
    }

    public Optional<RuleMetadataDto> selectMetadataByKey(DbSession session, RuleKey key, OrganizationDto organization) {
        return Optional.ofNullable(RuleDao.mapper(session).selectMetadataByKey(key, organization.getUuid()));
    }

    public RuleDto selectOrFailByKey(DbSession session, OrganizationDto organization, RuleKey key) {
        RuleDto rule = RuleDao.mapper(session).selectByKey(organization.getUuid(), key);
        if (rule == null) {
            throw new RowNotFoundException(String.format("Rule with key '%s' does not exist", key));
        }
        RuleDao.ensureOrganizationIsSet(organization.getUuid(), rule);
        return rule;
    }

    public RuleDefinitionDto selectOrFailDefinitionByKey(DbSession session, RuleKey key) {
        RuleDefinitionDto rule = RuleDao.mapper(session).selectDefinitionByKey(key);
        if (rule == null) {
            throw new RowNotFoundException(String.format("Rule with key '%s' does not exist", key));
        }
        return rule;
    }

    public Optional<RuleDto> selectById(long id, String organizationUuid, DbSession session) {
        RuleDto res = RuleDao.mapper(session).selectById(organizationUuid, id);
        RuleDao.ensureOrganizationIsSet(organizationUuid, res);
        return Optional.ofNullable(res);
    }

    public Optional<RuleDefinitionDto> selectDefinitionById(long id, DbSession session) {
        return Optional.ofNullable(RuleDao.mapper(session).selectDefinitionById(id));
    }

    public List<RuleDto> selectByIds(DbSession session, String organizationUuid, List<Integer> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return RuleDao.ensureOrganizationIsSet(organizationUuid, DatabaseUtils.executeLargeInputs(ids, chunk -> RuleDao.mapper(session).selectByIds(organizationUuid, (List<Integer>)chunk)));
    }

    public List<RuleDefinitionDto> selectDefinitionByIds(DbSession session, Collection<Integer> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return DatabaseUtils.executeLargeInputs(ids, RuleDao.mapper(session)::selectDefinitionByIds);
    }

    public List<RuleDto> selectByKeys(DbSession session, OrganizationDto organization, Collection<RuleKey> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        return RuleDao.ensureOrganizationIsSet(organization.getUuid(), DatabaseUtils.executeLargeInputs(keys, chunk -> RuleDao.mapper(session).selectByKeys(organization.getUuid(), (List<RuleKey>)chunk)));
    }

    public List<RuleDto> selectByKeys(DbSession session, String organizationUuid, Collection<RuleKey> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        return RuleDao.ensureOrganizationIsSet(organizationUuid, DatabaseUtils.executeLargeInputs(keys, chunk -> RuleDao.mapper(session).selectByKeys(organizationUuid, (List<RuleKey>)chunk)));
    }

    public List<RuleDefinitionDto> selectDefinitionByKeys(DbSession session, Collection<RuleKey> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        return DatabaseUtils.executeLargeInputs(keys, RuleDao.mapper(session)::selectDefinitionByKeys);
    }

    public void selectEnabled(DbSession session, ResultHandler<RuleDefinitionDto> resultHandler) {
        RuleDao.mapper(session).selectEnabled(resultHandler);
    }

    public List<RuleDto> selectAll(DbSession session, String organizationUuid) {
        return RuleDao.ensureOrganizationIsSet(organizationUuid, RuleDao.mapper(session).selectAll(organizationUuid));
    }

    public List<RuleDefinitionDto> selectAllDefinitions(DbSession session) {
        return RuleDao.mapper(session).selectAllDefinitions();
    }

    public List<RuleDto> selectByQuery(DbSession session, String organizationUuid, RuleQuery ruleQuery) {
        return RuleDao.ensureOrganizationIsSet(organizationUuid, RuleDao.mapper(session).selectByQuery(organizationUuid, ruleQuery));
    }

    private static void ensureOrganizationIsSet(String organizationUuid, @Nullable RuleDto res) {
        if (res != null) {
            res.setOrganizationUuid(organizationUuid);
        }
    }

    private static List<RuleDto> ensureOrganizationIsSet(String organizationUuid, List<RuleDto> res) {
        res.forEach(dto -> RuleDao.ensureOrganizationIsSet(organizationUuid, dto));
        return res;
    }

    public void insert(DbSession session, RuleDefinitionDto dto) {
        RuleDao.mapper(session).insertDefinition(dto);
    }

    public void insert(DbSession session, RuleMetadataDto dto) {
        RuleDao.mapper(session).insertMetadata(dto);
    }

    public void update(DbSession session, RuleDefinitionDto dto) {
        RuleDao.mapper(session).updateDefinition(dto);
    }

    public void insertOrUpdate(DbSession session, RuleMetadataDto dto) {
        if (RuleDao.mapper(session).countMetadata(dto) > 0) {
            RuleDao.mapper(session).updateMetadata(dto);
        } else {
            RuleDao.mapper(session).insertMetadata(dto);
        }
    }

    public void scrollIndexingRuleExtensionsByIds(DbSession dbSession, Collection<RuleExtensionId> ruleExtensionIds, Consumer<RuleExtensionForIndexingDto> consumer) {
        RuleMapper mapper = RuleDao.mapper(dbSession);
        DatabaseUtils.executeLargeInputsWithoutOutput(ruleExtensionIds, pageOfRuleExtensionIds -> mapper.selectIndexingRuleExtensionsByIds((List<RuleExtensionId>)pageOfRuleExtensionIds).forEach(consumer));
    }

    public void scrollIndexingRuleExtensions(DbSession dbSession, Consumer<RuleExtensionForIndexingDto> consumer) {
        RuleDao.mapper(dbSession).scrollIndexingRuleExtensions((ResultHandler<RuleExtensionForIndexingDto>)((ResultHandler)context -> {
            RuleExtensionForIndexingDto dto = (RuleExtensionForIndexingDto)context.getResultObject();
            consumer.accept(dto);
        }));
    }

    public void scrollIndexingRulesByKeys(DbSession dbSession, Collection<Integer> ruleIds, Consumer<RuleForIndexingDto> consumer) {
        RuleMapper mapper = RuleDao.mapper(dbSession);
        DatabaseUtils.executeLargeInputsWithoutOutput(ruleIds, pageOfRuleIds -> mapper.selectIndexingRulesByIds((List<Integer>)pageOfRuleIds).forEach(consumer));
    }

    public void scrollIndexingRules(DbSession dbSession, Consumer<RuleForIndexingDto> consumer) {
        RuleDao.mapper(dbSession).scrollIndexingRules((ResultHandler<RuleForIndexingDto>)((ResultHandler)context -> {
            RuleForIndexingDto dto = (RuleForIndexingDto)context.getResultObject();
            consumer.accept(dto);
        }));
    }

    private static RuleMapper mapper(DbSession session) {
        return (RuleMapper)session.getMapper(RuleMapper.class);
    }

    public List<RuleParamDto> selectRuleParamsByRuleKey(DbSession session, RuleKey key) {
        return RuleDao.mapper(session).selectParamsByRuleKey(key);
    }

    public List<RuleParamDto> selectRuleParamsByRuleKeys(DbSession session, Collection<RuleKey> ruleKeys) {
        return DatabaseUtils.executeLargeInputs(ruleKeys, RuleDao.mapper(session)::selectParamsByRuleKeys);
    }

    public List<RuleParamDto> selectRuleParamsByRuleIds(DbSession dbSession, Collection<Integer> ruleIds) {
        return DatabaseUtils.executeLargeInputs(ruleIds, RuleDao.mapper(dbSession)::selectParamsByRuleIds);
    }

    public void insertRuleParam(DbSession session, RuleDefinitionDto rule, RuleParamDto param) {
        Preconditions.checkNotNull((Object)rule.getId(), (Object)"Rule id must be set");
        param.setRuleId(rule.getId());
        RuleDao.mapper(session).insertParameter(param);
    }

    public RuleParamDto updateRuleParam(DbSession session, RuleDefinitionDto rule, RuleParamDto param) {
        Preconditions.checkNotNull((Object)rule.getId(), (Object)"Rule id must be set");
        Preconditions.checkNotNull((Object)param.getId(), (Object)"Rule parameter is not yet persisted must be set");
        param.setRuleId(rule.getId());
        RuleDao.mapper(session).updateParameter(param);
        return param;
    }

    public void deleteRuleParam(DbSession session, int ruleParameterId) {
        RuleDao.mapper(session).deleteParameter(ruleParameterId);
    }

    public Set<DeprecatedRuleKeyDto> selectAllDeprecatedRuleKeys(DbSession session) {
        return RuleDao.mapper(session).selectAllDeprecatedRuleKeys();
    }

    public void deleteDeprecatedRuleKeys(DbSession dbSession, Collection<String> uuids) {
        if (uuids.isEmpty()) {
            return;
        }
        DatabaseUtils.executeLargeUpdates(uuids, RuleDao.mapper(dbSession)::deleteDeprecatedRuleKeys);
    }

    public void insert(DbSession dbSession, DeprecatedRuleKeyDto deprecatedRuleKey) {
        RuleDao.mapper(dbSession).insertDeprecatedRuleKey(deprecatedRuleKey);
    }
}

