/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.rule;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.SeverityUtil;

public class RuleDefinitionDto {
    private Integer id;
    private String repositoryKey;
    private String ruleKey;
    private String description;
    private RuleDto.Format descriptionFormat;
    private RuleStatus status;
    private String name;
    private String configKey;
    private Integer severity;
    private boolean isTemplate;
    private boolean isExternal;
    private String language;
    private Integer templateId;
    private String defRemediationFunction;
    private String defRemediationGapMultiplier;
    private String defRemediationBaseEffort;
    private String gapDescription;
    private String systemTags;
    private int type;
    private RuleDto.Scope scope;
    private RuleKey key;
    private String pluginKey;
    private long createdAt;
    private long updatedAt;

    public RuleKey getKey() {
        if (this.key == null) {
            this.key = RuleKey.of((String)this.getRepositoryKey(), (String)this.getRuleKey());
        }
        return this.key;
    }

    void setKey(RuleKey key) {
        this.key = key;
    }

    public Integer getId() {
        return this.id;
    }

    public RuleDefinitionDto setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getRepositoryKey() {
        return this.repositoryKey;
    }

    public RuleDefinitionDto setRepositoryKey(String s) {
        Preconditions.checkArgument((s.length() <= 255 ? 1 : 0) != 0, (String)"Rule repository is too long: %s", (Object[])new Object[]{s});
        this.repositoryKey = s;
        return this;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public RuleDefinitionDto setRuleKey(String s) {
        Preconditions.checkArgument((s.length() <= 200 ? 1 : 0) != 0, (String)"Rule key is too long: %s", (Object[])new Object[]{s});
        this.ruleKey = s;
        return this;
    }

    public RuleDefinitionDto setRuleKey(RuleKey ruleKey) {
        this.repositoryKey = ruleKey.repository();
        this.ruleKey = ruleKey.rule();
        this.key = ruleKey;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public RuleDefinitionDto setDescription(String description) {
        this.description = description;
        return this;
    }

    public RuleDto.Format getDescriptionFormat() {
        return this.descriptionFormat;
    }

    public RuleDefinitionDto setDescriptionFormat(RuleDto.Format descriptionFormat) {
        this.descriptionFormat = descriptionFormat;
        return this;
    }

    public RuleStatus getStatus() {
        return this.status;
    }

    public RuleDefinitionDto setStatus(@Nullable RuleStatus s) {
        this.status = s;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RuleDefinitionDto setName(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 255 ? 1 : 0) != 0, (String)"Rule name is too long: %s", (Object[])new Object[]{s});
        this.name = s;
        return this;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public RuleDefinitionDto setConfigKey(@Nullable String configKey) {
        this.configKey = configKey;
        return this;
    }

    @CheckForNull
    public Integer getSeverity() {
        return this.severity;
    }

    @CheckForNull
    public String getSeverityString() {
        return this.severity != null ? SeverityUtil.getSeverityFromOrdinal(this.severity) : null;
    }

    public RuleDefinitionDto setSeverity(@Nullable String severity) {
        return this.setSeverity(severity != null ? Integer.valueOf(SeverityUtil.getOrdinalFromSeverity(severity)) : null);
    }

    public RuleDefinitionDto setSeverity(@Nullable Integer severity) {
        this.severity = severity;
        return this;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public RuleDefinitionDto setIsTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
        return this;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public RuleDefinitionDto setIsExternal(boolean isExternal) {
        this.isExternal = isExternal;
        return this;
    }

    @CheckForNull
    public String getLanguage() {
        return this.language;
    }

    public RuleDefinitionDto setLanguage(String language) {
        this.language = language;
        return this;
    }

    @CheckForNull
    public Integer getTemplateId() {
        return this.templateId;
    }

    public boolean isCustomRule() {
        return this.getTemplateId() != null;
    }

    public RuleDefinitionDto setTemplateId(@Nullable Integer templateId) {
        this.templateId = templateId;
        return this;
    }

    @CheckForNull
    public String getDefRemediationFunction() {
        return this.defRemediationFunction;
    }

    public RuleDefinitionDto setDefRemediationFunction(@Nullable String defaultRemediationFunction) {
        this.defRemediationFunction = defaultRemediationFunction;
        return this;
    }

    @CheckForNull
    public String getDefRemediationGapMultiplier() {
        return this.defRemediationGapMultiplier;
    }

    public RuleDefinitionDto setDefRemediationGapMultiplier(@Nullable String defaultRemediationGapMultiplier) {
        this.defRemediationGapMultiplier = defaultRemediationGapMultiplier;
        return this;
    }

    @CheckForNull
    public String getDefRemediationBaseEffort() {
        return this.defRemediationBaseEffort;
    }

    public RuleDefinitionDto setDefRemediationBaseEffort(@Nullable String defaultRemediationBaseEffort) {
        this.defRemediationBaseEffort = defaultRemediationBaseEffort;
        return this;
    }

    @CheckForNull
    public String getGapDescription() {
        return this.gapDescription;
    }

    public RuleDefinitionDto setGapDescription(@Nullable String s) {
        this.gapDescription = s;
        return this;
    }

    public Set<String> getSystemTags() {
        return this.systemTags == null ? new HashSet() : new TreeSet<String>(Arrays.asList(StringUtils.split((String)this.systemTags, (char)',')));
    }

    private String getSystemTagsField() {
        return this.systemTags;
    }

    void setSystemTagsField(String s) {
        this.systemTags = s;
    }

    public RuleDefinitionDto setSystemTags(Set<String> tags) {
        this.systemTags = tags.isEmpty() ? null : StringUtils.join(tags, (char)',');
        return this;
    }

    public int getType() {
        return this.type;
    }

    public RuleDefinitionDto setType(int type) {
        this.type = type;
        return this;
    }

    public RuleDefinitionDto setType(RuleType type) {
        this.type = type.getDbConstant();
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public RuleDefinitionDto setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public RuleDefinitionDto setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public RuleDto.Scope getScope() {
        return this.scope;
    }

    public RuleDefinitionDto setScope(RuleDto.Scope scope) {
        this.scope = scope;
        return this;
    }

    @CheckForNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    public RuleDefinitionDto setPluginKey(@Nullable String pluginKey) {
        this.pluginKey = pluginKey;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuleDefinitionDto)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RuleDefinitionDto other = (RuleDefinitionDto)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }

    public static RuleDto createFor(RuleKey key) {
        return new RuleDto().setId(new HashCodeBuilder(17, 37).append((Object)key.rule()).append((Object)key.repository()).toHashCode()).setRepositoryKey(key.repository()).setRuleKey(key.rule());
    }

    public String toString() {
        return "RuleDefinitionDto{id=" + this.id + ", repositoryKey='" + this.repositoryKey + '\'' + ", ruleKey='" + this.ruleKey + '\'' + ", description='" + this.description + '\'' + ", descriptionFormat=" + (Object)((Object)this.descriptionFormat) + ", status=" + this.status + ", name='" + this.name + '\'' + ", configKey='" + this.configKey + '\'' + ", severity=" + this.severity + ", isTemplate=" + this.isTemplate + ", language='" + this.language + '\'' + ", templateId=" + this.templateId + ", defRemediationFunction='" + this.defRemediationFunction + '\'' + ", defRemediationGapMultiplier='" + this.defRemediationGapMultiplier + '\'' + ", defRemediationBaseEffort='" + this.defRemediationBaseEffort + '\'' + ", gapDescription='" + this.gapDescription + '\'' + ", systemTags='" + this.systemTags + '\'' + ", type=" + this.type + ", key=" + this.key + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", scope=" + (Object)((Object)this.scope) + '}';
    }
}

