/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.rule;

import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleMetadataDto;

public class RuleDto {
    private final RuleDefinitionDto definition;
    private final RuleMetadataDto metadata;

    public RuleDto() {
        this(new RuleDefinitionDto(), new RuleMetadataDto());
    }

    public RuleDto(RuleDefinitionDto definition, RuleMetadataDto metadata) {
        this.definition = definition;
        this.metadata = metadata;
    }

    public RuleDefinitionDto getDefinition() {
        return this.definition;
    }

    public RuleMetadataDto getMetadata() {
        return this.metadata;
    }

    public RuleKey getKey() {
        if (this.definition.getKey() == null) {
            this.definition.setKey(RuleKey.of((String)this.getRepositoryKey(), (String)this.getRuleKey()));
        }
        return this.definition.getKey();
    }

    public Integer getId() {
        return this.definition.getId();
    }

    public RuleDto setId(Integer id) {
        this.definition.setId(id);
        this.metadata.setRuleId(id);
        return this;
    }

    public String getRepositoryKey() {
        return this.definition.getRepositoryKey();
    }

    public RuleDto setRepositoryKey(String s) {
        this.definition.setRepositoryKey(s);
        return this;
    }

    public String getRuleKey() {
        return this.definition.getRuleKey();
    }

    public RuleDto setRuleKey(String s) {
        this.definition.setRuleKey(s);
        return this;
    }

    @CheckForNull
    public String getPluginKey() {
        return this.definition.getPluginKey();
    }

    public RuleDto setPluginKey(@Nullable String s) {
        this.definition.setPluginKey(s);
        return this;
    }

    public String getDescription() {
        return this.definition.getDescription();
    }

    public RuleDto setDescription(String description) {
        this.definition.setDescription(description);
        return this;
    }

    public Format getDescriptionFormat() {
        return this.definition.getDescriptionFormat();
    }

    public RuleDto setDescriptionFormat(Format descriptionFormat) {
        this.definition.setDescriptionFormat(descriptionFormat);
        return this;
    }

    public RuleStatus getStatus() {
        return this.definition.getStatus();
    }

    public RuleDto setStatus(@Nullable RuleStatus s) {
        this.definition.setStatus(s);
        return this;
    }

    public String getName() {
        return this.definition.getName();
    }

    public RuleDto setName(@Nullable String s) {
        this.definition.setName(s);
        return this;
    }

    public String getConfigKey() {
        return this.definition.getConfigKey();
    }

    public RuleDto setConfigKey(@Nullable String configKey) {
        this.definition.setConfigKey(configKey);
        return this;
    }

    public Scope getScope() {
        return this.definition.getScope();
    }

    public RuleDto setScope(Scope scope) {
        this.definition.setScope(scope);
        return this;
    }

    @CheckForNull
    public Integer getSeverity() {
        return this.definition.getSeverity();
    }

    @CheckForNull
    public String getSeverityString() {
        return this.definition.getSeverityString();
    }

    public RuleDto setSeverity(@Nullable String severity) {
        this.definition.setSeverity(severity);
        return this;
    }

    public RuleDto setSeverity(@Nullable Integer severity) {
        this.definition.setSeverity(severity);
        return this;
    }

    public boolean isExternal() {
        return this.definition.isExternal();
    }

    public RuleDto setIsExternal(boolean isExternal) {
        this.definition.setIsExternal(isExternal);
        return this;
    }

    public boolean isTemplate() {
        return this.definition.isTemplate();
    }

    public RuleDto setIsTemplate(boolean isTemplate) {
        this.definition.setIsTemplate(isTemplate);
        return this;
    }

    @CheckForNull
    public String getLanguage() {
        return this.definition.getLanguage();
    }

    public RuleDto setLanguage(String language) {
        this.definition.setLanguage(language);
        return this;
    }

    @CheckForNull
    public Integer getTemplateId() {
        return this.definition.getTemplateId();
    }

    public RuleDto setTemplateId(@Nullable Integer templateId) {
        this.definition.setTemplateId(templateId);
        return this;
    }

    @CheckForNull
    public String getDefRemediationFunction() {
        return this.definition.getDefRemediationFunction();
    }

    public RuleDto setDefRemediationFunction(@Nullable String defaultRemediationFunction) {
        this.definition.setDefRemediationFunction(defaultRemediationFunction);
        return this;
    }

    @CheckForNull
    public String getDefRemediationGapMultiplier() {
        return this.definition.getDefRemediationGapMultiplier();
    }

    public RuleDto setDefRemediationGapMultiplier(@Nullable String defaultRemediationGapMultiplier) {
        this.definition.setDefRemediationGapMultiplier(defaultRemediationGapMultiplier);
        return this;
    }

    @CheckForNull
    public String getDefRemediationBaseEffort() {
        return this.definition.getDefRemediationBaseEffort();
    }

    public RuleDto setDefRemediationBaseEffort(@Nullable String defaultRemediationBaseEffort) {
        this.definition.setDefRemediationBaseEffort(defaultRemediationBaseEffort);
        return this;
    }

    @CheckForNull
    public String getGapDescription() {
        return this.definition.getGapDescription();
    }

    public RuleDto setGapDescription(@Nullable String s) {
        this.definition.setGapDescription(s);
        return this;
    }

    public RuleDto setSystemTags(Set<String> tags) {
        this.definition.setSystemTags(tags);
        return this;
    }

    public int getType() {
        return this.definition.getType();
    }

    public RuleDto setType(int type) {
        this.definition.setType(type);
        return this;
    }

    public RuleDto setType(RuleType type) {
        this.definition.setType(type);
        return this;
    }

    public Set<String> getSystemTags() {
        return this.definition.getSystemTags();
    }

    private void setSystemTagsField(String s) {
        this.definition.setSystemTagsField(s);
    }

    public long getCreatedAt() {
        return this.definition.getCreatedAt();
    }

    public RuleDto setCreatedAt(long createdAt) {
        this.definition.setCreatedAt(createdAt);
        this.metadata.setCreatedAt(createdAt);
        return this;
    }

    private void setCreatedAtFromDefinition(@Nullable Long createdAt) {
        if (createdAt != null && createdAt > this.definition.getCreatedAt()) {
            this.setCreatedAt(createdAt);
        }
    }

    private void setCreatedAtFromMetadata(@Nullable Long createdAt) {
        if (createdAt != null && createdAt > this.definition.getCreatedAt()) {
            this.setCreatedAt(createdAt);
        }
    }

    public long getUpdatedAt() {
        return this.definition.getUpdatedAt();
    }

    public RuleDto setUpdatedAt(long updatedAt) {
        this.definition.setUpdatedAt(updatedAt);
        this.metadata.setUpdatedAt(updatedAt);
        return this;
    }

    private void setUpdatedAtFromDefinition(@Nullable Long updatedAt) {
        if (updatedAt != null && updatedAt > this.definition.getUpdatedAt()) {
            this.setUpdatedAt(updatedAt);
        }
    }

    private void setUpdatedAtFromMetadata(@Nullable Long updatedAt) {
        if (updatedAt != null && updatedAt > this.definition.getUpdatedAt()) {
            this.setUpdatedAt(updatedAt);
        }
    }

    public String getOrganizationUuid() {
        return this.metadata.getOrganizationUuid();
    }

    public RuleDto setOrganizationUuid(String organizationUuid) {
        this.metadata.setOrganizationUuid(organizationUuid);
        return this;
    }

    @CheckForNull
    public String getNoteData() {
        return this.metadata.getNoteData();
    }

    public RuleDto setNoteData(@Nullable String s) {
        this.metadata.setNoteData(s);
        return this;
    }

    @CheckForNull
    public String getNoteUserUuid() {
        return this.metadata.getNoteUserUuid();
    }

    public RuleDto setNoteUserUuid(@Nullable String noteUserUuid) {
        this.metadata.setNoteUserUuid(noteUserUuid);
        return this;
    }

    @CheckForNull
    public Long getNoteCreatedAt() {
        return this.metadata.getNoteCreatedAt();
    }

    public RuleDto setNoteCreatedAt(@Nullable Long noteCreatedAt) {
        this.metadata.setNoteCreatedAt(noteCreatedAt);
        return this;
    }

    @CheckForNull
    public Long getNoteUpdatedAt() {
        return this.metadata.getNoteUpdatedAt();
    }

    public RuleDto setNoteUpdatedAt(@Nullable Long noteUpdatedAt) {
        this.metadata.setNoteUpdatedAt(noteUpdatedAt);
        return this;
    }

    @CheckForNull
    public String getRemediationFunction() {
        return this.metadata.getRemediationFunction();
    }

    public RuleDto setRemediationFunction(@Nullable String remediationFunction) {
        this.metadata.setRemediationFunction(remediationFunction);
        return this;
    }

    @CheckForNull
    public String getRemediationGapMultiplier() {
        return this.metadata.getRemediationGapMultiplier();
    }

    public RuleDto setRemediationGapMultiplier(@Nullable String remediationGapMultiplier) {
        this.metadata.setRemediationGapMultiplier(remediationGapMultiplier);
        return this;
    }

    @CheckForNull
    public String getRemediationBaseEffort() {
        return this.metadata.getRemediationBaseEffort();
    }

    public RuleDto setRemediationBaseEffort(@Nullable String remediationBaseEffort) {
        this.metadata.setRemediationBaseEffort(remediationBaseEffort);
        return this;
    }

    public Set<String> getTags() {
        return this.metadata.getTags();
    }

    private void setTagsField(String s) {
        this.metadata.setTagsField(s);
    }

    public RuleDto setTags(Set<String> tags) {
        this.metadata.setTags(tags);
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuleDto)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RuleDto other = (RuleDto)obj;
        return new EqualsBuilder().append((Object)this.getRepositoryKey(), (Object)other.getRepositoryKey()).append((Object)this.getRuleKey(), (Object)other.getRuleKey()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getRepositoryKey()).append((Object)this.getRuleKey()).toHashCode();
    }

    public String toString() {
        return "RuleDto{definition=" + this.definition + ", metadata=" + this.metadata + '}';
    }

    public static RuleDto createFor(RuleKey key) {
        return new RuleDto().setRepositoryKey(key.repository()).setRuleKey(key.rule());
    }

    public static enum Scope {
        MAIN,
        TEST,
        ALL;

    }

    public static enum Format {
        HTML,
        MARKDOWN;

    }
}

