/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.rule;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RuleMetadataDto {
    private int ruleId;
    private String organizationUuid;
    private String noteData;
    private String noteUserUuid;
    private Long noteCreatedAt;
    private Long noteUpdatedAt;
    private String remediationFunction;
    private String remediationGapMultiplier;
    private String remediationBaseEffort;
    private String tags;
    private long createdAt;
    private long updatedAt;

    public int getRuleId() {
        return this.ruleId;
    }

    public RuleMetadataDto setRuleId(int ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public RuleMetadataDto setOrganizationUuid(String organizationUuid) {
        this.organizationUuid = organizationUuid;
        return this;
    }

    @CheckForNull
    public String getNoteData() {
        return this.noteData;
    }

    public RuleMetadataDto setNoteData(@Nullable String s) {
        this.noteData = s;
        return this;
    }

    @CheckForNull
    public String getNoteUserUuid() {
        return this.noteUserUuid;
    }

    public RuleMetadataDto setNoteUserUuid(@Nullable String noteUserUuid) {
        this.noteUserUuid = noteUserUuid;
        return this;
    }

    @CheckForNull
    public Long getNoteCreatedAt() {
        return this.noteCreatedAt;
    }

    public RuleMetadataDto setNoteCreatedAt(@Nullable Long noteCreatedAt) {
        this.noteCreatedAt = noteCreatedAt;
        return this;
    }

    @CheckForNull
    public Long getNoteUpdatedAt() {
        return this.noteUpdatedAt;
    }

    public RuleMetadataDto setNoteUpdatedAt(@Nullable Long noteUpdatedAt) {
        this.noteUpdatedAt = noteUpdatedAt;
        return this;
    }

    @CheckForNull
    public String getRemediationFunction() {
        return this.remediationFunction;
    }

    public RuleMetadataDto setRemediationFunction(@Nullable String remediationFunction) {
        this.remediationFunction = remediationFunction;
        return this;
    }

    @CheckForNull
    public String getRemediationGapMultiplier() {
        return this.remediationGapMultiplier;
    }

    public RuleMetadataDto setRemediationGapMultiplier(@Nullable String remediationGapMultiplier) {
        this.remediationGapMultiplier = remediationGapMultiplier;
        return this;
    }

    @CheckForNull
    public String getRemediationBaseEffort() {
        return this.remediationBaseEffort;
    }

    public RuleMetadataDto setRemediationBaseEffort(@Nullable String remediationBaseEffort) {
        this.remediationBaseEffort = remediationBaseEffort;
        return this;
    }

    public Set<String> getTags() {
        return this.tags == null ? new HashSet() : new TreeSet<String>(Arrays.asList(StringUtils.split((String)this.tags, (char)',')));
    }

    String getTagsAsString() {
        return this.tags;
    }

    public RuleMetadataDto setTags(Set<String> tags) {
        String raw = tags.isEmpty() ? null : StringUtils.join(tags, (char)',');
        Preconditions.checkArgument((raw == null || raw.length() <= 4000 ? 1 : 0) != 0, (String)"Rule tags are too long: %s", (Object[])new Object[]{raw});
        this.tags = raw;
        return this;
    }

    private String getTagsField() {
        return this.tags;
    }

    void setTagsField(String s) {
        this.tags = s;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public RuleMetadataDto setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public RuleMetadataDto setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public String toString() {
        return "RuleMetadataDto{ruleId=" + this.ruleId + ", organizationUuid='" + this.organizationUuid + '\'' + ", noteData='" + this.noteData + '\'' + ", noteUserUuid='" + this.noteUserUuid + '\'' + ", noteCreatedAt=" + this.noteCreatedAt + ", noteUpdatedAt=" + this.noteUpdatedAt + ", remediationFunction='" + this.remediationFunction + '\'' + ", remediationGapMultiplier='" + this.remediationGapMultiplier + '\'' + ", remediationBaseEffort='" + this.remediationBaseEffort + '\'' + ", tags='" + this.tags + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }
}

