/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.rule;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.db.rule.RuleDefinitionDto;

public class RuleParamDto {
    private Integer id;
    private Integer ruleId;
    private String name;
    private String type;
    private String defaultValue;
    private String description;

    public Integer getId() {
        return this.id;
    }

    public RuleParamDto setId(Integer id) {
        this.id = id;
        return this;
    }

    public Integer getRuleId() {
        return this.ruleId;
    }

    public RuleParamDto setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RuleParamDto setName(String s) {
        Preconditions.checkArgument((s.length() <= 128 ? 1 : 0) != 0, (String)"Rule parameter name is too long: %s", (Object[])new Object[]{s});
        this.name = s;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public RuleParamDto setType(String type) {
        this.type = type;
        return this;
    }

    @CheckForNull
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public RuleParamDto setDefaultValue(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 4000 ? 1 : 0) != 0, (String)"Rule parameter default value is too long: %s", (Object[])new Object[]{s});
        this.defaultValue = s;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public RuleParamDto setDescription(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 4000 ? 1 : 0) != 0, (String)"Rule parameter description is too long: %s", (Object[])new Object[]{s});
        this.description = s;
        return this;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public static RuleParamDto createFor(RuleDefinitionDto rule) {
        return new RuleParamDto().setRuleId(rule.getId());
    }
}

