/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.source;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.commons.io.IOUtils;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.db.source.LineHashVersion;

public class FileSourceDto {
    private static final String SIZE_LIMIT_EXCEEDED_EXCEPTION_MESSAGE = "Protocol message was too large.  May be malicious.  Use CodedInputStream.setSizeLimit() to increase the size limit.";
    private static final Joiner LINE_RETURN_JOINER = Joiner.on((char)'\n');
    public static final Splitter LINES_HASHES_SPLITTER = Splitter.on((char)'\n');
    public static final int LINE_COUNT_NOT_POPULATED = -1;
    private Long id;
    private String projectUuid;
    private String fileUuid;
    private long createdAt;
    private long updatedAt;
    private String lineHashes;
    private int lineCount = -1;
    private String srcHash;
    private byte[] binaryData = new byte[0];
    private String dataType;
    private String dataHash;
    private String revision;
    private Integer lineHashesVersion;

    public Integer getLineHashesVersion() {
        return this.lineHashesVersion != null ? this.lineHashesVersion.intValue() : LineHashVersion.WITHOUT_SIGNIFICANT_CODE.getDbValue();
    }

    public FileSourceDto setLineHashesVersion(int lineHashesVersion) {
        this.lineHashesVersion = lineHashesVersion;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public FileSourceDto setId(Long id) {
        this.id = id;
        return this;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public FileSourceDto setProjectUuid(String projectUuid) {
        this.projectUuid = projectUuid;
        return this;
    }

    public String getFileUuid() {
        return this.fileUuid;
    }

    public FileSourceDto setFileUuid(String fileUuid) {
        this.fileUuid = fileUuid;
        return this;
    }

    @CheckForNull
    public String getDataHash() {
        return this.dataHash;
    }

    public FileSourceDto setDataHash(String s) {
        this.dataHash = s;
        return this;
    }

    public DbFileSources.Data decodeSourceData(byte[] binaryData) {
        try {
            return FileSourceDto.decodeRegularSourceData(binaryData);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to decompress and deserialize source data [id=%s,fileUuid=%s,projectUuid=%s]", this.id, this.fileUuid, this.projectUuid), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DbFileSources.Data decodeRegularSourceData(byte[] binaryData) throws IOException {
        try (LZ4BlockInputStream lz4Input = new LZ4BlockInputStream((InputStream)new ByteArrayInputStream(binaryData));){
            DbFileSources.Data data = DbFileSources.Data.parseFrom((InputStream)lz4Input);
            return data;
        }
        catch (InvalidProtocolBufferException e) {
            if (!SIZE_LIMIT_EXCEEDED_EXCEPTION_MESSAGE.equals(e.getMessage())) throw e;
            return FileSourceDto.decodeHugeSourceData(binaryData);
        }
    }

    private static DbFileSources.Data decodeHugeSourceData(byte[] binaryData) throws IOException {
        try (LZ4BlockInputStream lz4Input = new LZ4BlockInputStream((InputStream)new ByteArrayInputStream(binaryData));){
            CodedInputStream input = CodedInputStream.newInstance((InputStream)lz4Input);
            input.setSizeLimit(Integer.MAX_VALUE);
            DbFileSources.Data data = DbFileSources.Data.parseFrom(input);
            return data;
        }
    }

    public static byte[] encodeSourceData(DbFileSources.Data data) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        LZ4BlockOutputStream compressedOutput = new LZ4BlockOutputStream((OutputStream)byteOutput);
        try {
            data.writeTo((OutputStream)compressedOutput);
            compressedOutput.close();
            byte[] byArray = byteOutput.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to serialize and compress source data", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)compressedOutput);
        }
    }

    public static List<DbFileSources.Test> decodeTestData(byte[] binaryData) {
        return FileSourceDto.decodeTestData(new ByteArrayInputStream(binaryData));
    }

    public static List<DbFileSources.Test> decodeTestData(InputStream binaryInput) {
        ArrayList<DbFileSources.Test> arrayList;
        LZ4BlockInputStream lz4Input = null;
        ArrayList<DbFileSources.Test> tests = new ArrayList<DbFileSources.Test>();
        try {
            DbFileSources.Test currentTest;
            lz4Input = new LZ4BlockInputStream(binaryInput);
            do {
                if ((currentTest = DbFileSources.Test.parseDelimitedFrom((InputStream)lz4Input)) == null) continue;
                tests.add(currentTest);
            } while (currentTest != null);
            arrayList = tests;
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Fail to decompress and deserialize source data", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lz4Input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)lz4Input);
        return arrayList;
    }

    public static byte[] encodeTestData(List<DbFileSources.Test> tests) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        LZ4BlockOutputStream compressedOutput = new LZ4BlockOutputStream((OutputStream)byteOutput);
        try {
            for (DbFileSources.Test test : tests) {
                test.writeDelimitedTo((OutputStream)compressedOutput);
            }
            compressedOutput.close();
            Object object = byteOutput.toByteArray();
            return object;
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to serialize and compress source tests", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)compressedOutput);
        }
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public FileSourceDto setBinaryData(byte[] data) {
        this.binaryData = data;
        return this;
    }

    public DbFileSources.Data getSourceData() {
        return this.decodeSourceData(this.binaryData);
    }

    public FileSourceDto setSourceData(DbFileSources.Data data) {
        this.dataType = "SOURCE";
        this.binaryData = FileSourceDto.encodeSourceData(data);
        return this;
    }

    public List<DbFileSources.Test> getTestData() {
        return FileSourceDto.decodeTestData(this.binaryData);
    }

    public FileSourceDto setTestData(List<DbFileSources.Test> data) {
        this.dataType = "TEST";
        this.binaryData = FileSourceDto.encodeTestData(data);
        return this;
    }

    public String getRawLineHashes() {
        return this.lineHashes;
    }

    public void setRawLineHashes(@Nullable String lineHashes) {
        this.lineHashes = lineHashes;
    }

    public List<String> getLineHashes() {
        if (this.lineHashes == null) {
            return Collections.emptyList();
        }
        return LINES_HASHES_SPLITTER.splitToList((CharSequence)this.lineHashes);
    }

    public int getLineCount() {
        if (this.lineCount == -1) {
            return this.getLineHashes().size();
        }
        return this.lineCount;
    }

    public FileSourceDto setLineHashes(@Nullable List<String> lineHashes) {
        if (lineHashes == null) {
            this.lineHashes = null;
            this.lineCount = 0;
        } else if (lineHashes.isEmpty()) {
            this.lineHashes = null;
            this.lineCount = 1;
        } else {
            this.lineHashes = LINE_RETURN_JOINER.join(lineHashes);
            this.lineCount = lineHashes.size();
        }
        return this;
    }

    @CheckForNull
    public String getSrcHash() {
        return this.srcHash;
    }

    public FileSourceDto setSrcHash(@Nullable String srcHash) {
        this.srcHash = srcHash;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public FileSourceDto setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public FileSourceDto setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public String getDataType() {
        return this.dataType;
    }

    public FileSourceDto setDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    public String getRevision() {
        return this.revision;
    }

    public FileSourceDto setRevision(@Nullable String revision) {
        this.revision = revision;
        return this;
    }

    public static class Type {
        public static final String SOURCE = "SOURCE";
        public static final String TEST = "TEST";

        private Type() {
        }
    }
}

